/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.response.CompressedShuffleBlock;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.com.google.common.collect.Lists;
import org.apache.uniffle.com.google.common.collect.Queues;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.common.util.ChecksumUtils;
import org.apache.uniffle.common.util.IdHelper;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.apache.uniffle.storage.factory.ShuffleHandlerFactory;
import org.apache.uniffle.storage.handler.api.ClientReadHandler;
import org.apache.uniffle.storage.request.CreateShuffleReadHandlerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleReadClientImpl
implements ShuffleReadClient {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleReadClientImpl.class);
    private List<ShuffleServerInfo> shuffleServerInfoList;
    private int shuffleId;
    private int partitionId;
    private ByteBuffer readBuffer;
    private Roaring64NavigableMap blockIdBitmap;
    private Roaring64NavigableMap taskIdBitmap;
    private Roaring64NavigableMap pendingBlockIds;
    private Roaring64NavigableMap processedBlockIds = Roaring64NavigableMap.bitmapOf(new long[0]);
    private Queue<BufferSegment> bufferSegmentQueue = Queues.newLinkedBlockingQueue();
    private AtomicLong readDataTime = new AtomicLong(0L);
    private AtomicLong copyTime = new AtomicLong(0L);
    private AtomicLong crcCheckTime = new AtomicLong(0L);
    private ClientReadHandler clientReadHandler;
    private IdHelper idHelper;

    public ShuffleReadClientImpl(String appId, int shuffleId, int partitionId, int partitionNumPerRange, int partitionNum, String storageBasePath, Roaring64NavigableMap blockIdBitmap, Roaring64NavigableMap taskIdBitmap, List<ShuffleServerInfo> shuffleServerInfoList, Configuration hadoopConf, IdHelper idHelper, ShuffleDataDistributionType dataDistributionType, boolean expectedTaskIdsBitmapFilterEnable, RssConf rssConf) {
        int indexReadLimit = rssConf.get(RssClientConf.RSS_INDEX_READ_LIMIT);
        String storageType = rssConf.get(RssClientConf.RSS_STORAGE_TYPE);
        long readBufferSize = rssConf.getSizeAsBytes(RssClientConf.RSS_CLIENT_READ_BUFFER_SIZE.key(), RssClientConf.RSS_CLIENT_READ_BUFFER_SIZE.defaultValue());
        if (readBufferSize > Integer.MAX_VALUE) {
            LOG.warn(RssClientConf.RSS_CLIENT_READ_BUFFER_SIZE.key() + " can support 2g as max");
            readBufferSize = Integer.MAX_VALUE;
        }
        boolean offHeapEnabled = rssConf.get(RssClientConf.OFF_HEAP_MEMORY_ENABLE);
        this.init(storageType, appId, shuffleId, partitionId, indexReadLimit, partitionNumPerRange, partitionNum, (int)readBufferSize, storageBasePath, blockIdBitmap, taskIdBitmap, shuffleServerInfoList, hadoopConf, idHelper, dataDistributionType, expectedTaskIdsBitmapFilterEnable, offHeapEnabled, rssConf);
    }

    public ShuffleReadClientImpl(String appId, int shuffleId, int partitionId, int partitionNumPerRange, int partitionNum, String storageBasePath, Roaring64NavigableMap blockIdBitmap, Roaring64NavigableMap taskIdBitmap, List<ShuffleServerInfo> shuffleServerInfoList, Configuration hadoopConf, IdHelper idHelper, RssConf rssConf) {
        this(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, storageBasePath, blockIdBitmap, taskIdBitmap, shuffleServerInfoList, hadoopConf, idHelper, ShuffleDataDistributionType.NORMAL, false, rssConf);
    }

    private void init(String storageType, String appId, int shuffleId, int partitionId, int indexReadLimit, int partitionNumPerRange, int partitionNum, int readBufferSize, String storageBasePath, Roaring64NavigableMap blockIdBitmap, Roaring64NavigableMap taskIdBitmap, List<ShuffleServerInfo> shuffleServerInfoList, Configuration hadoopConf, IdHelper idHelper, ShuffleDataDistributionType dataDistributionType, boolean expectedTaskIdsBitmapFilterEnable, boolean offHeapEnabled, RssConf rssConf) {
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.blockIdBitmap = blockIdBitmap;
        this.taskIdBitmap = taskIdBitmap;
        this.idHelper = idHelper;
        this.shuffleServerInfoList = shuffleServerInfoList;
        CreateShuffleReadHandlerRequest request = new CreateShuffleReadHandlerRequest();
        request.setStorageType(storageType);
        request.setAppId(appId);
        request.setShuffleId(shuffleId);
        request.setPartitionId(partitionId);
        request.setIndexReadLimit(indexReadLimit);
        request.setPartitionNumPerRange(partitionNumPerRange);
        request.setPartitionNum(partitionNum);
        request.setReadBufferSize(readBufferSize);
        request.setStorageBasePath(storageBasePath);
        request.setShuffleServerInfoList(shuffleServerInfoList);
        request.setHadoopConf(hadoopConf);
        request.setExpectBlockIds(blockIdBitmap);
        request.setProcessBlockIds(this.processedBlockIds);
        request.setDistributionType(dataDistributionType);
        request.setIdHelper(idHelper);
        request.setExpectTaskIds(taskIdBitmap);
        request.setClientConf(rssConf);
        if (expectedTaskIdsBitmapFilterEnable) {
            request.useExpectedTaskIdsBitmapFilter();
        }
        if (offHeapEnabled) {
            request.enableOffHeap();
        }
        ArrayList removeBlockIds = Lists.newArrayList();
        blockIdBitmap.forEach(bid -> {
            if (!taskIdBitmap.contains(idHelper.getTaskAttemptId(bid))) {
                removeBlockIds.add(bid);
            }
        });
        Iterator iterator = removeBlockIds.iterator();
        while (iterator.hasNext()) {
            long rid = (Long)iterator.next();
            blockIdBitmap.removeLong(rid);
        }
        this.pendingBlockIds = RssUtils.cloneBitMap(blockIdBitmap);
        this.clientReadHandler = ShuffleHandlerFactory.getInstance().createShuffleReadHandler(request);
    }

    public ShuffleReadClientImpl(String storageType, String appId, int shuffleId, int partitionId, int indexReadLimit, int partitionNumPerRange, int partitionNum, int readBufferSize, String storageBasePath, Roaring64NavigableMap blockIdBitmap, Roaring64NavigableMap taskIdBitmap, List<ShuffleServerInfo> shuffleServerInfoList, Configuration hadoopConf, IdHelper idHelper) {
        RssConf rssConf = new RssConf();
        rssConf.set(RssClientConf.RSS_STORAGE_TYPE, storageType);
        rssConf.set(RssClientConf.RSS_INDEX_READ_LIMIT, indexReadLimit);
        rssConf.set(RssClientConf.RSS_CLIENT_READ_BUFFER_SIZE, String.valueOf(readBufferSize));
        this.init(storageType, appId, shuffleId, partitionId, indexReadLimit, partitionNumPerRange, partitionNum, readBufferSize, storageBasePath, blockIdBitmap, taskIdBitmap, shuffleServerInfoList, hadoopConf, idHelper, ShuffleDataDistributionType.NORMAL, false, false, rssConf);
    }

    @Override
    public CompressedShuffleBlock readShuffleBlockData() {
        if (this.blockIdBitmap.isEmpty()) {
            return null;
        }
        if (this.pendingBlockIds.isEmpty()) {
            return null;
        }
        if (this.bufferSegmentQueue.isEmpty() && this.read() <= 0) {
            return null;
        }
        BufferSegment bs = null;
        while ((bs = this.bufferSegmentQueue.poll()) != null) {
            if (!this.processedBlockIds.contains(bs.getBlockId()) && this.blockIdBitmap.contains(bs.getBlockId()) && this.taskIdBitmap.contains(bs.getTaskAttemptId())) {
                long expectedCrc = -1L;
                long actualCrc = -1L;
                try {
                    long start = System.currentTimeMillis();
                    expectedCrc = bs.getCrc();
                    actualCrc = ChecksumUtils.getCrc32(this.readBuffer, bs.getOffset(), bs.getLength());
                    this.crcCheckTime.addAndGet(System.currentTimeMillis() - start);
                }
                catch (Exception e) {
                    LOG.warn("Can't read data for blockId[" + bs.getBlockId() + "]", (Throwable)e);
                }
                if (expectedCrc != actualCrc) {
                    String errMsg = "Unexpected crc value for blockId[" + bs.getBlockId() + "], expected:" + expectedCrc + ", actual:" + actualCrc;
                    if (this.shuffleServerInfoList.size() > 1) {
                        LOG.warn(errMsg);
                        this.clientReadHandler.updateConsumedBlockInfo(bs, true);
                        continue;
                    }
                    throw new RssFetchFailedException(errMsg);
                }
                this.processedBlockIds.addLong(bs.getBlockId());
                this.pendingBlockIds.removeLong(bs.getBlockId());
                this.clientReadHandler.updateConsumedBlockInfo(bs, false);
                break;
            }
            this.clientReadHandler.updateConsumedBlockInfo(bs, true);
            this.processedBlockIds.addLong(bs.getBlockId());
            this.pendingBlockIds.removeLong(bs.getBlockId());
        }
        if (bs != null) {
            ByteBuffer compressedBuffer = this.readBuffer.duplicate();
            compressedBuffer.position(bs.getOffset());
            compressedBuffer.limit(bs.getOffset() + bs.getLength());
            return new CompressedShuffleBlock(compressedBuffer, bs.getUncompressLength());
        }
        return this.readShuffleBlockData();
    }

    @VisibleForTesting
    protected Roaring64NavigableMap getProcessedBlockIds() {
        return this.processedBlockIds;
    }

    private int read() {
        long start = System.currentTimeMillis();
        ShuffleDataResult sdr = this.clientReadHandler.readShuffleData();
        this.readDataTime.addAndGet(System.currentTimeMillis() - start);
        if (sdr == null) {
            return 0;
        }
        if (this.readBuffer != null) {
            RssUtils.releaseByteBuffer(this.readBuffer);
        }
        this.readBuffer = sdr.getDataBuffer();
        if (this.readBuffer == null || this.readBuffer.capacity() == 0) {
            return 0;
        }
        this.bufferSegmentQueue.addAll(sdr.getBufferSegments());
        return sdr.getBufferSegments().size();
    }

    @Override
    public void checkProcessedBlockIds() {
        RssUtils.checkProcessedBlockIds(this.blockIdBitmap, this.processedBlockIds);
    }

    @Override
    public void close() {
        if (this.readBuffer != null) {
            RssUtils.releaseByteBuffer(this.readBuffer);
        }
        if (this.clientReadHandler != null) {
            this.clientReadHandler.close();
        }
    }

    @Override
    public void logStatics() {
        LOG.info("Metrics for shuffleId[" + this.shuffleId + "], partitionId[" + this.partitionId + "], read data cost " + this.readDataTime + " ms, copy data cost " + this.copyTime + " ms, crc check cost " + this.crcCheckTime + " ms");
        this.clientReadHandler.logConsumedBlockInfo();
    }
}

