/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import java.util.concurrent.ThreadFactory;
import org.apache.uniffle.common.netty.IOMode;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.io.netty.buffer.ByteBuf;
import org.apache.uniffle.io.netty.buffer.PooledByteBufAllocator;
import org.apache.uniffle.io.netty.channel.Channel;
import org.apache.uniffle.io.netty.channel.ChannelFuture;
import org.apache.uniffle.io.netty.channel.ChannelHandlerContext;
import org.apache.uniffle.io.netty.channel.EventLoopGroup;
import org.apache.uniffle.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.uniffle.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.uniffle.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.uniffle.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.uniffle.io.netty.util.internal.PlatformDependent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUtils {
    private static final Logger logger = LoggerFactory.getLogger(NettyUtils.class);

    public static EventLoopGroup createEventLoop(IOMode mode, int numThreads, String threadPrefix) {
        ThreadFactory threadFactory = ThreadUtils.getNettyThreadFactory(threadPrefix);
        switch (mode) {
            case NIO: {
                return new NioEventLoopGroup(numThreads, threadFactory);
            }
            case EPOLL: {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static Class<? extends Channel> getClientChannelClass(IOMode mode) {
        switch (mode) {
            case NIO: {
                return NioSocketChannel.class;
            }
            case EPOLL: {
                return EpollSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static PooledByteBufAllocator createPooledByteBufAllocator(boolean allowDirectBufs, boolean allowCache, int numCores) {
        if (numCores == 0) {
            numCores = Runtime.getRuntime().availableProcessors();
        }
        return new PooledByteBufAllocator(allowDirectBufs && PlatformDependent.directBufferPreferred(), Math.min(PooledByteBufAllocator.defaultNumHeapArena(), numCores), Math.min(PooledByteBufAllocator.defaultNumDirectArena(), allowDirectBufs ? numCores : 0), PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), allowCache ? PooledByteBufAllocator.defaultSmallCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultNormalCacheSize() : 0, allowCache && PooledByteBufAllocator.defaultUseCacheForAllThreads());
    }

    public static String getRemoteAddress(Channel channel) {
        if (channel != null && channel.remoteAddress() != null) {
            return channel.remoteAddress().toString();
        }
        return "<unknown remote>";
    }

    public static ChannelFuture writeResponseMsg(ChannelHandlerContext ctx, Message msg, boolean doWriteType) {
        ByteBuf responseMsgBuf = ctx.alloc().buffer(msg.encodedLength());
        try {
            if (doWriteType) {
                responseMsgBuf.writeByte(msg.type().id());
            }
            msg.encode(responseMsgBuf);
            return ctx.writeAndFlush(responseMsgBuf);
        }
        catch (Throwable ex) {
            logger.warn("Caught exception, releasing ByteBuf", ex);
            responseMsgBuf.release();
            throw ex;
        }
    }

    public static String getServerConnectionInfo(ChannelHandlerContext ctx) {
        return NettyUtils.getServerConnectionInfo(ctx.channel());
    }

    public static String getServerConnectionInfo(Channel channel) {
        return String.format("[%s -> %s]", channel.localAddress(), channel.remoteAddress());
    }
}

