/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import java.util.Set;
import org.apache.uniffle.common.exception.NotRetryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RetryUtils.class);

    public static <T> T retry(RetryCmd<T> cmd, long intervalMs, int retryTimes) throws Throwable {
        return RetryUtils.retry(cmd, null, intervalMs, retryTimes, null);
    }

    public static <T> T retry(RetryCmd<T> cmd, long intervalMs, int retryTimes, Set<Class<? extends Throwable>> exceptionClasses) throws Throwable {
        return RetryUtils.retry(cmd, null, intervalMs, retryTimes, exceptionClasses);
    }

    public static <T> T retry(RetryCmd<T> cmd, RetryCallBack callBack, long intervalMs, int retryTimes, Set<Class<? extends Throwable>> exceptionClasses) throws Throwable {
        int retry = 0;
        while (true) {
            try {
                return cmd.execute();
            }
            catch (Throwable t) {
                if (exceptionClasses != null && !RetryUtils.isInstanceOf(exceptionClasses, t) || ++retry >= retryTimes || t instanceof NotRetryException) {
                    throw t;
                }
                LOG.info("Retry due to Throwable, " + t.getClass().getName() + " " + t.getMessage());
                LOG.info("Waiting " + intervalMs + " milliseconds before next connection attempt.");
                Thread.sleep(intervalMs);
                if (callBack == null) continue;
                callBack.execute();
                continue;
            }
            break;
        }
    }

    private static boolean isInstanceOf(Set<Class<? extends Throwable>> classes, Throwable t) {
        for (Class<? extends Throwable> c : classes) {
            if (!c.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public static interface RetryCallBack {
        public void execute() throws Throwable;
    }

    public static interface RetryCmd<T> {
        public T execute() throws Throwable;
    }
}

