/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.guava.annotations.VisibleForTesting;
import org.apache.uniffle.guava.collect.Queues;
import org.apache.uniffle.server.FlushEventHandler;
import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.storage.StorageManager;
import org.apache.uniffle.storage.common.HadoopStorage;
import org.apache.uniffle.storage.common.LocalStorage;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.util.StorageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlushEventHandler
implements FlushEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFlushEventHandler.class);
    private final ShuffleServerConf shuffleServerConf;
    private final StorageManager storageManager;
    private Executor localFileThreadPoolExecutor;
    private Executor hadoopThreadPoolExecutor;
    private Executor fallbackThreadPoolExecutor;
    private final StorageType storageType;
    protected final BlockingQueue<ShuffleDataFlushEvent> flushQueue = Queues.newLinkedBlockingQueue();
    private Consumer<ShuffleDataFlushEvent> eventConsumer;
    private volatile boolean stopped = false;

    public DefaultFlushEventHandler(ShuffleServerConf conf, StorageManager storageManager, Consumer<ShuffleDataFlushEvent> eventConsumer) {
        this.shuffleServerConf = conf;
        this.storageType = StorageType.valueOf((String)((org.apache.uniffle.common.StorageType)this.shuffleServerConf.get(RssBaseConf.RSS_STORAGE_TYPE)).name());
        this.storageManager = storageManager;
        this.eventConsumer = eventConsumer;
        this.initFlushEventExecutor();
    }

    @Override
    public void handle(ShuffleDataFlushEvent event) {
        if (!this.flushQueue.offer(event)) {
            LOG.warn("Flush queue is full, discard event: " + event);
        } else {
            ShuffleServerMetrics.gaugeEventQueueSize.inc();
        }
    }

    private void handleEventAndUpdateMetrics(ShuffleDataFlushEvent event, boolean isLocalFile) {
        try {
            this.eventConsumer.accept(event);
        }
        finally {
            if (isLocalFile) {
                ShuffleServerMetrics.counterLocalFileEventFlush.inc();
            } else {
                ShuffleServerMetrics.counterHadoopEventFlush.inc();
            }
        }
    }

    protected void initFlushEventExecutor() {
        int poolSize;
        if (StorageType.withLocalfile((StorageType)this.storageType)) {
            poolSize = this.shuffleServerConf.getInteger(ShuffleServerConf.SERVER_FLUSH_LOCALFILE_THREAD_POOL_SIZE);
            this.localFileThreadPoolExecutor = this.createFlushEventExecutor(poolSize, "LocalFileFlushEventThreadPool");
        }
        if (StorageType.withHadoop((StorageType)this.storageType)) {
            poolSize = this.shuffleServerConf.getInteger(ShuffleServerConf.SERVER_FLUSH_HADOOP_THREAD_POOL_SIZE);
            this.hadoopThreadPoolExecutor = this.createFlushEventExecutor(poolSize, "HadoopFlushEventThreadPool");
        }
        this.fallbackThreadPoolExecutor = this.createFlushEventExecutor(5, "FallBackFlushEventThreadPool");
        this.startEventProcessor();
    }

    private void startEventProcessor() {
        Thread processEventThread = new Thread(this::eventLoop);
        processEventThread.setName("ProcessEventThread");
        processEventThread.setDaemon(true);
        processEventThread.start();
    }

    protected void eventLoop() {
        while (!this.stopped && !Thread.currentThread().isInterrupted()) {
            this.processNextEvent();
        }
    }

    protected void processNextEvent() {
        try {
            ShuffleDataFlushEvent event = this.flushQueue.take();
            Storage storage = this.storageManager.selectStorage(event);
            if (storage instanceof HadoopStorage) {
                this.hadoopThreadPoolExecutor.execute(() -> this.handleEventAndUpdateMetrics(event, false));
            } else if (storage instanceof LocalStorage) {
                this.localFileThreadPoolExecutor.execute(() -> this.handleEventAndUpdateMetrics(event, true));
            } else {
                this.fallbackThreadPoolExecutor.execute(() -> event.doCleanup());
                LOG.error("Found unexpected storage type, will not flush for event {}.", (Object)event);
            }
        }
        catch (Exception e) {
            LOG.error("Exception happened when process event.", (Throwable)e);
        }
    }

    protected Executor createFlushEventExecutor(int poolSize, String threadFactoryName) {
        int waitQueueSize = this.shuffleServerConf.getInteger(ShuffleServerConf.SERVER_FLUSH_THREAD_POOL_QUEUE_SIZE);
        LinkedBlockingQueue<Runnable> waitQueue = Queues.newLinkedBlockingQueue(waitQueueSize);
        long keepAliveTime = this.shuffleServerConf.getLong(ShuffleServerConf.SERVER_FLUSH_THREAD_ALIVE);
        return new ThreadPoolExecutor(poolSize, poolSize, keepAliveTime, TimeUnit.SECONDS, waitQueue, ThreadUtils.getThreadFactory((String)threadFactoryName));
    }

    @Override
    public int getEventNumInFlush() {
        return this.flushQueue.size();
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    @VisibleForTesting
    public Executor getFallbackThreadPoolExecutor() {
        return this.fallbackThreadPoolExecutor;
    }
}

