/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.factory;

import java.util.Map;
import org.apache.uniffle.client.api.ShuffleServerClient;
import org.apache.uniffle.client.impl.grpc.ShuffleServerGrpcClient;
import org.apache.uniffle.client.impl.grpc.ShuffleServerGrpcNettyClient;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.util.JavaUtils;

public class ShuffleServerClientFactory {
    private Map<String, Map<ShuffleServerInfo, ShuffleServerClient>> clients = JavaUtils.newConcurrentMap();

    private ShuffleServerClientFactory() {
    }

    public static ShuffleServerClientFactory getInstance() {
        return LazyHolder.INSTANCE;
    }

    private ShuffleServerClient createShuffleServerClient(String clientType, ShuffleServerInfo shuffleServerInfo, RssConf rssConf) {
        if (clientType.equalsIgnoreCase(ClientType.GRPC.name())) {
            return new ShuffleServerGrpcClient(shuffleServerInfo.getHost(), shuffleServerInfo.getGrpcPort());
        }
        if (clientType.equalsIgnoreCase(ClientType.GRPC_NETTY.name())) {
            return new ShuffleServerGrpcNettyClient(rssConf, shuffleServerInfo.getHost(), shuffleServerInfo.getGrpcPort(), shuffleServerInfo.getNettyPort());
        }
        throw new UnsupportedOperationException("Unsupported client type " + clientType);
    }

    public synchronized ShuffleServerClient getShuffleServerClient(String clientType, ShuffleServerInfo shuffleServerInfo) {
        return this.getShuffleServerClient(clientType, shuffleServerInfo, new RssConf());
    }

    public synchronized ShuffleServerClient getShuffleServerClient(String clientType, ShuffleServerInfo shuffleServerInfo, RssConf rssConf) {
        this.clients.putIfAbsent(clientType, JavaUtils.newConcurrentMap());
        Map<ShuffleServerInfo, ShuffleServerClient> serverToClients = this.clients.get(clientType);
        if (serverToClients.get(shuffleServerInfo) == null) {
            serverToClients.put(shuffleServerInfo, this.createShuffleServerClient(clientType, shuffleServerInfo, rssConf));
        }
        return serverToClients.get(shuffleServerInfo);
    }

    public synchronized void cleanupCache() {
        this.clients.values().stream().flatMap(x -> x.values().stream()).forEach(ShuffleServerClient::close);
        this.clients = JavaUtils.newConcurrentMap();
    }

    private static class LazyHolder {
        static final ShuffleServerClientFactory INSTANCE = new ShuffleServerClientFactory();

        private LazyHolder() {
        }
    }
}

