/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.strategy.assignment;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.guava.base.Objects;

public class PartitionRangeAssignment {
    private final SortedMap<PartitionRange, List<ServerNode>> assignments;

    public PartitionRangeAssignment(SortedMap<PartitionRange, List<ServerNode>> assignments) {
        this.assignments = assignments;
    }

    public List<RssProtos.PartitionRangeAssignment> convertToGrpcProto() {
        ArrayList<RssProtos.PartitionRangeAssignment> praList = new ArrayList<RssProtos.PartitionRangeAssignment>();
        if (this.assignments == null) {
            return praList;
        }
        for (Map.Entry<PartitionRange, List<ServerNode>> entry : this.assignments.entrySet()) {
            int start = entry.getKey().getStart();
            int end = entry.getKey().getEnd();
            RssProtos.PartitionRangeAssignment partitionRangeAssignment = RssProtos.PartitionRangeAssignment.newBuilder().setStartPartition(start).setEndPartition(end).addAllServer((Iterable)entry.getValue().stream().map(ServerNode::convertToGrpcProto).collect(Collectors.toList())).build();
            praList.add(partitionRangeAssignment);
        }
        return praList;
    }

    public SortedMap<PartitionRange, List<ServerNode>> getAssignments() {
        return this.assignments;
    }

    public boolean isEmpty() {
        return this.assignments == null || this.assignments.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionRangeAssignment that = (PartitionRangeAssignment)o;
        return Objects.equal(this.assignments, that.assignments);
    }

    public int hashCode() {
        return Objects.hashCode(this.assignments);
    }
}

