/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.hadoop.shim;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocator;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class HadoopShimImpl {
    private static final Log LOG = LogFactory.getLog(HadoopShimImpl.class);

    public static ShuffleClientMetrics createShuffleClientMetrics(TaskAttemptID taskAttemptID, JobConf jobConf) {
        try {
            Constructor constructor = ShuffleClientMetrics.class.getDeclaredConstructor(TaskAttemptID.class, JobConf.class);
            constructor.setAccessible(true);
            return (ShuffleClientMetrics)constructor.newInstance(taskAttemptID, jobConf);
        }
        catch (Exception e) {
            LOG.warn((Object)"Construct ShuffleClientMetrics fail, caused by {}", (Throwable)e);
            return null;
        }
    }

    public static RMContainerAllocator createRMContainerAllocator(ClientService clientService, AppContext context) {
        return new RMContainerAllocator(clientService, context){

            protected AllocateResponse makeRemoteRequest() throws YarnException, IOException {
                AllocateResponse response = super.makeRemoteRequest();
                response.getUpdatedNodes().clear();
                return response;
            }
        };
    }
}

