/*
 * Decompiled with CFR 0.152.
 */
package com.werken.xpath.impl;

import com.werken.xpath.ContextSupport;
import com.werken.xpath.impl.Context;
import com.werken.xpath.impl.ParentStep;
import com.werken.xpath.impl.Predicate;
import com.werken.xpath.impl.Step;
import com.werken.xpath.util.Partition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public abstract class UnAbbrStep
extends Step {
    private String _axis = null;
    private List _predicates = null;

    public UnAbbrStep(String axis) {
        this._axis = axis;
    }

    public Step addPredicate(Predicate pred) {
        if (this._predicates == null) {
            this._predicates = new ArrayList();
        }
        this._predicates.add(pred);
        return this;
    }

    private List applyPredicates(List nodeSet, ContextSupport support) {
        List results = nodeSet;
        if (this._predicates == null) {
            return nodeSet;
        }
        Iterator predIter = this._predicates.iterator();
        Predicate eachPred = null;
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            results = eachPred.evaluateOn(results, support, this._axis);
        }
        return results;
    }

    public Context applyTo(Context context) {
        if (context.isEmpty()) {
            return context;
        }
        List results = this.applyTo(context.getNodeSet(), context.getContextSupport(), this.getAxis(), true);
        context.setNodeSet(results);
        return context;
    }

    public List applyTo(List nodeSet, ContextSupport support, String axis) {
        return this.applyTo(nodeSet, support, axis, false);
    }

    public List applyTo(List nodeSet, ContextSupport support, String axis, boolean doPreds) {
        ArrayList aggregateResults = new ArrayList();
        List results = null;
        Iterator nodeIter = nodeSet.iterator();
        Object each = null;
        while (nodeIter.hasNext()) {
            each = nodeIter.next();
            if ("self".equals(axis)) {
                results = this.applyToSelf(each, support);
            } else if ("ancestor".equals(axis)) {
                results = this.applyToAncestor(each, support);
            } else if ("ancestor-or-self".equals(axis)) {
                results = this.applyToAncestorOrSelf(each, support);
            } else if ("attribute".equals(axis)) {
                results = this.applyToAttribute(each, support);
            } else if ("child".equals(axis)) {
                results = this.applyToChild(each, support);
            } else if ("descendant".equals(axis)) {
                results = this.applyToDescendant(each, support);
            } else if ("descendant-or-self".equals(axis)) {
                results = this.applyToDescendantOrSelf(each, support);
            } else if ("following".equals(axis)) {
                results = this.applyToFollowing(each, support);
            } else if ("following-sibling".equals(axis)) {
                results = this.applyToFollowingSibling(each, support);
            } else if (!"namespace".equals(axis)) {
                results = "parent".equals(axis) ? this.applyToParent(each, support) : ("preceeding".equals(axis) ? this.applyToPreceeding(each, support) : ("preceeding-sibling".equals(axis) ? this.applyToPreceedingSibling(each, support) : Collections.EMPTY_LIST));
            }
            if (doPreds) {
                aggregateResults.addAll(this.applyPredicates(results, support));
                continue;
            }
            aggregateResults.addAll(results);
        }
        return aggregateResults;
    }

    public List applyToAncestor(Object node, ContextSupport support) {
        ArrayList results = new ArrayList();
        results.addAll(this.applyToParent(node, support));
        Object parent = ParentStep.findParent(node);
        if (parent != null) {
            results.addAll(this.applyToAncestor(parent, support));
        }
        return results;
    }

    public List applyToAncestorOrSelf(Object node, ContextSupport support) {
        ArrayList results = new ArrayList();
        results.addAll(this.applyToSelf(node, support));
        results.addAll(this.applyToAncestor(node, support));
        return results;
    }

    public List applyToAttribute(Object node, ContextSupport support) {
        return Collections.EMPTY_LIST;
    }

    public List applyToChild(Object node, ContextSupport support) {
        return Collections.EMPTY_LIST;
    }

    public List applyToDescendant(Object node, ContextSupport support) {
        ArrayList results = new ArrayList();
        results.addAll(this.applyToChild(node, support));
        if (node instanceof Element) {
            List children = ((Element)node).getMixedContent();
            results.addAll(this.applyTo(children, support, "descendant"));
        } else if (node instanceof Document) {
            List children = ((Document)node).getMixedContent();
            results.addAll(this.applyTo(children, support, "descendant"));
        }
        return results;
    }

    public List applyToDescendantOrSelf(Object node, ContextSupport support) {
        ArrayList results = new ArrayList();
        results.addAll(this.applyToSelf(node, support));
        if (node instanceof Element) {
            List children = ((Element)node).getMixedContent();
            results.addAll(this.applyTo(children, support, "descendant-or-self"));
        } else if (node instanceof Document) {
            List children = ((Document)node).getMixedContent();
            results.addAll(this.applyTo(children, support, "descendant-or-self"));
        }
        return results;
    }

    public List applyToFollowing(Object node, ContextSupport support) {
        ArrayList results = new ArrayList();
        if (node instanceof Element) {
            List following = Partition.following((Element)node);
            results.addAll(this.applyTo(following, support, "self"));
        }
        return results;
    }

    public List applyToFollowingSibling(Object node, ContextSupport support) {
        ArrayList results = new ArrayList();
        if (node instanceof Element) {
            List followingSiblings = Partition.followingSiblings((Element)node);
            results.addAll(this.applyTo(followingSiblings, support, "self"));
        }
        return results;
    }

    public List applyToParent(Object node, ContextSupport support) {
        Object parent = ParentStep.findParent(node);
        ArrayList results = new ArrayList();
        results.addAll(this.applyToSelf(parent, support));
        return results;
    }

    public List applyToPreceeding(Object node, ContextSupport support) {
        ArrayList results = new ArrayList();
        if (node instanceof Element) {
            List preceeding = Partition.preceeding((Element)node);
            results.addAll(this.applyTo(preceeding, support, "self"));
        }
        return results;
    }

    public List applyToPreceedingSibling(Object node, ContextSupport support) {
        ArrayList results = new ArrayList();
        if (node instanceof Element) {
            List preceedingSiblings = Partition.preceedingSiblings((Element)node);
            results.addAll(this.applyTo(preceedingSiblings, support, "self"));
        }
        return results;
    }

    public List applyToSelf(Object node, ContextSupport support) {
        return Collections.EMPTY_LIST;
    }

    public String getAxis() {
        return this._axis;
    }

    public List getPredicates() {
        if (this._predicates == null) {
            return Collections.EMPTY_LIST;
        }
        return this._predicates;
    }
}

