/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.datetime;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.wicket.extensions.markup.html.form.datetime.AbstractDateTimeField;
import org.apache.wicket.model.IModel;

public class ZonedDateTimeField
extends AbstractDateTimeField<ZonedDateTime> {
    private static final long serialVersionUID = 1L;

    public ZonedDateTimeField(String id) {
        this(id, (IModel<ZonedDateTime>)null);
    }

    public ZonedDateTimeField(String id, IModel<ZonedDateTime> model) {
        super(id, model);
        this.setType(ZonedDateTime.class);
    }

    @Override
    protected ZonedDateTime createTemporal(LocalDate date, LocalTime time) {
        return ZonedDateTime.of(date, time, ZoneId.systemDefault());
    }

    @Override
    protected LocalDate getLocalDate(ZonedDateTime temporal) {
        return temporal.toLocalDate();
    }

    @Override
    protected LocalTime getLocalTime(ZonedDateTime temporal) {
        return temporal.toLocalTime();
    }
}

