; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -disable-output "-passes=print<scalar-evolution>" < %s 2>&1 | FileCheck %s

define i32 @widget() {
; CHECK-LABEL: 'widget'
; CHECK-NEXT:  Classifying expressions for: @widget
; CHECK-NEXT:    %phi = phi i32 [ 0, %b ], [ %udiv6, %b5 ]
; CHECK-NEXT:    --> %phi U: [0,1) S: [0,1) Exits: <<Unknown>> LoopDispositions: { %b1: Variant }
; CHECK-NEXT:    %phi2 = phi i32 [ 1, %b ], [ %add, %b5 ]
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%b1> U: [1,2) S: [1,2) Exits: <<Unknown>> LoopDispositions: { %b1: Computable }
; CHECK-NEXT:    %udiv = udiv i32 10, %phi2
; CHECK-NEXT:    --> (10 /u {1,+,1}<nuw><nsw><%b1>) U: [10,11) S: [10,11) Exits: <<Unknown>> LoopDispositions: { %b1: Computable }
; CHECK-NEXT:    %urem = urem i32 %udiv, 10
; CHECK-NEXT:    --> ((-10 * ((10 /u {1,+,1}<nuw><nsw><%b1>) /u 10))<nuw><nsw> + (10 /u {1,+,1}<nuw><nsw><%b1>)) U: [0,1) S: [0,1) Exits: <<Unknown>> LoopDispositions: { %b1: Computable }
; CHECK-NEXT:    %udiv6 = udiv i32 %phi2, 0
; CHECK-NEXT:    --> ({1,+,1}<nuw><nsw><%b1> /u 0) U: empty-set S: empty-set Exits: <<Unknown>> LoopDispositions: { %b1: Computable }
; CHECK-NEXT:    %add = add i32 %phi2, 1
; CHECK-NEXT:    --> {2,+,1}<nuw><nsw><%b1> U: [2,3) S: [2,3) Exits: <<Unknown>> LoopDispositions: { %b1: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @widget
; CHECK-NEXT:  Loop %b1: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for b1: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for b3: i32 0
; CHECK-NEXT:  Loop %b1: constant max backedge-taken count is i32 0
; CHECK-NEXT:  Loop %b1: symbolic max backedge-taken count is i32 0
; CHECK-NEXT:    symbolic max exit count for b1: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for b3: i32 0
;
b:
  br label %b1

b1:                                              ; preds = %b5, %b
  %phi = phi i32 [ 0, %b ], [ %udiv6, %b5 ]
  %phi2 = phi i32 [ 1, %b ], [ %add, %b5 ]
  %icmp = icmp eq i32 %phi, 0
  br i1 %icmp, label %b3, label %b8

b3:                                              ; preds = %b1
  %udiv = udiv i32 10, %phi2
  %urem = urem i32 %udiv, 10
  %icmp4 = icmp eq i32 %urem, 0
  br i1 %icmp4, label %b7, label %b5

b5:                                              ; preds = %b3
  %udiv6 = udiv i32 %phi2, 0
  %add = add i32 %phi2, 1
  br label %b1

b7:                                              ; preds = %b3
  ret i32 5

b8:                                              ; preds = %b1
  ret i32 7
}

; Don't fold %indvar2 into (zext {0,+,1}) * %a
define i64 @test_poisonous(i64 %a, i32 %n) {
; CHECK-LABEL: 'test_poisonous'
; CHECK-NEXT:  Classifying expressions for: @test_poisonous
; CHECK-NEXT:    %indvar1 = phi i32 [ 0, %entry ], [ %indvar1.next, %loop.body ]
; CHECK-NEXT:    --> {0,+,1}<%loop.body> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop.body: Computable }
; CHECK-NEXT:    %indvar2 = phi i64 [ 0, %entry ], [ %mul, %loop.body ]
; CHECK-NEXT:    --> %indvar2 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop.body: Variant }
; CHECK-NEXT:    %indvar1.next = add i32 %indvar1, 1
; CHECK-NEXT:    --> {1,+,1}<%loop.body> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop.body: Computable }
; CHECK-NEXT:    %ext = zext i32 %indvar1.next to i64
; CHECK-NEXT:    --> (zext i32 {1,+,1}<%loop.body> to i64) U: [0,4294967296) S: [0,4294967296) Exits: <<Unknown>> LoopDispositions: { %loop.body: Computable }
; CHECK-NEXT:    %mul = mul i64 %ext, %a
; CHECK-NEXT:    --> ((zext i32 {1,+,1}<%loop.body> to i64) * %a) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_poisonous
; CHECK-NEXT:  Loop %loop.body: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop.body: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop.body: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop.body: Predicated backedge-taken count is (-1 + (1 smax (1 + (sext i32 %n to i64))<nsw>))<nsw>
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:      {1,+,1}<%loop.body> Added Flags: <nssw>
; CHECK-NEXT:  Loop %loop.body: Predicated constant max backedge-taken count is i64 2147483647
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:      {1,+,1}<%loop.body> Added Flags: <nssw>
; CHECK-NEXT:  Loop %loop.body: Predicated symbolic max backedge-taken count is (-1 + (1 smax (1 + (sext i32 %n to i64))<nsw>))<nsw>
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:      {1,+,1}<%loop.body> Added Flags: <nssw>
;
entry:
  br label %loop.body

loop.body:
  %indvar1 = phi i32 [ 0, %entry ], [ %indvar1.next, %loop.body ]
  %indvar2 = phi i64 [ 0, %entry ], [ %mul, %loop.body ]
  %indvar1.next = add i32 %indvar1, 1
  %ext = zext i32 %indvar1.next to i64
  %mul = mul i64 %ext, %a
  %exitcond = icmp sgt i32 %indvar1.next, %n
  br i1 %exitcond, label %loop.exit, label %loop.body

loop.exit:
  ret i64 %mul
}
