/* Utils.c generated by valac 0.38.7, the Vala compiler
 * generated from Utils.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gtk/gtk.h>
#include "CbTwitterItem.h"
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include "CbFilter.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbMedia.h"


#define TYPE_PAGE (page_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block58Data Block58Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block59Data Block59Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block60Data Block60Data;
typedef struct _UtilsDownloadPixbufData UtilsDownloadPixbufData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
typedef struct _Block61Data Block61Data;
typedef struct _UtilsDownloadFileData UtilsDownloadFileData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block58Data {
	int _ref_count_;
	GtkMessageDialog* dialog;
};

struct _Block59Data {
	int _ref_count_;
	GString* sb;
};

struct _Block60Data {
	int _ref_count_;
	GdkPixbuf* _result_;
	GSourceFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _UtilsDownloadPixbufData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* url;
	GCancellable* cancellable;
	GdkPixbuf* result;
	Block60Data* _data60_;
	GCancellable* _tmp0_;
	SoupMessage* msg;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupSession* _tmp3_;
	SoupMessage* _tmp4_;
	GdkPixbuf* _tmp5_;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block61Data {
	int _ref_count_;
	GSourceFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	GOutputStream* out_stream;
	gpointer _async_data_;
};

struct _UtilsDownloadFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* url;
	GOutputStream* out_stream;
	Block61Data* _data61_;
	GOutputStream* _tmp0_;
	SoupMessage* msg;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupSession* _tmp3_;
	SoupMessage* _tmp4_;
};


extern SoupSession* SOUP_SESSION;
SoupSession* SOUP_SESSION = NULL;

GType page_get_type (void) G_GNUC_CONST;
#define TRANSITION_DURATION (200 * 1000)
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
gint twitter_item_sort_func (GtkListBoxRow* a, GtkListBoxRow* b);
gint twitter_item_sort_func_inv (GtkListBoxRow* a, GtkListBoxRow* b);
cairo_surface_t* load_surface (const gchar* path);
void write_surface (cairo_surface_t* surface, const gchar* path);
cairo_surface_t* scale_surface (cairo_surface_t* input, gint output_width, gint output_height);
gdouble ease_out_cubic (gdouble t);
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now);
void utils_show_error_dialog (const gchar* message, GtkWindow* transient_for);
static Block58Data* block58_data_ref (Block58Data* _data58_);
static void block58_data_unref (void * _userdata_);
static void __lambda27_ (Block58Data* _data58_, gint id);
static void ___lambda27__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static Block59Data* block59_data_ref (Block59Data* _data59_);
static void block59_data_unref (void * _userdata_);
static void ____lambda50_ (Block59Data* _data59_, JsonArray* arr, guint index, JsonNode* node);
static void _____lambda50__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void utils_download_pixbuf_data_free (gpointer _data);
void utils_download_pixbuf (const gchar* url, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* utils_download_pixbuf_finish (GAsyncResult* _res_);
static gboolean utils_download_pixbuf_co (UtilsDownloadPixbufData* _data_);
static Block60Data* block60_data_ref (Block60Data* _data60_);
static void block60_data_unref (void * _userdata_);
static gboolean _utils_download_pixbuf_co_gsource_func (gpointer self);
static void __lambda132_ (Block60Data* _data60_, SoupSession* _s, SoupMessage* _msg);
static guint8* _vala_array_dup8 (guint8* self, int length);
static void ___lambda132__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
gchar* utils_unescape_html (const gchar* input);
void utils_load_custom_icons (void);
void utils_load_custom_css (void);
void utils_init_soup_session (void);
gchar* utils_capitalize (const gchar* s);
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name);
void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name);
GSettings* settings_get (void);
GType account_get_type (void) G_GNUC_CONST;
CbFilter* utils_create_persistent_filter (const gchar* content, Account* account);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
void account_add_filter (Account* self, CbFilter* f);
gchar* utils_get_media_display_name (CbMedia* media);
static void utils_download_file_data_free (gpointer _data);
void utils_download_file (const gchar* url, GOutputStream* out_stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
void utils_download_file_finish (GAsyncResult* _res_);
static gboolean utils_download_file_co (UtilsDownloadFileData* _data_);
static Block61Data* block61_data_ref (Block61Data* _data61_);
static void block61_data_unref (void * _userdata_);
static gboolean _utils_download_file_co_gsource_func (gpointer self);
static void __lambda28_ (Block61Data* _data61_, SoupSession* _s, SoupMessage* _msg);
static guint8* _vala_array_dup9 (guint8* self, int length);
static void ___lambda28__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType page_get_type (void) {
	static volatile gsize page_type_id__volatile = 0;
	if (g_once_init_enter (&page_type_id__volatile)) {
		static const GEnumValue values[] = {{PAGE_STREAM, "PAGE_STREAM", "stream"}, {PAGE_MENTIONS, "PAGE_MENTIONS", "mentions"}, {PAGE_FAVORITES, "PAGE_FAVORITES", "favorites"}, {PAGE_DM_THREADS, "PAGE_DM_THREADS", "dm-threads"}, {PAGE_LISTS, "PAGE_LISTS", "lists"}, {PAGE_FILTERS, "PAGE_FILTERS", "filters"}, {PAGE_SEARCH, "PAGE_SEARCH", "search"}, {PAGE_PROFILE, "PAGE_PROFILE", "profile"}, {PAGE_TWEET_INFO, "PAGE_TWEET_INFO", "tweet-info"}, {PAGE_DM, "PAGE_DM", "dm"}, {PAGE_LIST_STATUSES, "PAGE_LIST_STATUSES", "list-statuses"}, {PAGE_PREVIOUS, "PAGE_PREVIOUS", "previous"}, {PAGE_NEXT, "PAGE_NEXT", "next"}, {0, NULL, NULL}};
		GType page_type_id;
		page_type_id = g_enum_register_static ("Page", values);
		g_once_init_leave (&page_type_id__volatile, page_type_id);
	}
	return page_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before) {
	GtkListBoxRow* _tmp0_;
	GtkWidget* header = NULL;
	GtkListBoxRow* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkSeparator* _tmp6_;
	GtkWidget* _tmp7_;
	GtkListBoxRow* _tmp8_;
	GtkWidget* _tmp9_;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	g_return_if_fail ((row_before == NULL) || GTK_IS_LIST_BOX_ROW (row_before));
	_tmp0_ = row_before;
	if (_tmp0_ == NULL) {
		GtkListBoxRow* _tmp1_;
		_tmp1_ = row;
		gtk_list_box_row_set_header (_tmp1_, NULL);
		return;
	}
	_tmp2_ = row;
	_tmp3_ = gtk_list_box_row_get_header (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	header = _tmp4_;
	_tmp5_ = header;
	if (_tmp5_ != NULL) {
		_g_object_unref0 (header);
		return;
	}
	_tmp6_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (header);
	header = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget);
	_tmp7_ = header;
	gtk_widget_show (_tmp7_);
	_tmp8_ = row;
	_tmp9_ = header;
	gtk_list_box_row_set_header (_tmp8_, _tmp9_);
	_g_object_unref0 (header);
}


gint twitter_item_sort_func (GtkListBoxRow* a, GtkListBoxRow* b) {
	gint result = 0;
	GtkListBoxRow* _tmp0_;
	gint64 _tmp1_;
	GtkListBoxRow* _tmp2_;
	gint64 _tmp3_;
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (a), 0);
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (b), 0);
	_tmp0_ = a;
	_tmp1_ = cb_twitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CB_TYPE_TWITTER_ITEM, CbTwitterItem));
	_tmp2_ = b;
	_tmp3_ = cb_twitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CB_TYPE_TWITTER_ITEM, CbTwitterItem));
	if (_tmp1_ < _tmp3_) {
		result = 1;
		return result;
	}
	result = -1;
	return result;
}


gint twitter_item_sort_func_inv (GtkListBoxRow* a, GtkListBoxRow* b) {
	gint result = 0;
	GtkListBoxRow* _tmp0_;
	gint64 _tmp1_;
	GtkListBoxRow* _tmp2_;
	gint64 _tmp3_;
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (a), 0);
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (b), 0);
	_tmp0_ = a;
	_tmp1_ = cb_twitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CB_TYPE_TWITTER_ITEM, CbTwitterItem));
	_tmp2_ = b;
	_tmp3_ = cb_twitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CB_TYPE_TWITTER_ITEM, CbTwitterItem));
	if (_tmp1_ < _tmp3_) {
		result = -1;
		return result;
	}
	result = 1;
	return result;
}


cairo_surface_t* load_surface (const gchar* path) {
	cairo_surface_t* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp0_;
		GdkPixbuf* _tmp1_;
		cairo_surface_t* s = NULL;
		cairo_surface_t* _tmp2_;
		_tmp0_ = path;
		_tmp1_ = gdk_pixbuf_new_from_file (_tmp0_, &_inner_error_);
		p = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch66_g_error;
		}
		_tmp2_ = gdk_cairo_surface_create_from_pixbuf (p, 1, NULL);
		s = _tmp2_;
		result = s;
		_g_object_unref0 (p);
		return result;
	}
	goto __finally66;
	__catch66_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Utils.vala:85: %s", _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally66:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void write_surface (cairo_surface_t* surface, const gchar* path) {
	cairo_status_t status = 0;
	cairo_surface_t* _tmp0_;
	const gchar* _tmp1_;
	cairo_status_t _tmp2_;
	cairo_status_t _tmp3_;
	g_return_if_fail (surface != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = surface;
	_tmp1_ = path;
	_tmp2_ = cairo_surface_write_to_png (_tmp0_, _tmp1_);
	status = _tmp2_;
	_tmp3_ = status;
	if (_tmp3_ != CAIRO_STATUS_SUCCESS) {
		const gchar* _tmp4_;
		cairo_status_t _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = path;
		_tmp5_ = status;
		_tmp6_ = cairo_status_to_string (_tmp5_);
		g_warning ("Utils.vala:97: Could not write surface to '%s': %s", _tmp4_, _tmp6_);
	}
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


cairo_surface_t* scale_surface (cairo_surface_t* input, gint output_width, gint output_height) {
	cairo_surface_t* result = NULL;
	gint old_width = 0;
	cairo_surface_t* _tmp0_;
	gint _tmp1_;
	gint old_height = 0;
	cairo_surface_t* _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gint _tmp6_;
	cairo_surface_t* new_surface = NULL;
	cairo_surface_t* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	cairo_surface_t* _tmp14_;
	cairo_t* ct = NULL;
	cairo_surface_t* _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	cairo_t* _tmp22_;
	cairo_surface_t* _tmp23_;
	cairo_t* _tmp24_;
	cairo_pattern_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = cairo_image_surface_get_width (_tmp0_);
	old_width = _tmp1_;
	_tmp2_ = input;
	_tmp3_ = cairo_image_surface_get_height (_tmp2_);
	old_height = _tmp3_;
	_tmp5_ = old_width;
	_tmp6_ = output_width;
	if (_tmp5_ == _tmp6_) {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = old_height;
		_tmp8_ = output_height;
		_tmp4_ = _tmp7_ == _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		cairo_surface_t* _tmp9_;
		cairo_surface_t* _tmp10_;
		_tmp9_ = input;
		_tmp10_ = _cairo_surface_reference0 (_tmp9_);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = input;
	_tmp12_ = output_width;
	_tmp13_ = output_height;
	_tmp14_ = cairo_surface_create_similar_image (_tmp11_, CAIRO_FORMAT_ARGB32, _tmp12_, _tmp13_);
	new_surface = _tmp14_;
	_tmp15_ = new_surface;
	_tmp16_ = cairo_create (_tmp15_);
	ct = _tmp16_;
	_tmp17_ = ct;
	_tmp18_ = output_width;
	_tmp19_ = old_width;
	_tmp20_ = output_height;
	_tmp21_ = old_height;
	cairo_scale (_tmp17_, ((gdouble) _tmp18_) / _tmp19_, ((gdouble) _tmp20_) / _tmp21_);
	_tmp22_ = ct;
	_tmp23_ = input;
	cairo_set_source_surface (_tmp22_, _tmp23_, (gdouble) 0, (gdouble) 0);
	_tmp24_ = ct;
	_tmp25_ = cairo_get_source (_tmp24_);
	cairo_pattern_set_extend (_tmp25_, CAIRO_EXTEND_PAD);
	_tmp26_ = ct;
	cairo_set_operator (_tmp26_, CAIRO_OPERATOR_SOURCE);
	_tmp27_ = ct;
	cairo_paint (_tmp27_);
	result = new_surface;
	_cairo_destroy0 (ct);
	return result;
}


inline gdouble ease_out_cubic (gdouble t) {
	gdouble result = 0.0;
	gdouble p = 0.0;
	gdouble _tmp0_;
	_tmp0_ = t;
	p = _tmp0_ - 1;
	result = ((p * p) * p) + 1;
	return result;
}


/**
   * Calculates an easily human-readable version of the time difference between
   * time and now.
   * Example: "5m" or "3h" or "26m" or "16 Nov"
   */
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now) {
	gchar* result = NULL;
	GTimeSpan diff = 0LL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GTimeSpan _tmp2_;
	gint minutes = 0;
	GTimeSpan _tmp3_;
	gint _tmp4_;
	gint hours = 0;
	gint _tmp9_;
	gint _tmp10_;
	gchar* month = NULL;
	GDateTime* _tmp13_;
	gchar* _tmp14_;
	GDateTime* _tmp15_;
	gint _tmp16_;
	GDateTime* _tmp17_;
	gint _tmp18_;
	g_return_val_if_fail (time != NULL, NULL);
	g_return_val_if_fail (now != NULL, NULL);
	_tmp0_ = now;
	_tmp1_ = time;
	_tmp2_ = g_date_time_difference (_tmp0_, _tmp1_);
	diff = _tmp2_;
	_tmp3_ = diff;
	minutes = (gint) (((_tmp3_ / 1000.0) / 1000.0) / 60.0);
	_tmp4_ = minutes;
	if (_tmp4_ == 0) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("Now"));
		result = _tmp5_;
		return result;
	} else {
		gint _tmp6_;
		_tmp6_ = minutes;
		if (_tmp6_ < 60) {
			gint _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = minutes;
			_tmp8_ = g_strdup_printf (_ ("%dm"), _tmp7_);
			result = _tmp8_;
			return result;
		}
	}
	_tmp9_ = minutes;
	hours = (gint) (_tmp9_ / 60.0);
	_tmp10_ = hours;
	if (_tmp10_ < 24) {
		gint _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = hours;
		_tmp12_ = g_strdup_printf (_ ("%dh"), _tmp11_);
		result = _tmp12_;
		return result;
	}
	_tmp13_ = time;
	_tmp14_ = g_date_time_format (_tmp13_, "%b");
	month = _tmp14_;
	_tmp15_ = time;
	_tmp16_ = g_date_time_get_year (_tmp15_);
	_tmp17_ = now;
	_tmp18_ = g_date_time_get_year (_tmp17_);
	if (_tmp16_ == _tmp18_) {
		GDateTime* _tmp19_;
		gint _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp19_ = time;
		_tmp20_ = g_date_time_get_day_of_month (_tmp19_);
		_tmp21_ = month;
		_tmp22_ = g_strdup_printf ("%d %s", _tmp20_, _tmp21_);
		result = _tmp22_;
		_g_free0 (month);
		return result;
	} else {
		GDateTime* _tmp23_;
		gint _tmp24_;
		const gchar* _tmp25_;
		GDateTime* _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_;
		_tmp23_ = time;
		_tmp24_ = g_date_time_get_day_of_month (_tmp23_);
		_tmp25_ = month;
		_tmp26_ = time;
		_tmp27_ = g_date_time_get_year (_tmp26_);
		_tmp28_ = g_strdup_printf ("%d %s %d", _tmp24_, _tmp25_, _tmp27_);
		result = _tmp28_;
		_g_free0 (month);
		return result;
	}
	_g_free0 (month);
}


/**
   * Shows an error dialog with the given error message
   *
   * @param message The error message to show
   */
static Block58Data* block58_data_ref (Block58Data* _data58_) {
	g_atomic_int_inc (&_data58_->_ref_count_);
	return _data58_;
}


static void block58_data_unref (void * _userdata_) {
	Block58Data* _data58_;
	_data58_ = (Block58Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data58_->_ref_count_)) {
		_g_object_unref0 (_data58_->dialog);
		g_slice_free (Block58Data, _data58_);
	}
}


static void __lambda27_ (Block58Data* _data58_, gint id) {
	gint _tmp0_;
	_tmp0_ = id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_data58_->dialog, gtk_widget_get_type (), GtkWidget));
	}
}


static void ___lambda27__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda27_ (self, response_id);
}


void utils_show_error_dialog (const gchar* message, GtkWindow* transient_for) {
	Block58Data* _data58_;
	GtkWindow* _tmp0_;
	const gchar* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkWidget* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	gconstpointer _tmp6_;
	g_return_if_fail (message != NULL);
	g_return_if_fail ((transient_for == NULL) || GTK_IS_WINDOW (transient_for));
	_data58_ = g_slice_new0 (Block58Data);
	_data58_->_ref_count_ = 1;
	_tmp0_ = transient_for;
	_tmp1_ = message;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_data58_->dialog = _tmp2_;
	_tmp3_ = gtk_message_dialog_get_message_area (_data58_->dialog);
	_tmp4_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_list_nth_data (_tmp5_, (guint) 0);
	gtk_label_set_selectable (G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp6_, gtk_label_get_type (), GtkLabel), TRUE);
	_g_list_free0 (_tmp5_);
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_data58_->dialog, gtk_dialog_get_type (), GtkDialog), "response", (GCallback) ___lambda27__gtk_dialog_response, block58_data_ref (_data58_), (GClosureNotify) block58_data_unref, 0);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_data58_->dialog, gtk_widget_get_type (), GtkWidget));
	block58_data_unref (_data58_);
	_data58_ = NULL;
}


/**
   * Shows the given json error object in an error dialog.
   * Example object data:
   * {"errors":[{"message":"Could not authenticate you","code":32}]
   *
   * @param json_data The json data to show
   * @param alternative If the given json data is not valid,
   *                    show this alternative error message.
   */
static Block59Data* block59_data_ref (Block59Data* _data59_) {
	g_atomic_int_inc (&_data59_->_ref_count_);
	return _data59_;
}


static void block59_data_unref (void * _userdata_) {
	Block59Data* _data59_;
	_data59_ = (Block59Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data59_->_ref_count_)) {
		_g_string_free0 (_data59_->sb);
		g_slice_free (Block59Data, _data59_);
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void ____lambda50_ (Block59Data* _data59_, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	gint64 _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GString* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	GString* _tmp11_;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	_tmp3_ = _data59_->sb;
	_tmp4_ = g_string_append (_tmp3_, "<li>");
	_tmp5_ = json_object_get_int_member (obj, "code");
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_string_append (_tmp4_, _tmp7_);
	_tmp9_ = g_string_append (_tmp8_, ": ");
	_tmp10_ = json_object_get_string_member (obj, "message");
	_tmp11_ = g_string_append (_tmp9_, _tmp10_);
	g_string_append (_tmp11_, "</li>");
	_g_free0 (_tmp7_);
	_json_object_unref0 (obj);
}


static void _____lambda50__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	____lambda50_ (self, array, index_, element_node);
}


void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for) {
	Block59Data* _data59_;
	gchar* error_message = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	JsonParser* parser = NULL;
	JsonParser* _tmp7_;
	GString* _tmp8_;
	JsonParser* _tmp13_;
	JsonNode* _tmp14_;
	JsonNodeType _tmp15_;
	JsonObject* root = NULL;
	JsonParser* _tmp18_;
	JsonNode* _tmp19_;
	JsonObject* _tmp20_;
	JsonObject* _tmp21_;
	gboolean _tmp22_ = FALSE;
	JsonObject* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp33_ = FALSE;
	JsonObject* _tmp34_;
	gboolean _tmp35_;
	JsonObject* _tmp44_;
	gboolean _tmp45_;
	JsonArray* errors = NULL;
	JsonObject* _tmp48_;
	JsonArray* _tmp49_;
	JsonArray* _tmp50_;
	JsonArray* _tmp51_;
	guint _tmp52_;
	GString* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	const gchar* _tmp82_;
	const gchar* _tmp83_;
	GtkWindow* _tmp84_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (alternative != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail ((transient_for == NULL) || GTK_IS_WINDOW (transient_for));
	_data59_ = g_slice_new0 (Block59Data);
	_data59_->_ref_count_ = 1;
	_tmp0_ = alternative;
	_tmp1_ = file;
	_tmp2_ = line;
	_tmp3_ = g_strdup_printf ("Exception: %s in %s:%d", _tmp0_, _tmp1_, _tmp2_);
	error_message = _tmp3_;
	_tmp4_ = json_data;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_;
		GtkWindow* _tmp6_;
		_tmp5_ = error_message;
		_tmp6_ = transient_for;
		utils_show_error_dialog (_tmp5_, _tmp6_);
		_g_free0 (error_message);
		block59_data_unref (_data59_);
		_data59_ = NULL;
		return;
	}
	_tmp7_ = json_parser_new ();
	parser = _tmp7_;
	_tmp8_ = g_string_new ("");
	_data59_->sb = _tmp8_;
	{
		JsonParser* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = parser;
		_tmp10_ = json_data;
		json_parser_load_from_data (_tmp9_, _tmp10_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch67_g_error;
		}
	}
	goto __finally67;
	__catch67_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		GtkWindow* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = error_message;
		_tmp12_ = transient_for;
		utils_show_error_dialog (_tmp11_, _tmp12_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block59_data_unref (_data59_);
		_data59_ = NULL;
		return;
	}
	__finally67:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block59_data_unref (_data59_);
		_data59_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = parser;
	_tmp14_ = json_parser_get_root (_tmp13_);
	_tmp15_ = json_node_get_node_type (_tmp14_);
	if (_tmp15_ != JSON_NODE_OBJECT) {
		const gchar* _tmp16_;
		GtkWindow* _tmp17_;
		_tmp16_ = error_message;
		_tmp17_ = transient_for;
		utils_show_error_dialog (_tmp16_, _tmp17_);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block59_data_unref (_data59_);
		_data59_ = NULL;
		return;
	}
	_tmp18_ = parser;
	_tmp19_ = json_parser_get_root (_tmp18_);
	_tmp20_ = json_node_get_object (_tmp19_);
	_tmp21_ = _json_object_ref0 (_tmp20_);
	root = _tmp21_;
	_tmp23_ = root;
	_tmp24_ = json_object_has_member (_tmp23_, "error");
	if (_tmp24_) {
		JsonObject* _tmp25_;
		JsonNode* _tmp26_;
		JsonNodeType _tmp27_;
		_tmp25_ = root;
		_tmp26_ = json_object_get_member (_tmp25_, "error");
		_tmp27_ = json_node_get_node_type (_tmp26_);
		_tmp22_ = _tmp27_ == JSON_NODE_VALUE;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		const gchar* _tmp28_;
		JsonObject* _tmp29_;
		JsonNode* _tmp30_;
		const gchar* _tmp31_;
		GtkWindow* _tmp32_;
		_tmp28_ = json_data;
		g_message ("Utils.vala:221: %s", _tmp28_);
		_tmp29_ = root;
		_tmp30_ = json_object_get_member (_tmp29_, "error");
		_tmp31_ = json_node_get_string (_tmp30_);
		_tmp32_ = transient_for;
		utils_show_error_dialog (_tmp31_, _tmp32_);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block59_data_unref (_data59_);
		_data59_ = NULL;
		return;
	}
	_tmp34_ = root;
	_tmp35_ = json_object_has_member (_tmp34_, "errors");
	if (_tmp35_) {
		JsonObject* _tmp36_;
		JsonNode* _tmp37_;
		JsonNodeType _tmp38_;
		_tmp36_ = root;
		_tmp37_ = json_object_get_member (_tmp36_, "errors");
		_tmp38_ = json_node_get_node_type (_tmp37_);
		_tmp33_ = _tmp38_ == JSON_NODE_VALUE;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		const gchar* _tmp39_;
		JsonObject* _tmp40_;
		JsonNode* _tmp41_;
		const gchar* _tmp42_;
		GtkWindow* _tmp43_;
		_tmp39_ = json_data;
		g_message ("Utils.vala:228: %s", _tmp39_);
		_tmp40_ = root;
		_tmp41_ = json_object_get_member (_tmp40_, "errors");
		_tmp42_ = json_node_get_string (_tmp41_);
		_tmp43_ = transient_for;
		utils_show_error_dialog (_tmp42_, _tmp43_);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block59_data_unref (_data59_);
		_data59_ = NULL;
		return;
	}
	_tmp44_ = root;
	_tmp45_ = json_object_has_member (_tmp44_, "errors");
	if (!_tmp45_) {
		const gchar* _tmp46_;
		GtkWindow* _tmp47_;
		_tmp46_ = error_message;
		_tmp47_ = transient_for;
		utils_show_error_dialog (_tmp46_, _tmp47_);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		_g_free0 (error_message);
		block59_data_unref (_data59_);
		_data59_ = NULL;
		return;
	}
	_tmp48_ = root;
	_tmp49_ = json_object_get_array_member (_tmp48_, "errors");
	_tmp50_ = _json_array_ref0 (_tmp49_);
	errors = _tmp50_;
	_tmp51_ = errors;
	_tmp52_ = json_array_get_length (_tmp51_);
	if (_tmp52_ == ((guint) 1)) {
		JsonObject* err = NULL;
		JsonArray* _tmp53_;
		JsonObject* _tmp54_;
		JsonObject* _tmp55_;
		GString* _tmp56_;
		JsonObject* _tmp57_;
		gint64 _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		GString* _tmp61_;
		GString* _tmp62_;
		JsonObject* _tmp63_;
		const gchar* _tmp64_;
		GString* _tmp65_;
		GString* _tmp66_;
		const gchar* _tmp67_;
		GString* _tmp68_;
		GString* _tmp69_;
		gint _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		GString* _tmp73_;
		_tmp53_ = errors;
		_tmp54_ = json_array_get_object_element (_tmp53_, (guint) 0);
		_tmp55_ = _json_object_ref0 (_tmp54_);
		err = _tmp55_;
		_tmp56_ = _data59_->sb;
		_tmp57_ = err;
		_tmp58_ = json_object_get_int_member (_tmp57_, "code");
		_tmp59_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = g_string_append (_tmp56_, _tmp60_);
		_tmp62_ = g_string_append (_tmp61_, ": ");
		_tmp63_ = err;
		_tmp64_ = json_object_get_string_member (_tmp63_, "message");
		_tmp65_ = g_string_append (_tmp62_, _tmp64_);
		_tmp66_ = g_string_append (_tmp65_, "(");
		_tmp67_ = file;
		_tmp68_ = g_string_append (_tmp66_, _tmp67_);
		_tmp69_ = g_string_append (_tmp68_, ":");
		_tmp70_ = line;
		_tmp71_ = g_strdup_printf ("%i", _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = g_string_append (_tmp69_, _tmp72_);
		g_string_append (_tmp73_, ")");
		_g_free0 (_tmp72_);
		_g_free0 (_tmp60_);
		_json_object_unref0 (err);
	} else {
		JsonArray* _tmp74_;
		guint _tmp75_;
		_tmp74_ = errors;
		_tmp75_ = json_array_get_length (_tmp74_);
		if (_tmp75_ > ((guint) 1)) {
			GString* _tmp76_;
			JsonArray* _tmp77_;
			GString* _tmp78_;
			_tmp76_ = _data59_->sb;
			g_string_append (_tmp76_, "<ul>");
			_tmp77_ = errors;
			json_array_foreach_element (_tmp77_, _____lambda50__json_array_foreach, _data59_);
			_tmp78_ = _data59_->sb;
			g_string_append (_tmp78_, "</ul>");
		}
	}
	_tmp79_ = _data59_->sb;
	_tmp80_ = _tmp79_->str;
	_tmp81_ = g_strdup (_tmp80_);
	_g_free0 (error_message);
	error_message = _tmp81_;
	_tmp82_ = json_data;
	g_critical ("Utils.vala:257: %s", _tmp82_);
	_tmp83_ = error_message;
	_tmp84_ = transient_for;
	utils_show_error_dialog (_tmp83_, _tmp84_);
	_json_array_unref0 (errors);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	_g_free0 (error_message);
	block59_data_unref (_data59_);
	_data59_ = NULL;
}


static void utils_download_pixbuf_data_free (gpointer _data) {
	UtilsDownloadPixbufData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	_g_object_unref0 (_data_->result);
	g_slice_free (UtilsDownloadPixbufData, _data_);
}


void utils_download_pixbuf (const gchar* url, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UtilsDownloadPixbufData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	_data_ = g_slice_new0 (UtilsDownloadPixbufData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, utils_download_pixbuf_data_free);
	_tmp0_ = url;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->url);
	_data_->url = _tmp1_;
	_tmp2_ = cancellable;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	utils_download_pixbuf_co (_data_);
}


GdkPixbuf* utils_download_pixbuf_finish (GAsyncResult* _res_) {
	GdkPixbuf* result;
	UtilsDownloadPixbufData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block60Data* block60_data_ref (Block60Data* _data60_) {
	g_atomic_int_inc (&_data60_->_ref_count_);
	return _data60_;
}


static void block60_data_unref (void * _userdata_) {
	Block60Data* _data60_;
	_data60_ = (Block60Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data60_->_ref_count_)) {
		(_data60_->cb_target_destroy_notify == NULL) ? NULL : (_data60_->cb_target_destroy_notify (_data60_->cb_target), NULL);
		_data60_->cb = NULL;
		_data60_->cb_target = NULL;
		_data60_->cb_target_destroy_notify = NULL;
		_g_object_unref0 (_data60_->_result_);
		_g_object_unref0 (_data60_->cancellable);
		g_slice_free (Block60Data, _data60_);
	}
}


static gboolean _utils_download_pixbuf_co_gsource_func (gpointer self) {
	gboolean result;
	result = utils_download_pixbuf_co (self);
	return result;
}


static guint8* _vala_array_dup8 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void __lambda132_ (Block60Data* _data60_, SoupSession* _s, SoupMessage* _msg) {
	GCancellable* _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (SOUP_IS_SESSION (_s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _data60_->cancellable;
	_tmp1_ = g_cancellable_is_cancelled (_tmp0_);
	if (_tmp1_) {
		_data60_->cb (_data60_->cb_target);
		return;
	}
	{
		GMemoryInputStream* in_stream = NULL;
		SoupMessage* _tmp2_;
		SoupMessageBody* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		guint8* _tmp5_;
		gint _tmp5__length1;
		GDestroyNotify _tmp6_;
		GMemoryInputStream* _tmp7_;
		GdkPixbuf* _tmp8_ = NULL;
		GMemoryInputStream* _tmp9_;
		GCancellable* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		_tmp2_ = _msg;
		_tmp3_ = _tmp2_->response_body;
		_tmp4_ = _tmp3_->data;
		_tmp4__length1 = (gint) _tmp3_->length;
		_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup8 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
		_tmp5__length1 = _tmp4__length1;
		_tmp6_ = g_free;
		_tmp7_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp5_, _tmp5__length1, _tmp6_);
		in_stream = _tmp7_;
		_tmp9_ = in_stream;
		_tmp10_ = _data60_->cancellable;
		_tmp11_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_input_stream_get_type (), GInputStream), _tmp10_, &_inner_error_);
		_tmp8_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (in_stream);
			goto __catch68_g_error;
		}
		_tmp12_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (_data60_->_result_);
		_data60_->_result_ = _tmp12_;
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (in_stream);
	}
	goto __finally68;
	__catch68_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("Utils.vala:278: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally68:
	{
		_data60_->cb (_data60_->cb_target);
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda132__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda132_ (self, session, msg);
	block60_data_unref (self);
}


static gboolean utils_download_pixbuf_co (UtilsDownloadPixbufData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data60_ = g_slice_new0 (Block60Data);
	_data_->_data60_->_ref_count_ = 1;
	_data_->_tmp0_ = _data_->cancellable;
	_g_object_unref0 (_data_->_data60_->cancellable);
	_data_->_data60_->cancellable = _data_->_tmp0_;
	_data_->_data60_->_async_data_ = _data_;
	_data_->_data60_->_result_ = NULL;
	_data_->_tmp1_ = _data_->url;
	_data_->_tmp2_ = soup_message_new ("GET", _data_->_tmp1_);
	_data_->msg = _data_->_tmp2_;
	_data_->_data60_->cb = _utils_download_pixbuf_co_gsource_func;
	_data_->_data60_->cb_target = _data_;
	_data_->_data60_->cb_target_destroy_notify = NULL;
	_data_->_tmp3_ = SOUP_SESSION;
	_data_->_tmp4_ = _g_object_ref0 (_data_->msg);
	soup_session_queue_message (_data_->_tmp3_, _data_->_tmp4_, ___lambda132__soup_session_callback, block60_data_ref (_data_->_data60_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp5_ = _g_object_ref0 (_data_->_data60_->_result_);
	_data_->result = _data_->_tmp5_;
	_g_object_unref0 (_data_->msg);
	block60_data_unref (_data_->_data60_);
	_data_->_data60_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch69_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch69_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally69;
	__catch69_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally69:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* utils_unescape_html (const gchar* input) {
	gchar* result = NULL;
	gchar* back = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = string_replace (_tmp0_, "&lt;", "<");
	back = _tmp1_;
	_tmp2_ = back;
	_tmp3_ = string_replace (_tmp2_, "&gt;", ">");
	_g_free0 (back);
	back = _tmp3_;
	_tmp4_ = back;
	_tmp5_ = string_replace (_tmp4_, "&amp;", "&");
	_g_free0 (back);
	back = _tmp5_;
	result = back;
	return result;
}


void utils_load_custom_icons (void) {
	GtkIconTheme* icon_theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	icon_theme = _tmp1_;
	gtk_icon_theme_add_resource_path (icon_theme, "/org/baedert/corebird/data/");
	_g_object_unref0 (icon_theme);
}


void utils_load_custom_css (void) {
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GdkScreen* _tmp1_;
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	gtk_css_provider_load_from_resource (provider, "/org/baedert/corebird/ui/style.css");
	_tmp1_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gdk_screen_get_type (), GdkScreen), G_TYPE_CHECK_INSTANCE_CAST (provider, GTK_TYPE_STYLE_PROVIDER, GtkStyleProvider), (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (provider);
}


void utils_init_soup_session (void) {
	SoupSession* _tmp0_;
	SoupSession* _tmp1_;
	_tmp0_ = SOUP_SESSION;
	_vala_assert (_tmp0_ == NULL, "SOUP_SESSION == null");
	_tmp1_ = soup_session_new ();
	_g_object_unref0 (SOUP_SESSION);
	SOUP_SESSION = _tmp1_;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gchar* utils_capitalize (const gchar* s) {
	gchar* result = NULL;
	gchar* back = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gunichar _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp1_ = g_strdup (_tmp0_);
	back = _tmp1_;
	_tmp2_ = s;
	_tmp3_ = string_get_char (_tmp2_, (glong) 0);
	_tmp4_ = g_unichar_islower (_tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_;
		gunichar _tmp6_;
		gunichar _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp5_ = s;
		_tmp6_ = string_get_char (_tmp5_, (glong) 0);
		_tmp7_ = g_unichar_toupper (_tmp6_);
		_tmp8_ = g_unichar_to_string (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = s;
		_tmp11_ = string_substring (_tmp10_, (glong) 1, (glong) -1);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
		_g_free0 (back);
		back = _tmp13_;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
	}
	result = back;
	return result;
}


/**
   * Checks if @value is existing in @node and if it is, non-null.
   *
   * Returns TRUE if the @value does both exist and is non-null.
   */
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name) {
	gboolean result = FALSE;
	JsonObject* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	JsonObject* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (node != NULL, FALSE);
	g_return_val_if_fail (value_name != NULL, FALSE);
	_tmp0_ = node;
	_tmp1_ = value_name;
	_tmp2_ = json_object_has_member (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = node;
	_tmp4_ = value_name;
	_tmp5_ = json_object_get_null_member (_tmp3_, _tmp4_);
	result = !_tmp5_;
	return result;
}


void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name) {
	gchar** startup_accounts = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint startup_accounts_length1;
	gint _startup_accounts_size_;
	gchar** new_startup_accounts = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint new_startup_accounts_length1;
	gint _new_startup_accounts_size_;
	GSettings* _tmp27_;
	GSettings* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	g_return_if_fail (old_screen_name != NULL);
	g_return_if_fail (new_screen_name != NULL);
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "startup-accounts");
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_object_unref0 (_tmp1_);
	startup_accounts = _tmp4_;
	startup_accounts_length1 = _tmp4__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp5_ = startup_accounts;
	_tmp5__length1 = startup_accounts_length1;
	_tmp6_ = g_new0 (gchar*, _tmp5__length1 + 1);
	new_startup_accounts = _tmp6_;
	new_startup_accounts_length1 = _tmp5__length1;
	_new_startup_accounts_size_ = new_startup_accounts_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = startup_accounts;
				_tmp10__length1 = startup_accounts_length1;
				if (!(_tmp9_ < _tmp10__length1)) {
					break;
				}
				_tmp11_ = startup_accounts;
				_tmp11__length1 = startup_accounts_length1;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				_tmp14_ = old_screen_name;
				if (g_strcmp0 (_tmp13_, _tmp14_) != 0) {
					gchar** _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					gchar** _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp15_ = new_startup_accounts;
					_tmp15__length1 = new_startup_accounts_length1;
					_tmp16_ = i;
					_tmp17_ = startup_accounts;
					_tmp17__length1 = startup_accounts_length1;
					_tmp18_ = i;
					_tmp19_ = _tmp17_[_tmp18_];
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (_tmp15_[_tmp16_]);
					_tmp15_[_tmp16_] = _tmp20_;
					_tmp21_ = _tmp15_[_tmp16_];
				} else {
					gchar** _tmp22_;
					gint _tmp22__length1;
					gint _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp22_ = new_startup_accounts;
					_tmp22__length1 = new_startup_accounts_length1;
					_tmp23_ = i;
					_tmp24_ = new_screen_name;
					_tmp25_ = g_strdup (_tmp24_);
					_g_free0 (_tmp22_[_tmp23_]);
					_tmp22_[_tmp23_] = _tmp25_;
					_tmp26_ = _tmp22_[_tmp23_];
				}
			}
		}
	}
	_tmp27_ = settings_get ();
	_tmp28_ = _tmp27_;
	_tmp29_ = new_startup_accounts;
	_tmp29__length1 = new_startup_accounts_length1;
	g_settings_set_strv (_tmp28_, "startup-accounts", _tmp29_);
	_g_object_unref0 (_tmp28_);
	new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


CbFilter* utils_create_persistent_filter (const gchar* content, Account* account) {
	CbFilter* result = NULL;
	gint id = 0;
	Account* _tmp0_;
	SqlDatabase* _tmp1_;
	SqlInsertStatement* _tmp2_;
	SqlInsertStatement* _tmp3_;
	const gchar* _tmp4_;
	SqlInsertStatement* _tmp5_;
	SqlInsertStatement* _tmp6_;
	gint64 _tmp7_;
	gint _tmp8_;
	CbFilter* f = NULL;
	const gchar* _tmp9_;
	CbFilter* _tmp10_;
	Account* _tmp11_;
	CbFilter* _tmp12_;
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp0_ = account;
	_tmp1_ = _tmp0_->db;
	_tmp2_ = sql_database_insert (_tmp1_, "filters");
	_tmp3_ = _tmp2_;
	_tmp4_ = content;
	_tmp5_ = sql_insert_statement_val (_tmp3_, "content", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sql_insert_statement_run (_tmp6_);
	_tmp8_ = (gint) _tmp7_;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	id = _tmp8_;
	_tmp9_ = content;
	_tmp10_ = cb_filter_new (_tmp9_);
	f = _tmp10_;
	cb_filter_set_id (f, id);
	_tmp11_ = account;
	_tmp12_ = _g_object_ref0 (f);
	account_add_filter (_tmp11_, _tmp12_);
	result = f;
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* utils_get_media_display_name (CbMedia* media) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	CbMedia* _tmp1_;
	const gchar* _tmp2_;
	const gchar* url = NULL;
	gint last_slash_index = 0;
	const gchar* _tmp5_;
	gint _tmp6_;
	gchar* filename = NULL;
	const gchar* _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gint last_dot_index = 0;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	g_return_val_if_fail (CB_IS_MEDIA (media), NULL);
	_tmp1_ = media;
	_tmp2_ = _tmp1_->target_url;
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		CbMedia* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = media;
		_tmp4_ = _tmp3_->url;
		_tmp0_ = _tmp4_;
	}
	url = _tmp0_;
	_tmp5_ = url;
	_tmp6_ = string_last_index_of_char (_tmp5_, (gunichar) '/', 0);
	last_slash_index = _tmp6_;
	_tmp7_ = url;
	_tmp8_ = last_slash_index;
	_tmp9_ = string_substring (_tmp7_, (glong) (_tmp8_ + 1), (glong) -1);
	filename = _tmp9_;
	_tmp10_ = filename;
	_tmp11_ = string_replace (_tmp10_, ":orig", "");
	_g_free0 (filename);
	filename = _tmp11_;
	_tmp12_ = filename;
	_tmp13_ = string_last_index_of_char (_tmp12_, (gunichar) '.', 0);
	last_dot_index = _tmp13_;
	_tmp14_ = last_dot_index;
	if (_tmp14_ == -1) {
		CbMedia* _tmp15_;
		gboolean _tmp16_;
		_tmp15_ = media;
		_tmp16_ = cb_media_is_video (_tmp15_);
		if (_tmp16_) {
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = filename;
			_tmp18_ = g_strconcat (_tmp17_, ".mp4", NULL);
			_g_free0 (filename);
			filename = _tmp18_;
		} else {
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp19_ = filename;
			_tmp20_ = g_strconcat (_tmp19_, ".jpg", NULL);
			_g_free0 (filename);
			filename = _tmp20_;
		}
	}
	result = filename;
	return result;
}


static void utils_download_file_data_free (gpointer _data) {
	UtilsDownloadFileData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	g_slice_free (UtilsDownloadFileData, _data_);
}


void utils_download_file (const gchar* url, GOutputStream* out_stream, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UtilsDownloadFileData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GOutputStream* _tmp2_;
	GOutputStream* _tmp3_;
	_data_ = g_slice_new0 (UtilsDownloadFileData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, utils_download_file_data_free);
	_tmp0_ = url;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->url);
	_data_->url = _tmp1_;
	_tmp2_ = out_stream;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->out_stream);
	_data_->out_stream = _tmp3_;
	utils_download_file_co (_data_);
}


void utils_download_file_finish (GAsyncResult* _res_) {
	UtilsDownloadFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static Block61Data* block61_data_ref (Block61Data* _data61_) {
	g_atomic_int_inc (&_data61_->_ref_count_);
	return _data61_;
}


static void block61_data_unref (void * _userdata_) {
	Block61Data* _data61_;
	_data61_ = (Block61Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data61_->_ref_count_)) {
		(_data61_->cb_target_destroy_notify == NULL) ? NULL : (_data61_->cb_target_destroy_notify (_data61_->cb_target), NULL);
		_data61_->cb = NULL;
		_data61_->cb_target = NULL;
		_data61_->cb_target_destroy_notify = NULL;
		_g_object_unref0 (_data61_->out_stream);
		g_slice_free (Block61Data, _data61_);
	}
}


static gboolean _utils_download_file_co_gsource_func (gpointer self) {
	gboolean result;
	result = utils_download_file_co (self);
	return result;
}


static guint8* _vala_array_dup9 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void __lambda28_ (Block61Data* _data61_, SoupSession* _s, SoupMessage* _msg) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (SOUP_IS_SESSION (_s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	{
		GMemoryInputStream* in_stream = NULL;
		SoupMessage* _tmp0_;
		SoupMessageBody* _tmp1_;
		guint8* _tmp2_;
		gint _tmp2__length1;
		guint8* _tmp3_;
		gint _tmp3__length1;
		GDestroyNotify _tmp4_;
		GMemoryInputStream* _tmp5_;
		GOutputStream* _tmp6_;
		_tmp0_ = _msg;
		_tmp1_ = _tmp0_->response_body;
		_tmp2_ = _tmp1_->data;
		_tmp2__length1 = (gint) _tmp1_->length;
		_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup9 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
		_tmp3__length1 = _tmp2__length1;
		_tmp4_ = g_free;
		_tmp5_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp3_, _tmp3__length1, _tmp4_);
		in_stream = _tmp5_;
		_tmp6_ = _data61_->out_stream;
		g_output_stream_splice (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (in_stream, g_input_stream_get_type (), GInputStream), G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (in_stream);
			goto __catch70_g_error;
		}
		_g_object_unref0 (in_stream);
	}
	goto __finally70;
	__catch70_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("Utils.vala:395: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally70:
	{
		_data61_->cb (_data61_->cb_target);
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda28__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda28_ (self, session, msg);
	block61_data_unref (self);
}


static gboolean utils_download_file_co (UtilsDownloadFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data61_ = g_slice_new0 (Block61Data);
	_data_->_data61_->_ref_count_ = 1;
	_data_->_tmp0_ = _data_->out_stream;
	_g_object_unref0 (_data_->_data61_->out_stream);
	_data_->_data61_->out_stream = _data_->_tmp0_;
	_data_->_data61_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->url;
	_data_->_tmp2_ = soup_message_new ("GET", _data_->_tmp1_);
	_data_->msg = _data_->_tmp2_;
	_data_->_data61_->cb = _utils_download_file_co_gsource_func;
	_data_->_data61_->cb_target = _data_;
	_data_->_data61_->cb_target_destroy_notify = NULL;
	_data_->_tmp3_ = SOUP_SESSION;
	_data_->_tmp4_ = _g_object_ref0 (_data_->msg);
	soup_session_queue_message (_data_->_tmp3_, _data_->_tmp4_, ___lambda28__soup_session_callback, block61_data_ref (_data_->_data61_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_g_object_unref0 (_data_->msg);
	block61_data_unref (_data_->_data61_);
	_data_->_data61_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



