; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 2
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx900 -stop-after=finalize-isel < %s | FileCheck %s

declare void @readsMem(ptr) #0
declare void @writesMem(ptr) #1

define void @fence_loads(ptr %ptr) {
  ; CHECK-LABEL: name: fence_loads
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $vgpr0, $vgpr1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; CHECK-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1
  ; CHECK-NEXT:   ATOMIC_FENCE 5, 1, mmra !0
  ; CHECK-NEXT:   [[FLAT_LOAD_UBYTE:%[0-9]+]]:vgpr_32 = FLAT_LOAD_UBYTE [[REG_SEQUENCE]], 0, 0, implicit $exec, implicit $flat_scr, mmra !1 :: (load acquire (s8) from %ir.ptr, align 4)
  ; CHECK-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY [[S_MOV_B32_]]
  ; CHECK-NEXT:   FLAT_STORE_BYTE [[REG_SEQUENCE]], [[COPY2]], 0, 0, implicit $exec, implicit $flat_scr, mmra !2 :: (store release (s8) into %ir.ptr, align 4)
  ; CHECK-NEXT:   SI_RETURN
  fence release,                                        !mmra !0
  %ld = load atomic i8, ptr %ptr acquire, align 4,      !mmra !2
  store atomic i8 1, ptr %ptr release, align 4,         !mmra !1
  ret void
}

; TODO: test atomicrmw, cmpxchg - current lowering doesn't work and blows up on i1 PHIs.

attributes #0 = { memory(read) }
attributes #1 = { memory(write) }

!0 = !{!"foo", !"bar"}
!1 = !{!"bux", !"baz"}
!2 = !{!0, !1}
