; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-globals
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-attributor %s -o - | FileCheck %s

@g_fn = addrspace(1) global ptr null

;.
; CHECK: @g_fn = addrspace(1) global ptr null
;.
define void @set_fn(ptr %fn) {
; CHECK-LABEL: define {{[^@]+}}@set_fn
; CHECK-SAME: (ptr [[FN:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store ptr [[FN]], ptr addrspace(1) @g_fn, align 8
; CHECK-NEXT:    ret void
;
entry:
  store ptr %fn, ptr addrspace(1) @g_fn
  ret void
}

define void @get_fn(ptr %fn) {
; CHECK-LABEL: define {{[^@]+}}@get_fn
; CHECK-SAME: (ptr [[FN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LOAD:%.*]] = load ptr, ptr addrspace(1) @g_fn, align 8
; CHECK-NEXT:    store ptr [[LOAD]], ptr [[FN]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %load = load ptr, ptr addrspace(1) @g_fn
  store ptr %load, ptr %fn
  ret void
}

define void @foo() {
; CHECK-LABEL: define {{[^@]+}}@foo
; CHECK-SAME: () #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[FN:%.*]] = alloca ptr, align 8, addrspace(5)
; CHECK-NEXT:    store ptr null, ptr addrspace(5) [[FN]], align 8
; CHECK-NEXT:    [[FN_CAST:%.*]] = addrspacecast ptr addrspace(5) [[FN]] to ptr
; CHECK-NEXT:    call void @get_fn(ptr [[FN_CAST]])
; CHECK-NEXT:    [[LOAD:%.*]] = load ptr, ptr addrspace(5) [[FN]], align 8
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp ne ptr [[LOAD]], null
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[LOAD_1:%.*]] = load ptr, ptr addrspace(5) [[FN]], align 8
; CHECK-NEXT:    call void [[LOAD_1]]()
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  %fn = alloca ptr, addrspace(5)
  store ptr null, ptr addrspace(5) %fn
  %fn.cast = addrspacecast ptr addrspace(5) %fn to ptr
  call void @get_fn(ptr %fn.cast)
  %load = load ptr, ptr addrspace(5) %fn
  %tobool = icmp ne ptr %load, null
  br i1 %tobool, label %if.then, label %if.end

if.then:
  %load.1 = load ptr, ptr addrspace(5) %fn
  call void %load.1()
  br label %if.end

if.end:
  ret void
}
;.
; CHECK: attributes #[[ATTR0]] = { "amdgpu-no-agpr" "amdgpu-no-completion-action" "amdgpu-no-default-queue" "amdgpu-no-dispatch-id" "amdgpu-no-dispatch-ptr" "amdgpu-no-flat-scratch-init" "amdgpu-no-heap-ptr" "amdgpu-no-hostcall-ptr" "amdgpu-no-implicitarg-ptr" "amdgpu-no-lds-kernel-id" "amdgpu-no-multigrid-sync-arg" "amdgpu-no-queue-ptr" "amdgpu-no-workgroup-id-x" "amdgpu-no-workgroup-id-y" "amdgpu-no-workgroup-id-z" "amdgpu-no-workitem-id-x" "amdgpu-no-workitem-id-y" "amdgpu-no-workitem-id-z" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR1]] = { "uniform-work-group-size"="false" }
;.
