; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=arm64-eabi -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -mtriple=arm64-eabi -global-isel -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define zeroext i1 @saddo1.i32.unused(i32 %v1, i32 %v2, ptr %res) {
; CHECK-LABEL: saddo1.i32.unused:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    add w8, w0, w1
; CHECK-NEXT:    mov w0, #1 // =0x1
; CHECK-NEXT:    str w8, [x2]
; CHECK-NEXT:    ret
entry:
  %t = call {i32, i1} @llvm.sadd.with.overflow.i32(i32 %v1, i32 %v2)
  %obit = extractvalue {i32, i1} %t, 1
  %val = extractvalue {i32, i1} %t, 0
  store i32 %val, ptr %res
  ret i1 1
}

define zeroext i1 @saddo1.i32.fold(i32 %v1, i32 %v2, ptr %res) {
; CHECK-LABEL: saddo1.i32.fold:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #20 // =0x14
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    str w8, [x2]
; CHECK-NEXT:    ret
entry:
  %t = call {i32, i1} @llvm.sadd.with.overflow.i32(i32 9, i32 11)
  %val = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  store i32 %val, ptr %res
  ret i1 %obit
}

define zeroext i1 @saddo1.i32.addzero(i32 %v1, i32 %v2, ptr %res) {
; CHECK-LABEL: saddo1.i32.addzero:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, w0
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    str w8, [x2]
; CHECK-NEXT:    ret
entry:
  %t = call {i32, i1} @llvm.sadd.with.overflow.i32(i32 %v1, i32 0)
  %val = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  store i32 %val, ptr %res
  ret i1 %obit
}

define zeroext i1 @uaddo1.i32.addzero(i32 %v1, i32 %v2, ptr %res) {
; CHECK-LABEL: uaddo1.i32.addzero:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, w0
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    str w8, [x2]
; CHECK-NEXT:    ret
entry:
  %t = call {i32, i1} @llvm.uadd.with.overflow.i32(i32 %v1, i32 0)
  %val = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  store i32 %val, ptr %res
  ret i1 %obit
}

define i32 @saddo.select.i64(i32 %v1, i32 %v2, i1 %v3, i64 %v4, i64 %v5) {
; CHECK-LABEL: saddo.select.i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    ret
entry:
  %lhs = and i64 %v4, 12
  %rhs = and i64 %v5, 13
  %t = call {i64, i1} @llvm.sadd.with.overflow.64(i64 %lhs, i64 %rhs)
  %obit = extractvalue {i64, i1} %t, 1
  %ret = select i1 %obit, i32 %v1, i32 %v2
  ret i32 %ret
}

define i32 @uaddo.select.i64(i32 %v1, i32 %v2, i1 %v3, i64 %v4, i64 %v5) {
; CHECK-LABEL: uaddo.select.i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    ret
entry:
  %lhs = and i64 %v4, 9
  %rhs = and i64 %v5, 10
  %t = call {i64, i1} @llvm.uadd.with.overflow.64(i64 %lhs, i64 %rhs)
  %obit = extractvalue {i64, i1} %t, 1
  %ret = select i1 %obit, i32 %v1, i32 %v2
  ret i32 %ret
}

define zeroext i1 @saddo.canon.i32(i32 %v1, i32 %v2, i32 %v3, i32 %v4, i32 %v5, ptr %res) {
; CHECK-LABEL: saddo.canon.i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    str w4, [x5]
; CHECK-NEXT:    ret
entry:
  %t = call {i32, i1} @llvm.sadd.with.overflow.i32(i32 0, i32 %v5)
  %val = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  store i32 %val, ptr %res
  ret i1 %obit
}
define zeroext i1 @saddo.add.i32(i32 %v1, i32 %v2, i32 %v3, i32 %v4, i32 %v5, ptr %res) {
; CHECK-SD-LABEL: saddo.add.i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    add w8, w4, #100
; CHECK-SD-NEXT:    subs w8, w8, #100
; CHECK-SD-NEXT:    cset w0, vs
; CHECK-SD-NEXT:    str w8, [x5]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: saddo.add.i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov w0, wzr
; CHECK-GI-NEXT:    str w4, [x5]
; CHECK-GI-NEXT:    ret
entry:
  %lhs = add nsw i32 %v5, 100
  %t = call {i32, i1} @llvm.sadd.with.overflow.i32(i32 %lhs, i32 -100)
  %val = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  store i32 %val, ptr %res
  ret i1 %obit
}

define zeroext i1 @uaddo.add.i32(i32 %v1, i32 %v2, i32 %v3, i32 %v4, i32 %v5, ptr %res) {
; CHECK-SD-LABEL: uaddo.add.i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    add w8, w4, #5
; CHECK-SD-NEXT:    adds w8, w8, #5
; CHECK-SD-NEXT:    cset w0, hs
; CHECK-SD-NEXT:    str w8, [x5]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: uaddo.add.i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    adds w8, w4, #10
; CHECK-GI-NEXT:    cset w0, hs
; CHECK-GI-NEXT:    str w8, [x5]
; CHECK-GI-NEXT:    ret
entry:
  %lhs = add nuw i32 %v5, 5
  %t = call {i32, i1} @llvm.uadd.with.overflow.i32(i32 %lhs, i32 5)
  %val = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  store i32 %val, ptr %res
  ret i1 %obit
}

define zeroext i1 @uaddo.negative.i32(i32 %v1, i32 %v2, i32 %v3, i32 %v4, i32 %v5, ptr %res) {
; CHECK-LABEL: uaddo.negative.i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adds w8, w3, #5
; CHECK-NEXT:    cset w0, hs
; CHECK-NEXT:    str w8, [x5]
; CHECK-NEXT:    ret
entry:
  %t = call {i32, i1} @llvm.uadd.with.overflow.i32(i32 %v4, i32 5)
  %val = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  store i32 %val, ptr %res
  ret i1 %obit
}

define i32 @saddo.always.i8(i32 %v1, i32 %v2, i32 %v3, i32 %v4, i32 %v5, ptr %res) {
; CHECK-LABEL: saddo.always.i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    ret
entry:
  %t = call {i8, i1} @llvm.sadd.with.overflow.i8(i8 255, i8 254)
  %obit = extractvalue {i8, i1} %t, 1
  %ret = select i1 %obit, i32 %v1, i32 %v2
  ret i32 %ret
}

define i32 @uaddo.never.i8(i32 %v1, i32 %v2, i32 %v3, i32 %v4, i32 %v5, ptr %res) {
; CHECK-LABEL: uaddo.never.i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    ret
entry:
  %t = call {i8, i1} @llvm.uadd.with.overflow.i8(i8 2, i8 1)
  %obit = extractvalue {i8, i1} %t, 1
  %ret = select i1 %obit, i32 %v1, i32 %v2
  ret i32 %ret
}


declare {i8, i1} @llvm.sadd.with.overflow.i8(i8, i8) nounwind readnone
declare {i16, i1} @llvm.sadd.with.overflow.i16(i16, i16) nounwind readnone
declare {i32, i1} @llvm.sadd.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.sadd.with.overflow.i64(i64, i64) nounwind readnone
declare {i8, i1} @llvm.uadd.with.overflow.i8(i8, i8) nounwind readnone
declare {i16, i1} @llvm.uadd.with.overflow.i16(i16, i16) nounwind readnone
declare {i32, i1} @llvm.uadd.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.uadd.with.overflow.i64(i64, i64) nounwind readnone
declare {i8, i1} @llvm.ssub.with.overflow.i8(i8, i8) nounwind readnone
declare {i16, i1} @llvm.ssub.with.overflow.i16(i16, i16) nounwind readnone
declare {i32, i1} @llvm.ssub.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.ssub.with.overflow.i64(i64, i64) nounwind readnone
declare {i8, i1} @llvm.usub.with.overflow.i8(i8, i8) nounwind readnone
declare {i16, i1} @llvm.usub.with.overflow.i16(i16, i16) nounwind readnone
declare {i32, i1} @llvm.usub.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.usub.with.overflow.i64(i64, i64) nounwind readnone
declare {i8, i1} @llvm.smul.with.overflow.i8(i8, i8) nounwind readnone
declare {i16, i1} @llvm.smul.with.overflow.i16(i16, i16) nounwind readnone
declare {i32, i1} @llvm.smul.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.smul.with.overflow.i64(i64, i64) nounwind readnone
declare {i8, i1} @llvm.umul.with.overflow.i8(i8, i8) nounwind readnone
declare {i16, i1} @llvm.umul.with.overflow.i16(i16, i16) nounwind readnone
declare {i32, i1} @llvm.umul.with.overflow.i32(i32, i32) nounwind readnone
declare {i64, i1} @llvm.umul.with.overflow.i64(i64, i64) nounwind readnone
