/* cdb-dict.c generated by valac 0.40.8, the Vala compiler
 * generated from cdb-dict.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define SKK_TYPE_DICT (skk_dict_get_type ())
#define SKK_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_DICT, SkkDict))
#define SKK_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_DICT, SkkDictClass))
#define SKK_IS_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_DICT))
#define SKK_IS_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_DICT))
#define SKK_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_DICT, SkkDictClass))

typedef struct _SkkDict SkkDict;
typedef struct _SkkDictClass SkkDictClass;
typedef struct _SkkDictPrivate SkkDictPrivate;

#define SKK_TYPE_CANDIDATE (skk_candidate_get_type ())
#define SKK_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CANDIDATE, SkkCandidate))
#define SKK_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CANDIDATE, SkkCandidateClass))
#define SKK_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CANDIDATE))
#define SKK_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CANDIDATE))
#define SKK_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CANDIDATE, SkkCandidateClass))

typedef struct _SkkCandidate SkkCandidate;
typedef struct _SkkCandidateClass SkkCandidateClass;

#define SKK_TYPE_CDB_DICT (skk_cdb_dict_get_type ())
#define SKK_CDB_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CDB_DICT, SkkCdbDict))
#define SKK_CDB_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CDB_DICT, SkkCdbDictClass))
#define SKK_IS_CDB_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CDB_DICT))
#define SKK_IS_CDB_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CDB_DICT))
#define SKK_CDB_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CDB_DICT, SkkCdbDictClass))

typedef struct _SkkCdbDict SkkCdbDict;
typedef struct _SkkCdbDictClass SkkCdbDictClass;
typedef struct _SkkCdbDictPrivate SkkCdbDictPrivate;

#define SKK_TYPE_MEMORY_MAPPED_FILE (skk_memory_mapped_file_get_type ())
#define SKK_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFile))
#define SKK_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))
#define SKK_IS_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_IS_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_MEMORY_MAPPED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))

typedef struct _SkkMemoryMappedFile SkkMemoryMappedFile;
typedef struct _SkkMemoryMappedFileClass SkkMemoryMappedFileClass;

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
enum  {
	SKK_CDB_DICT_0_PROPERTY,
	SKK_CDB_DICT_READ_ONLY_PROPERTY,
	SKK_CDB_DICT_NUM_PROPERTIES
};
static GParamSpec* skk_cdb_dict_properties[SKK_CDB_DICT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SkkDict {
	GObject parent_instance;
	SkkDictPrivate * priv;
};

struct _SkkDictClass {
	GObjectClass parent_class;
	void (*reload) (SkkDict* self, GError** error);
	SkkCandidate** (*lookup) (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1);
	gchar** (*complete) (SkkDict* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (SkkDict* self, SkkCandidate* candidate);
	gboolean (*purge_candidate) (SkkDict* self, SkkCandidate* candidate);
	void (*save) (SkkDict* self, GError** error);
	gboolean (*get_read_only) (SkkDict* self);
};

struct _SkkCdbDict {
	SkkDict parent_instance;
	SkkCdbDictPrivate * priv;
};

struct _SkkCdbDictClass {
	SkkDictClass parent_class;
};

struct _SkkCdbDictPrivate {
	GFile* file;
	SkkMemoryMappedFile* mmap;
	gchar* etag;
	SkkEncodingConverter* converter;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gpointer skk_cdb_dict_parent_class = NULL;

GType skk_dict_get_type (void) G_GNUC_CONST;
GType skk_candidate_get_type (void) G_GNUC_CONST;
GType skk_cdb_dict_get_type (void) G_GNUC_CONST;
GType skk_memory_mapped_file_get_type (void) G_GNUC_CONST;
GType skk_encoding_converter_get_type (void) G_GNUC_CONST;
#define SKK_CDB_DICT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_CDB_DICT, SkkCdbDictPrivate))
static guint32 skk_cdb_dict_hash (gchar* chars,
                           int chars_length1);
static void skk_cdb_dict_real_reload (SkkDict* base,
                               GError** error);
GQuark skk_skk_dict_error_quark (void);
void skk_memory_mapped_file_remap (SkkMemoryMappedFile* self,
                                   GError** error);
static guint32 skk_cdb_dict_read_uint32 (guint8* p);
static SkkCandidate** skk_cdb_dict_real_lookup (SkkDict* base,
                                         const gchar* midasi,
                                         gboolean okuri,
                                         int* result_length1);
void* skk_memory_mapped_file_get_memory (SkkMemoryMappedFile* self);
gchar* skk_encoding_converter_encode (SkkEncodingConverter* self,
                                      const gchar* internal_str,
                                      GError** error);
gchar* skk_encoding_converter_decode (SkkEncodingConverter* self,
                                      const gchar* external_str,
                                      GError** error);
SkkCandidate** skk_dict_split_candidates (SkkDict* self,
                                          const gchar* midasi,
                                          gboolean okuri,
                                          const gchar* line,
                                          int* result_length1);
static gchar** skk_cdb_dict_real_complete (SkkDict* base,
                                    const gchar* midasi,
                                    int* result_length1);
SkkCdbDict* skk_cdb_dict_new (const gchar* path,
                              const gchar* encoding,
                              GError** error);
SkkCdbDict* skk_cdb_dict_construct (GType object_type,
                                    const gchar* path,
                                    const gchar* encoding,
                                    GError** error);
SkkDict* skk_dict_construct (GType object_type);
SkkMemoryMappedFile* skk_memory_mapped_file_new (GFile* file);
SkkMemoryMappedFile* skk_memory_mapped_file_construct (GType object_type,
                                                       GFile* file);
SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding,
                                                  GError** error);
SkkEncodingConverter* skk_encoding_converter_construct (GType object_type,
                                                        const gchar* encoding,
                                                        GError** error);
void skk_dict_reload (SkkDict* self,
                      GError** error);
static void skk_cdb_dict_finalize (GObject * obj);
gboolean skk_dict_get_read_only (SkkDict* self);
static void _vala_skk_cdb_dict_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);


static guint32
skk_cdb_dict_hash (gchar* chars,
                   int chars_length1)
{
	guint32 result = 0U;
	guint32 h = 0U;
	h = (guint32) 5381;
	{
		gchar* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = chars;
		c_collection_length1 = chars_length1;
		for (c_it = 0; c_it < chars_length1; c_it = c_it + 1) {
			gchar c = '\0';
			c = c_collection[c_it];
			{
				guint32 _tmp0_;
				guint32 _tmp1_;
				gchar _tmp2_;
				_tmp0_ = h;
				_tmp1_ = h;
				_tmp2_ = c;
				h = ((_tmp0_ << 5) + _tmp1_) ^ ((guint8) _tmp2_);
			}
		}
	}
	result = h;
	return result;
}


/**
         * {@inheritDoc}
         */
static void
skk_cdb_dict_real_reload (SkkDict* base,
                          GError** error)
{
	SkkCdbDict * self;
	gchar* attributes = NULL;
	gchar* _tmp0_;
	GFileInfo* info = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (SkkCdbDict*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_query_info (_tmp1_, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp3_ = g_file_info_get_etag (info);
	_tmp4_ = self->priv->etag;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		{
			SkkMemoryMappedFile* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = self->priv->mmap;
			skk_memory_mapped_file_remap (_tmp5_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
					goto __catch9_skk_skk_dict_error;
				}
				_g_object_unref0 (info);
				_g_free0 (attributes);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp6_ = g_file_info_get_etag (info);
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (self->priv->etag);
			self->priv->etag = _tmp7_;
		}
		goto __finally9;
		__catch9_skk_skk_dict_error:
		{
			GError* e = NULL;
			GFile* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp8_ = self->priv->file;
			_tmp9_ = g_file_get_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning ("cdb-dict.vala:47: error loading file dictionary %s %s", _tmp10_, _tmp12_);
			_g_free0 (_tmp10_);
			_g_error_free0 (e);
		}
		__finally9:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


static guint32
skk_cdb_dict_read_uint32 (guint8* p)
{
	guint32 result = 0U;
	guint8 q[4] = {0};
	guint8 _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	memcpy (q, (guint8*) p, 4 * sizeof (guint8));
	_tmp0_ = q[3];
	_tmp1_ = q[2];
	_tmp2_ = q[1];
	_tmp3_ = q[0];
	result = (guint32) ((((_tmp0_ << 24) | (_tmp1_ << 16)) | (_tmp2_ << 8)) | _tmp3_);
	return result;
}


/**
         * {@inheritDoc}
         */
static gchar*
string_to_utf8 (const gchar* self,
                int* result_length1)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static SkkCandidate**
skk_cdb_dict_real_lookup (SkkDict* base,
                          const gchar* midasi,
                          gboolean okuri,
                          int* result_length1)
{
	SkkCdbDict * self;
	SkkCandidate** result = NULL;
	SkkMemoryMappedFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	gchar* _midasi = NULL;
	guint32 h = 0U;
	const gchar* _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gint _tmp16__length1;
	guint32 _tmp17_;
	guint8* p = NULL;
	SkkMemoryMappedFile* _tmp18_;
	void* _tmp19_;
	void* _tmp20_;
	guint32 _tmp21_;
	guint32 hash_offset = 0U;
	guint8* _tmp22_;
	guint32 hash_length = 0U;
	guint8* _tmp23_;
	guint32 start = 0U;
	guint32 _tmp24_;
	guint32 _tmp25_;
	SkkMemoryMappedFile* _tmp26_;
	void* _tmp27_;
	void* _tmp28_;
	guint32 _tmp29_;
	SkkCandidate** _tmp71_;
	SkkCandidate** _tmp72_;
	gint _tmp72__length1;
	GError * _inner_error_ = NULL;
	self = (SkkCdbDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_memory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		SkkCandidate** _tmp3_;
		SkkCandidate** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	{
		gchar* _tmp5_ = NULL;
		SkkEncodingConverter* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->converter;
		_tmp7_ = skk_encoding_converter_encode (_tmp6_, midasi, &_inner_error_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch10_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp8_;
		_g_free0 (_tmp5_);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		SkkCandidate** _tmp11_;
		SkkCandidate** _tmp12_;
		gint _tmp12__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("cdb-dict.vala:71: can't encode %s: %s", midasi, _tmp10_);
		_tmp11_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp12_ = _tmp11_;
		_tmp12__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp12__length1;
		}
		result = _tmp12_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		return result;
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (_midasi);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp13_ = _midasi;
	_tmp15_ = string_to_utf8 (_tmp13_, &_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp14_;
	_tmp17_ = skk_cdb_dict_hash (_tmp16_, _tmp14_);
	_tmp16_ = (g_free (_tmp16_), NULL);
	h = _tmp17_;
	_tmp18_ = self->priv->mmap;
	_tmp19_ = skk_memory_mapped_file_get_memory (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = h;
	p = ((guint8*) _tmp20_) + ((_tmp21_ % 256) * 8);
	_tmp22_ = p;
	hash_offset = skk_cdb_dict_read_uint32 (_tmp22_);
	_tmp23_ = p;
	hash_length = skk_cdb_dict_read_uint32 (_tmp23_ + 4);
	_tmp24_ = h;
	_tmp25_ = hash_length;
	start = (_tmp24_ >> 8) % _tmp25_;
	_tmp26_ = self->priv->mmap;
	_tmp27_ = skk_memory_mapped_file_get_memory (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = hash_offset;
	p = ((guint8*) _tmp28_) + _tmp29_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				gint _tmp32_;
				guint32 _tmp33_;
				guint8* q = NULL;
				guint8* _tmp34_;
				gint _tmp35_;
				guint32 _tmp36_;
				guint32 _tmp37_;
				guint32 _h = 0U;
				guint8* _tmp38_;
				guint32 record_offset = 0U;
				guint8* _tmp39_;
				guint32 _tmp40_;
				guint32 _tmp41_;
				guint32 _tmp42_;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				_tmp32_ = i;
				_tmp33_ = hash_length;
				if (!(((guint32) _tmp32_) < _tmp33_)) {
					break;
				}
				_tmp34_ = p;
				_tmp35_ = i;
				_tmp36_ = start;
				_tmp37_ = hash_length;
				q = _tmp34_ + (8 * ((_tmp35_ + _tmp36_) % _tmp37_));
				_tmp38_ = q;
				_h = skk_cdb_dict_read_uint32 (_tmp38_);
				_tmp39_ = q;
				record_offset = skk_cdb_dict_read_uint32 (_tmp39_ + 4);
				_tmp40_ = record_offset;
				if (_tmp40_ == ((guint32) 0)) {
					break;
				}
				_tmp41_ = _h;
				_tmp42_ = h;
				if (_tmp41_ == _tmp42_) {
					guint8* r = NULL;
					SkkMemoryMappedFile* _tmp43_;
					void* _tmp44_;
					void* _tmp45_;
					guint32 _tmp46_;
					guint32 key_length = 0U;
					guint8* _tmp47_;
					guint32 data_length = 0U;
					guint8* _tmp48_;
					guint8* _tmp49_;
					const gchar* _tmp50_;
					guint32 _tmp51_;
					_tmp43_ = self->priv->mmap;
					_tmp44_ = skk_memory_mapped_file_get_memory (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = record_offset;
					r = ((guint8*) _tmp45_) + _tmp46_;
					_tmp47_ = r;
					key_length = skk_cdb_dict_read_uint32 (_tmp47_);
					_tmp48_ = r;
					data_length = skk_cdb_dict_read_uint32 (_tmp48_ + 4);
					_tmp49_ = r;
					_tmp50_ = _midasi;
					_tmp51_ = key_length;
					if (memcmp (_tmp49_ + 8, _tmp50_, (gsize) _tmp51_) == 0) {
						gchar* data = NULL;
						guint32 _tmp52_;
						gchar* _tmp53_;
						gint data_length1;
						gint _data_size_;
						gchar* _tmp54_;
						gint _tmp54__length1;
						guint8* _tmp55_;
						guint32 _tmp56_;
						guint32 _tmp57_;
						gint _tmp58_;
						gchar* _data = NULL;
						const gchar* _tmp67_;
						gint _tmp68_;
						SkkCandidate** _tmp69_;
						SkkCandidate** _tmp70_;
						gint _tmp70__length1;
						_tmp52_ = data_length;
						_tmp53_ = g_new0 (gchar, _tmp52_ + 1);
						data = _tmp53_;
						data_length1 = _tmp52_ + 1;
						_data_size_ = data_length1;
						_tmp54_ = data;
						_tmp54__length1 = data_length1;
						_tmp55_ = r;
						_tmp56_ = key_length;
						_tmp57_ = data_length;
						memcpy (_tmp54_, (_tmp55_ + 8) + _tmp56_, (gsize) _tmp57_);
						_tmp58_ = data_length1;
						data_length1 = _tmp58_ - 1;
						{
							gchar* _tmp59_ = NULL;
							SkkEncodingConverter* _tmp60_;
							gchar* _tmp61_;
							gint _tmp61__length1;
							gchar* _tmp62_;
							gchar* _tmp63_;
							_tmp60_ = self->priv->converter;
							_tmp61_ = data;
							_tmp61__length1 = data_length1;
							_tmp62_ = skk_encoding_converter_decode (_tmp60_, (const gchar*) _tmp61_, &_inner_error_);
							_tmp59_ = _tmp62_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								goto __catch11_g_error;
							}
							_tmp63_ = _tmp59_;
							_tmp59_ = NULL;
							_g_free0 (_data);
							_data = _tmp63_;
							_g_free0 (_tmp59_);
						}
						goto __finally11;
						__catch11_g_error:
						{
							GError* e = NULL;
							gchar* _tmp64_;
							gint _tmp64__length1;
							GError* _tmp65_;
							const gchar* _tmp66_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp64_ = data;
							_tmp64__length1 = data_length1;
							_tmp65_ = e;
							_tmp66_ = _tmp65_->message;
							g_warning ("cdb-dict.vala:100: can't decode data %s: %s", (const gchar*) _tmp64_, _tmp66_);
							_g_error_free0 (e);
							_g_free0 (_data);
							data = (g_free (data), NULL);
							break;
						}
						__finally11:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_free0 (_data);
							data = (g_free (data), NULL);
							_g_free0 (_midasi);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp67_ = _data;
						_tmp69_ = skk_dict_split_candidates ((SkkDict*) self, midasi, okuri, _tmp67_, &_tmp68_);
						_tmp70_ = _tmp69_;
						_tmp70__length1 = _tmp68_;
						if (result_length1) {
							*result_length1 = _tmp70__length1;
						}
						result = _tmp70_;
						_g_free0 (_data);
						data = (g_free (data), NULL);
						_g_free0 (_midasi);
						return result;
					}
				}
			}
		}
	}
	_tmp71_ = g_new0 (SkkCandidate*, 0 + 1);
	_tmp72_ = _tmp71_;
	_tmp72__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp72__length1;
	}
	result = _tmp72_;
	_g_free0 (_midasi);
	return result;
}


/**
         * {@inheritDoc}
         *
         * This always returns an empty array since CDB format does
         * not provide key enumeration.
         */
static gchar**
skk_cdb_dict_real_complete (SkkDict* base,
                            const gchar* midasi,
                            int* result_length1)
{
	SkkCdbDict * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (SkkCdbDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


/**
         * Create a new CdbDict.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default EUC-JP)
         *
         * @return a new FileDict
         * @throws GLib.Error if opening the file is failed
         */
SkkCdbDict*
skk_cdb_dict_construct (GType object_type,
                        const gchar* path,
                        const gchar* encoding,
                        GError** error)
{
	SkkCdbDict * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	SkkMemoryMappedFile* _tmp2_;
	gchar* _tmp3_;
	SkkEncodingConverter* _tmp4_ = NULL;
	SkkEncodingConverter* _tmp5_;
	SkkEncodingConverter* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkCdbDict*) skk_dict_construct (object_type);
	_tmp0_ = g_file_new_for_path (path);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = skk_memory_mapped_file_new (_tmp1_);
	_g_object_unref0 (self->priv->mmap);
	self->priv->mmap = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp3_;
	_tmp5_ = skk_encoding_converter_new (encoding, &_inner_error_);
	_tmp4_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp6_ = _tmp4_;
	_tmp4_ = NULL;
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp6_;
	skk_dict_reload ((SkkDict*) self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (_tmp4_);
	return self;
}


SkkCdbDict*
skk_cdb_dict_new (const gchar* path,
                  const gchar* encoding,
                  GError** error)
{
	return skk_cdb_dict_construct (SKK_TYPE_CDB_DICT, path, encoding, error);
}


static gboolean
skk_cdb_dict_real_get_read_only (SkkDict* base)
{
	gboolean result;
	SkkCdbDict* self;
	self = (SkkCdbDict*) base;
	result = TRUE;
	return result;
}


static void
skk_cdb_dict_class_init (SkkCdbDictClass * klass)
{
	skk_cdb_dict_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkCdbDictPrivate));
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict *, GError**)) skk_cdb_dict_real_reload;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict *, const gchar*, gboolean, int*)) skk_cdb_dict_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict *, const gchar*, int*)) skk_cdb_dict_real_complete;
	SKK_DICT_CLASS (klass)->get_read_only = skk_cdb_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_cdb_dict_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_cdb_dict_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_CDB_DICT_READ_ONLY_PROPERTY, skk_cdb_dict_properties[SKK_CDB_DICT_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
skk_cdb_dict_instance_init (SkkCdbDict * self)
{
	self->priv = SKK_CDB_DICT_GET_PRIVATE (self);
}


static void
skk_cdb_dict_finalize (GObject * obj)
{
	SkkCdbDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_CDB_DICT, SkkCdbDict);
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->mmap);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (skk_cdb_dict_parent_class)->finalize (obj);
}


/**
     * CDB based implementation of Dict.
     */
GType
skk_cdb_dict_get_type (void)
{
	static volatile gsize skk_cdb_dict_type_id__volatile = 0;
	if (g_once_init_enter (&skk_cdb_dict_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkCdbDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_cdb_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkCdbDict), 0, (GInstanceInitFunc) skk_cdb_dict_instance_init, NULL };
		GType skk_cdb_dict_type_id;
		skk_cdb_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkCdbDict", &g_define_type_info, 0);
		g_once_init_leave (&skk_cdb_dict_type_id__volatile, skk_cdb_dict_type_id);
	}
	return skk_cdb_dict_type_id__volatile;
}


static void
_vala_skk_cdb_dict_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SkkCdbDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_CDB_DICT, SkkCdbDict);
	switch (property_id) {
		case SKK_CDB_DICT_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



