/* key-event.c generated by valac 0.40.8, the Vala compiler
 * generated from key-event.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define SKK_TYPE_MODIFIER_TYPE (skk_modifier_type_get_type ())

#define SKK_TYPE_KEY_EVENT (skk_key_event_get_type ())
#define SKK_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KEY_EVENT, SkkKeyEvent))
#define SKK_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KEY_EVENT, SkkKeyEventClass))
#define SKK_IS_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KEY_EVENT))
#define SKK_IS_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KEY_EVENT))
#define SKK_KEY_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KEY_EVENT, SkkKeyEventClass))

typedef struct _SkkKeyEvent SkkKeyEvent;
typedef struct _SkkKeyEventClass SkkKeyEventClass;
typedef struct _SkkKeyEventPrivate SkkKeyEventPrivate;
enum  {
	SKK_KEY_EVENT_0_PROPERTY,
	SKK_KEY_EVENT_NAME_PROPERTY,
	SKK_KEY_EVENT_CODE_PROPERTY,
	SKK_KEY_EVENT_MODIFIERS_PROPERTY,
	SKK_KEY_EVENT_NUM_PROPERTIES
};
static GParamSpec* skk_key_event_properties[SKK_KEY_EVENT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED,
	SKK_KEY_EVENT_FORMAT_ERROR_KEYSYM_NOT_FOUND
} SkkKeyEventFormatError;
#define SKK_KEY_EVENT_FORMAT_ERROR skk_key_event_format_error_quark ()
typedef enum  {
	SKK_MODIFIER_TYPE_NONE = 0,
	SKK_MODIFIER_TYPE_SHIFT_MASK = 1 << 0,
	SKK_MODIFIER_TYPE_LOCK_MASK = 1 << 1,
	SKK_MODIFIER_TYPE_CONTROL_MASK = 1 << 2,
	SKK_MODIFIER_TYPE_MOD1_MASK = 1 << 3,
	SKK_MODIFIER_TYPE_MOD2_MASK = 1 << 4,
	SKK_MODIFIER_TYPE_MOD3_MASK = 1 << 5,
	SKK_MODIFIER_TYPE_MOD4_MASK = 1 << 6,
	SKK_MODIFIER_TYPE_MOD5_MASK = 1 << 7,
	SKK_MODIFIER_TYPE_LSHIFT_MASK = 1 << 22,
	SKK_MODIFIER_TYPE_RSHIFT_MASK = 1 << 23,
	SKK_MODIFIER_TYPE_USLEEP_MASK = 1 << 24,
	SKK_MODIFIER_TYPE_SUPER_MASK = 1 << 26,
	SKK_MODIFIER_TYPE_HYPER_MASK = 1 << 27,
	SKK_MODIFIER_TYPE_META_MASK = 1 << 28,
	SKK_MODIFIER_TYPE_RELEASE_MASK = 1 << 30
} SkkModifierType;

struct _SkkKeyEvent {
	GObject parent_instance;
	SkkKeyEventPrivate * priv;
};

struct _SkkKeyEventClass {
	GObjectClass parent_class;
};

struct _SkkKeyEventPrivate {
	gchar* _name;
	gunichar _code;
	SkkModifierType _modifiers;
};


static gpointer skk_key_event_parent_class = NULL;

GQuark skk_key_event_format_error_quark (void);
GType skk_modifier_type_get_type (void) G_GNUC_CONST;
GType skk_key_event_get_type (void) G_GNUC_CONST;
#define SKK_KEY_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_KEY_EVENT, SkkKeyEventPrivate))
SkkKeyEvent* skk_key_event_new (const gchar* name,
                                gunichar code,
                                SkkModifierType modifiers);
SkkKeyEvent* skk_key_event_construct (GType object_type,
                                      const gchar* name,
                                      gunichar code,
                                      SkkModifierType modifiers);
static void skk_key_event_set_name (SkkKeyEvent* self,
                             const gchar* value);
static void skk_key_event_set_code (SkkKeyEvent* self,
                             gunichar value);
void skk_key_event_set_modifiers (SkkKeyEvent* self,
                                  SkkModifierType value);
SkkKeyEvent* skk_key_event_copy (SkkKeyEvent* self);
const gchar* skk_key_event_get_name (SkkKeyEvent* self);
gunichar skk_key_event_get_code (SkkKeyEvent* self);
SkkModifierType skk_key_event_get_modifiers (SkkKeyEvent* self);
SkkKeyEvent* skk_key_event_new_from_string (const gchar* key,
                                            GError** error);
SkkKeyEvent* skk_key_event_construct_from_string (GType object_type,
                                                  const gchar* key,
                                                  GError** error);
#define SKK_KEYSYMS_VoidSymbol ((guint) 0xffffff)
guint skk_key_event_utils_keyval_from_name (const gchar* name);
gchar* skk_key_event_utils_keyval_name (guint keyval);
gunichar skk_key_event_utils_keyval_unicode (guint keyval);
gchar* skk_key_event_to_string (SkkKeyEvent* self);
SkkKeyEvent* skk_key_event_new_from_x_keysym (guint keyval,
                                              SkkModifierType modifiers,
                                              GError** error);
SkkKeyEvent* skk_key_event_construct_from_x_keysym (GType object_type,
                                                    guint keyval,
                                                    SkkModifierType modifiers,
                                                    GError** error);
gboolean skk_key_event_base_equal (SkkKeyEvent* self,
                                   SkkKeyEvent* key);
static void skk_key_event_finalize (GObject * obj);
static void _vala_skk_key_event_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_skk_key_event_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark
skk_key_event_format_error_quark (void)
{
	return g_quark_from_static_string ("skk_key_event_format_error-quark");
}


/**
     * A set of bit-flags to indicate the state of modifier keys.
     */
GType
skk_modifier_type_get_type (void)
{
	static volatile gsize skk_modifier_type_type_id__volatile = 0;
	if (g_once_init_enter (&skk_modifier_type_type_id__volatile)) {
		static const GFlagsValue values[] = {{SKK_MODIFIER_TYPE_NONE, "SKK_MODIFIER_TYPE_NONE", "none"}, {SKK_MODIFIER_TYPE_SHIFT_MASK, "SKK_MODIFIER_TYPE_SHIFT_MASK", "shift-mask"}, {SKK_MODIFIER_TYPE_LOCK_MASK, "SKK_MODIFIER_TYPE_LOCK_MASK", "lock-mask"}, {SKK_MODIFIER_TYPE_CONTROL_MASK, "SKK_MODIFIER_TYPE_CONTROL_MASK", "control-mask"}, {SKK_MODIFIER_TYPE_MOD1_MASK, "SKK_MODIFIER_TYPE_MOD1_MASK", "mod1-mask"}, {SKK_MODIFIER_TYPE_MOD2_MASK, "SKK_MODIFIER_TYPE_MOD2_MASK", "mod2-mask"}, {SKK_MODIFIER_TYPE_MOD3_MASK, "SKK_MODIFIER_TYPE_MOD3_MASK", "mod3-mask"}, {SKK_MODIFIER_TYPE_MOD4_MASK, "SKK_MODIFIER_TYPE_MOD4_MASK", "mod4-mask"}, {SKK_MODIFIER_TYPE_MOD5_MASK, "SKK_MODIFIER_TYPE_MOD5_MASK", "mod5-mask"}, {SKK_MODIFIER_TYPE_LSHIFT_MASK, "SKK_MODIFIER_TYPE_LSHIFT_MASK", "lshift-mask"}, {SKK_MODIFIER_TYPE_RSHIFT_MASK, "SKK_MODIFIER_TYPE_RSHIFT_MASK", "rshift-mask"}, {SKK_MODIFIER_TYPE_USLEEP_MASK, "SKK_MODIFIER_TYPE_USLEEP_MASK", "usleep-mask"}, {SKK_MODIFIER_TYPE_SUPER_MASK, "SKK_MODIFIER_TYPE_SUPER_MASK", "super-mask"}, {SKK_MODIFIER_TYPE_HYPER_MASK, "SKK_MODIFIER_TYPE_HYPER_MASK", "hyper-mask"}, {SKK_MODIFIER_TYPE_META_MASK, "SKK_MODIFIER_TYPE_META_MASK", "meta-mask"}, {SKK_MODIFIER_TYPE_RELEASE_MASK, "SKK_MODIFIER_TYPE_RELEASE_MASK", "release-mask"}, {0, NULL, NULL}};
		GType skk_modifier_type_type_id;
		skk_modifier_type_type_id = g_flags_register_static ("SkkModifierType", values);
		g_once_init_leave (&skk_modifier_type_type_id__volatile, skk_modifier_type_type_id);
	}
	return skk_modifier_type_type_id__volatile;
}


/**
         * Create a key event.
         *
         * @param name a key name
         * @param code a character code
         * @param modifiers state of modifier keys
         *
         * @return a new KeyEvent
         */
SkkKeyEvent*
skk_key_event_construct (GType object_type,
                         const gchar* name,
                         gunichar code,
                         SkkModifierType modifiers)
{
	SkkKeyEvent * self = NULL;
	self = (SkkKeyEvent*) g_object_new (object_type, NULL);
	skk_key_event_set_name (self, name);
	skk_key_event_set_code (self, code);
	skk_key_event_set_modifiers (self, modifiers);
	return self;
}


SkkKeyEvent*
skk_key_event_new (const gchar* name,
                   gunichar code,
                   SkkModifierType modifiers)
{
	return skk_key_event_construct (SKK_TYPE_KEY_EVENT, name, code, modifiers);
}


/**
         * Create a copy of the key event.
         *
         * @return a new KeyEvent
         */
SkkKeyEvent*
skk_key_event_copy (SkkKeyEvent* self)
{
	SkkKeyEvent* result = NULL;
	const gchar* _tmp0_;
	gunichar _tmp1_;
	SkkModifierType _tmp2_;
	SkkKeyEvent* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = self->priv->_code;
	_tmp2_ = self->priv->_modifiers;
	_tmp3_ = skk_key_event_new (_tmp0_, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


/**
         * Create a key event from string.
         *
         * @param key a string representation of a key event
         *
         * @return a new KeyEvent
         */
static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


SkkKeyEvent*
skk_key_event_construct_from_string (GType object_type,
                                     const gchar* key,
                                     GError** error)
{
	SkkKeyEvent * self = NULL;
	SkkModifierType _modifiers = 0;
	guint _keyval = 0U;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	self = (SkkKeyEvent*) g_object_new (object_type, NULL);
	_modifiers = 0;
	_keyval = SKK_KEYSYMS_VoidSymbol;
	if (g_str_has_prefix (key, "(usleep ")) {
		_tmp0_ = g_str_has_suffix (key, ")");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** strv = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gint strv_length1;
		gint _strv_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		SkkModifierType _tmp10_;
		_tmp1_ = string_slice (key, (glong) 1, (glong) -1);
		_tmp2_ = _tmp1_;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _vala_array_length (_tmp3_);
		_g_free0 (_tmp2_);
		strv = _tmp5_;
		strv_length1 = _tmp5__length1;
		_strv_size_ = strv_length1;
		_tmp6_ = strv;
		_tmp6__length1 = strv_length1;
		if (_tmp6__length1 != 2) {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (SKK_KEY_EVENT_FORMAT_ERROR, SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "usleep requires duration");
			_inner_error_ = _tmp7_;
			if (_inner_error_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
				g_propagate_error (error, _inner_error_);
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (self);
				return NULL;
			} else {
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp8_ = strv;
		_tmp8__length1 = strv_length1;
		_tmp9_ = _tmp8_[1];
		skk_key_event_set_name (self, _tmp9_);
		skk_key_event_set_code (self, (gunichar) '\0');
		_tmp10_ = self->priv->_modifiers;
		skk_key_event_set_modifiers (self, _tmp10_ | SKK_MODIFIER_TYPE_USLEEP_MASK);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gboolean _tmp11_ = FALSE;
		if (g_str_has_prefix (key, "(")) {
			_tmp11_ = g_str_has_suffix (key, ")");
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gchar** strv = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar** _tmp14_;
			gchar** _tmp15_;
			gchar** _tmp16_;
			gint _tmp16__length1;
			gint strv_length1;
			gint _strv_size_;
			gint index = 0;
			gboolean _tmp61_ = FALSE;
			gchar** _tmp62_;
			gint _tmp62__length1;
			gint _tmp63_;
			const gchar* _tmp64_;
			_tmp12_ = string_slice (key, (glong) 1, (glong) -1);
			_tmp13_ = _tmp12_;
			_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, " ", 0);
			_tmp16_ = _tmp15_;
			_tmp16__length1 = _vala_array_length (_tmp14_);
			_g_free0 (_tmp13_);
			strv = _tmp16_;
			strv_length1 = _tmp16__length1;
			_strv_size_ = strv_length1;
			index = 0;
			{
				gboolean _tmp17_ = FALSE;
				_tmp17_ = TRUE;
				while (TRUE) {
					gint _tmp19_;
					gchar** _tmp20_;
					gint _tmp20__length1;
					gchar** _tmp21_;
					gint _tmp21__length1;
					gint _tmp22_;
					const gchar* _tmp23_;
					if (!_tmp17_) {
						gint _tmp18_;
						_tmp18_ = index;
						index = _tmp18_ + 1;
					}
					_tmp17_ = FALSE;
					_tmp19_ = index;
					_tmp20_ = strv;
					_tmp20__length1 = strv_length1;
					if (!(_tmp19_ < (_tmp20__length1 - 1))) {
						break;
					}
					_tmp21_ = strv;
					_tmp21__length1 = strv_length1;
					_tmp22_ = index;
					_tmp23_ = _tmp21_[_tmp22_];
					if (g_strcmp0 (_tmp23_, "shift") == 0) {
						SkkModifierType _tmp24_;
						_tmp24_ = _modifiers;
						_modifiers = _tmp24_ | SKK_MODIFIER_TYPE_SHIFT_MASK;
					} else {
						gchar** _tmp25_;
						gint _tmp25__length1;
						gint _tmp26_;
						const gchar* _tmp27_;
						_tmp25_ = strv;
						_tmp25__length1 = strv_length1;
						_tmp26_ = index;
						_tmp27_ = _tmp25_[_tmp26_];
						if (g_strcmp0 (_tmp27_, "control") == 0) {
							SkkModifierType _tmp28_;
							_tmp28_ = _modifiers;
							_modifiers = _tmp28_ | SKK_MODIFIER_TYPE_CONTROL_MASK;
						} else {
							gchar** _tmp29_;
							gint _tmp29__length1;
							gint _tmp30_;
							const gchar* _tmp31_;
							_tmp29_ = strv;
							_tmp29__length1 = strv_length1;
							_tmp30_ = index;
							_tmp31_ = _tmp29_[_tmp30_];
							if (g_strcmp0 (_tmp31_, "meta") == 0) {
								SkkModifierType _tmp32_;
								_tmp32_ = _modifiers;
								_modifiers = _tmp32_ | SKK_MODIFIER_TYPE_META_MASK;
							} else {
								gchar** _tmp33_;
								gint _tmp33__length1;
								gint _tmp34_;
								const gchar* _tmp35_;
								_tmp33_ = strv;
								_tmp33__length1 = strv_length1;
								_tmp34_ = index;
								_tmp35_ = _tmp33_[_tmp34_];
								if (g_strcmp0 (_tmp35_, "hyper") == 0) {
									SkkModifierType _tmp36_;
									_tmp36_ = _modifiers;
									_modifiers = _tmp36_ | SKK_MODIFIER_TYPE_HYPER_MASK;
								} else {
									gchar** _tmp37_;
									gint _tmp37__length1;
									gint _tmp38_;
									const gchar* _tmp39_;
									_tmp37_ = strv;
									_tmp37__length1 = strv_length1;
									_tmp38_ = index;
									_tmp39_ = _tmp37_[_tmp38_];
									if (g_strcmp0 (_tmp39_, "super") == 0) {
										SkkModifierType _tmp40_;
										_tmp40_ = _modifiers;
										_modifiers = _tmp40_ | SKK_MODIFIER_TYPE_SUPER_MASK;
									} else {
										gchar** _tmp41_;
										gint _tmp41__length1;
										gint _tmp42_;
										const gchar* _tmp43_;
										_tmp41_ = strv;
										_tmp41__length1 = strv_length1;
										_tmp42_ = index;
										_tmp43_ = _tmp41_[_tmp42_];
										if (g_strcmp0 (_tmp43_, "alt") == 0) {
											SkkModifierType _tmp44_;
											_tmp44_ = _modifiers;
											_modifiers = _tmp44_ | SKK_MODIFIER_TYPE_MOD1_MASK;
										} else {
											gchar** _tmp45_;
											gint _tmp45__length1;
											gint _tmp46_;
											const gchar* _tmp47_;
											_tmp45_ = strv;
											_tmp45__length1 = strv_length1;
											_tmp46_ = index;
											_tmp47_ = _tmp45_[_tmp46_];
											if (g_strcmp0 (_tmp47_, "lshift") == 0) {
												SkkModifierType _tmp48_;
												_tmp48_ = _modifiers;
												_modifiers = _tmp48_ | SKK_MODIFIER_TYPE_LSHIFT_MASK;
											} else {
												gchar** _tmp49_;
												gint _tmp49__length1;
												gint _tmp50_;
												const gchar* _tmp51_;
												_tmp49_ = strv;
												_tmp49__length1 = strv_length1;
												_tmp50_ = index;
												_tmp51_ = _tmp49_[_tmp50_];
												if (g_strcmp0 (_tmp51_, "rshift") == 0) {
													SkkModifierType _tmp52_;
													_tmp52_ = _modifiers;
													_modifiers = _tmp52_ | SKK_MODIFIER_TYPE_RSHIFT_MASK;
												} else {
													gchar** _tmp53_;
													gint _tmp53__length1;
													gint _tmp54_;
													const gchar* _tmp55_;
													_tmp53_ = strv;
													_tmp53__length1 = strv_length1;
													_tmp54_ = index;
													_tmp55_ = _tmp53_[_tmp54_];
													if (g_strcmp0 (_tmp55_, "release") == 0) {
														SkkModifierType _tmp56_;
														_tmp56_ = _modifiers;
														_modifiers = _tmp56_ | SKK_MODIFIER_TYPE_RELEASE_MASK;
													} else {
														gchar** _tmp57_;
														gint _tmp57__length1;
														gint _tmp58_;
														const gchar* _tmp59_;
														GError* _tmp60_;
														_tmp57_ = strv;
														_tmp57__length1 = strv_length1;
														_tmp58_ = index;
														_tmp59_ = _tmp57_[_tmp58_];
														_tmp60_ = g_error_new (SKK_KEY_EVENT_FORMAT_ERROR, SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown modifier %s", _tmp59_);
														_inner_error_ = _tmp60_;
														if (_inner_error_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
															g_propagate_error (error, _inner_error_);
															strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
															_g_object_unref0 (self);
															return NULL;
														} else {
															strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return NULL;
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp62_ = strv;
			_tmp62__length1 = strv_length1;
			_tmp63_ = index;
			_tmp64_ = _tmp62_[_tmp63_];
			if (g_strcmp0 (_tmp64_, "lshift") == 0) {
				_tmp61_ = TRUE;
			} else {
				gchar** _tmp65_;
				gint _tmp65__length1;
				gint _tmp66_;
				const gchar* _tmp67_;
				_tmp65_ = strv;
				_tmp65__length1 = strv_length1;
				_tmp66_ = index;
				_tmp67_ = _tmp65_[_tmp66_];
				_tmp61_ = g_strcmp0 (_tmp67_, "rshift") == 0;
			}
			if (_tmp61_) {
				gchar** _tmp68_;
				gint _tmp68__length1;
				gint _tmp69_;
				const gchar* _tmp70_;
				_tmp68_ = strv;
				_tmp68__length1 = strv_length1;
				_tmp69_ = index;
				_tmp70_ = _tmp68_[_tmp69_];
				skk_key_event_set_name (self, _tmp70_);
				skk_key_event_set_code (self, (gunichar) '\0');
				skk_key_event_set_modifiers (self, SKK_MODIFIER_TYPE_NONE);
			} else {
				gchar** _tmp71_;
				gint _tmp71__length1;
				gint _tmp72_;
				const gchar* _tmp73_;
				guint _tmp74_;
				guint _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				guint _tmp82_;
				SkkModifierType _tmp83_;
				_tmp71_ = strv;
				_tmp71__length1 = strv_length1;
				_tmp72_ = index;
				_tmp73_ = _tmp71_[_tmp72_];
				_keyval = skk_key_event_utils_keyval_from_name (_tmp73_);
				_tmp74_ = _keyval;
				if (_tmp74_ == SKK_KEYSYMS_VoidSymbol) {
					gchar** _tmp75_;
					gint _tmp75__length1;
					gint _tmp76_;
					const gchar* _tmp77_;
					GError* _tmp78_;
					_tmp75_ = strv;
					_tmp75__length1 = strv_length1;
					_tmp76_ = index;
					_tmp77_ = _tmp75_[_tmp76_];
					_tmp78_ = g_error_new (SKK_KEY_EVENT_FORMAT_ERROR, SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown keyval %s", _tmp77_);
					_inner_error_ = _tmp78_;
					if (_inner_error_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
						g_propagate_error (error, _inner_error_);
						strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (self);
						return NULL;
					} else {
						strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp79_ = _keyval;
				_tmp80_ = skk_key_event_utils_keyval_name (_tmp79_);
				_tmp81_ = _tmp80_;
				skk_key_event_set_name (self, _tmp81_);
				_g_free0 (_tmp81_);
				_tmp82_ = _keyval;
				skk_key_event_set_code (self, skk_key_event_utils_keyval_unicode (_tmp82_));
				_tmp83_ = _modifiers;
				skk_key_event_set_modifiers (self, _tmp83_);
			}
			strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		} else {
			gboolean _tmp84_ = FALSE;
			gboolean _tmp85_ = FALSE;
			if (g_str_has_prefix (key, "[")) {
				_tmp85_ = g_str_has_suffix (key, "]");
			} else {
				_tmp85_ = FALSE;
			}
			if (_tmp85_) {
				_tmp84_ = g_utf8_strlen (key, (gssize) -1) == 4;
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				skk_key_event_set_name (self, key);
				skk_key_event_set_code (self, (gunichar) '\0');
				skk_key_event_set_modifiers (self, SKK_MODIFIER_TYPE_NONE);
			} else {
				gint index = 0;
				gchar* _name = NULL;
				gint _tmp86_;
				const gchar* _tmp108_;
				guint _tmp109_;
				guint _tmp112_;
				gchar* _tmp113_;
				gchar* _tmp114_;
				guint _tmp115_;
				SkkModifierType _tmp116_;
				index = string_last_index_of (key, "-", 0);
				_name = NULL;
				_tmp86_ = index;
				if (_tmp86_ > 0) {
					gchar** mods = NULL;
					gint _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar** _tmp90_;
					gchar** _tmp91_;
					gchar** _tmp92_;
					gint _tmp92__length1;
					gint mods_length1;
					gint _mods_size_;
					gchar** _tmp93_;
					gint _tmp93__length1;
					gint _tmp105_;
					gchar* _tmp106_;
					_tmp87_ = index;
					_tmp88_ = string_substring (key, (glong) 0, (glong) _tmp87_);
					_tmp89_ = _tmp88_;
					_tmp91_ = _tmp90_ = g_strsplit (_tmp89_, "-", 0);
					_tmp92_ = _tmp91_;
					_tmp92__length1 = _vala_array_length (_tmp90_);
					_g_free0 (_tmp89_);
					mods = _tmp92_;
					mods_length1 = _tmp92__length1;
					_mods_size_ = mods_length1;
					_tmp93_ = mods;
					_tmp93__length1 = mods_length1;
					{
						gchar** mod_collection = NULL;
						gint mod_collection_length1 = 0;
						gint _mod_collection_size_ = 0;
						gint mod_it = 0;
						mod_collection = _tmp93_;
						mod_collection_length1 = _tmp93__length1;
						for (mod_it = 0; mod_it < _tmp93__length1; mod_it = mod_it + 1) {
							gchar* _tmp94_;
							gchar* mod = NULL;
							_tmp94_ = g_strdup (mod_collection[mod_it]);
							mod = _tmp94_;
							{
								const gchar* _tmp95_;
								_tmp95_ = mod;
								if (g_strcmp0 (_tmp95_, "S") == 0) {
									SkkModifierType _tmp96_;
									_tmp96_ = _modifiers;
									_modifiers = _tmp96_ | SKK_MODIFIER_TYPE_SHIFT_MASK;
								} else {
									const gchar* _tmp97_;
									_tmp97_ = mod;
									if (g_strcmp0 (_tmp97_, "C") == 0) {
										SkkModifierType _tmp98_;
										_tmp98_ = _modifiers;
										_modifiers = _tmp98_ | SKK_MODIFIER_TYPE_CONTROL_MASK;
									} else {
										const gchar* _tmp99_;
										_tmp99_ = mod;
										if (g_strcmp0 (_tmp99_, "A") == 0) {
											SkkModifierType _tmp100_;
											_tmp100_ = _modifiers;
											_modifiers = _tmp100_ | SKK_MODIFIER_TYPE_MOD1_MASK;
										} else {
											const gchar* _tmp101_;
											_tmp101_ = mod;
											if (g_strcmp0 (_tmp101_, "M") == 0) {
												SkkModifierType _tmp102_;
												_tmp102_ = _modifiers;
												_modifiers = _tmp102_ | SKK_MODIFIER_TYPE_META_MASK;
											} else {
												const gchar* _tmp103_;
												_tmp103_ = mod;
												if (g_strcmp0 (_tmp103_, "G") == 0) {
													SkkModifierType _tmp104_;
													_tmp104_ = _modifiers;
													_modifiers = _tmp104_ | SKK_MODIFIER_TYPE_MOD5_MASK;
												}
											}
										}
									}
								}
								_g_free0 (mod);
							}
						}
					}
					_tmp105_ = index;
					_tmp106_ = string_substring (key, (glong) (_tmp105_ + 1), (glong) -1);
					_g_free0 (_name);
					_name = _tmp106_;
					mods = (_vala_array_free (mods, mods_length1, (GDestroyNotify) g_free), NULL);
				} else {
					gchar* _tmp107_;
					_modifiers = SKK_MODIFIER_TYPE_NONE;
					_tmp107_ = g_strdup (key);
					_g_free0 (_name);
					_name = _tmp107_;
				}
				_tmp108_ = _name;
				_keyval = skk_key_event_utils_keyval_from_name (_tmp108_);
				_tmp109_ = _keyval;
				if (_tmp109_ == SKK_KEYSYMS_VoidSymbol) {
					const gchar* _tmp110_;
					GError* _tmp111_;
					_tmp110_ = _name;
					_tmp111_ = g_error_new (SKK_KEY_EVENT_FORMAT_ERROR, SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown keyval %s", _tmp110_);
					_inner_error_ = _tmp111_;
					if (_inner_error_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_name);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_free0 (_name);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp112_ = _keyval;
				_tmp113_ = skk_key_event_utils_keyval_name (_tmp112_);
				_tmp114_ = _tmp113_;
				skk_key_event_set_name (self, _tmp114_);
				_g_free0 (_tmp114_);
				_tmp115_ = _keyval;
				skk_key_event_set_code (self, skk_key_event_utils_keyval_unicode (_tmp115_));
				_tmp116_ = _modifiers;
				skk_key_event_set_modifiers (self, _tmp116_);
				_g_free0 (_name);
			}
		}
	}
	return self;
}


SkkKeyEvent*
skk_key_event_new_from_string (const gchar* key,
                               GError** error)
{
	return skk_key_event_construct_from_string (SKK_TYPE_KEY_EVENT, key, error);
}


/**
         * Convert the KeyEvent to string.
         *
         * @return a string representing the KeyEvent
         */
static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


gchar*
skk_key_event_to_string (SkkKeyEvent* self)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _base = NULL;
	gchar* _tmp6_;
	SkkModifierType _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_name;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gunichar _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->_code;
		_tmp5_ = g_unichar_to_string (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp0_);
	_base = _tmp6_;
	_tmp7_ = self->priv->_modifiers;
	if (_tmp7_ != 0) {
		GeeArrayList* elements = NULL;
		GeeArrayList* _tmp8_;
		SkkModifierType _tmp9_;
		SkkModifierType _tmp11_;
		SkkModifierType _tmp13_;
		SkkModifierType _tmp15_;
		SkkModifierType _tmp17_;
		SkkModifierType _tmp19_;
		SkkModifierType _tmp21_;
		SkkModifierType _tmp23_;
		SkkModifierType _tmp25_;
		GeeArrayList* _tmp27_;
		const gchar* _tmp28_;
		GeeArrayList* _tmp29_;
		gchar** array = NULL;
		GeeArrayList* _tmp30_;
		gint _tmp31_;
		gpointer* _tmp32_;
		gint array_length1;
		gint _array_size_;
		gint old_length = 0;
		gchar** _tmp33_;
		gint _tmp33__length1;
		gint _tmp34_;
		gchar* key_string = NULL;
		gchar** _tmp35_;
		gint _tmp35__length1;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		elements = _tmp8_;
		_tmp9_ = self->priv->_modifiers;
		if ((_tmp9_ & SKK_MODIFIER_TYPE_CONTROL_MASK) != 0) {
			GeeArrayList* _tmp10_;
			_tmp10_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "control");
		}
		_tmp11_ = self->priv->_modifiers;
		if ((_tmp11_ & SKK_MODIFIER_TYPE_META_MASK) != 0) {
			GeeArrayList* _tmp12_;
			_tmp12_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "meta");
		}
		_tmp13_ = self->priv->_modifiers;
		if ((_tmp13_ & SKK_MODIFIER_TYPE_HYPER_MASK) != 0) {
			GeeArrayList* _tmp14_;
			_tmp14_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "hyper");
		}
		_tmp15_ = self->priv->_modifiers;
		if ((_tmp15_ & SKK_MODIFIER_TYPE_SUPER_MASK) != 0) {
			GeeArrayList* _tmp16_;
			_tmp16_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, "super");
		}
		_tmp17_ = self->priv->_modifiers;
		if ((_tmp17_ & SKK_MODIFIER_TYPE_MOD1_MASK) != 0) {
			GeeArrayList* _tmp18_;
			_tmp18_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, "alt");
		}
		_tmp19_ = self->priv->_modifiers;
		if ((_tmp19_ & SKK_MODIFIER_TYPE_LSHIFT_MASK) != 0) {
			GeeArrayList* _tmp20_;
			_tmp20_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, "lshift");
		}
		_tmp21_ = self->priv->_modifiers;
		if ((_tmp21_ & SKK_MODIFIER_TYPE_RSHIFT_MASK) != 0) {
			GeeArrayList* _tmp22_;
			_tmp22_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, "rshift");
		}
		_tmp23_ = self->priv->_modifiers;
		if ((_tmp23_ & SKK_MODIFIER_TYPE_USLEEP_MASK) != 0) {
			GeeArrayList* _tmp24_;
			_tmp24_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, "usleep");
		}
		_tmp25_ = self->priv->_modifiers;
		if ((_tmp25_ & SKK_MODIFIER_TYPE_RELEASE_MASK) != 0) {
			GeeArrayList* _tmp26_;
			_tmp26_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, "release");
		}
		_tmp27_ = elements;
		_tmp28_ = _base;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
		_tmp29_ = elements;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, NULL);
		_tmp30_ = elements;
		_tmp32_ = gee_collection_to_array ((GeeCollection*) _tmp30_, &_tmp31_);
		array = _tmp32_;
		array_length1 = _tmp31_;
		_array_size_ = array_length1;
		_tmp33_ = array;
		_tmp33__length1 = array_length1;
		old_length = _tmp33__length1;
		array_length1 = -1;
		_tmp34_ = array_length1;
		_tmp35_ = array;
		_tmp35__length1 = array_length1;
		_tmp36_ = _vala_g_strjoinv (" ", _tmp35_, _tmp35__length1);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat ("(", _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp39_, ")", NULL);
		_tmp41_ = _tmp40_;
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		key_string = _tmp41_;
		_tmp42_ = old_length;
		array_length1 = _tmp42_;
		_tmp43_ = array_length1;
		result = key_string;
		array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (elements);
		_g_free0 (_base);
		_g_free0 (_tmp0_);
		return result;
	} else {
		result = _base;
		_g_free0 (_tmp0_);
		return result;
	}
	_g_free0 (_base);
	_g_free0 (_tmp0_);
}


/**
         * Create a key event from an X keysym and modifiers.
         *
         * @param keyval an X keysym
         * @param modifiers modifier mask
         *
         * @return a new KeyEvent
         */
SkkKeyEvent*
skk_key_event_construct_from_x_keysym (GType object_type,
                                       guint keyval,
                                       SkkModifierType modifiers,
                                       GError** error)
{
	SkkKeyEvent * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SkkKeyEvent*) g_object_new (object_type, NULL);
	_tmp0_ = skk_key_event_utils_keyval_name (keyval);
	_tmp1_ = _tmp0_;
	skk_key_event_set_name (self, _tmp1_);
	_g_free0 (_tmp1_);
	skk_key_event_set_code (self, skk_key_event_utils_keyval_unicode (keyval));
	skk_key_event_set_modifiers (self, modifiers);
	return self;
}


SkkKeyEvent*
skk_key_event_new_from_x_keysym (guint keyval,
                                 SkkModifierType modifiers,
                                 GError** error)
{
	return skk_key_event_construct_from_x_keysym (SKK_TYPE_KEY_EVENT, keyval, modifiers, error);
}


/**
         * Compare two key events ignoring modifiers.
         *
         * @param key a KeyEvent
         *
         * @return `true` if those base components are equal, `false` otherwise
         */
gboolean
skk_key_event_base_equal (SkkKeyEvent* self,
                          SkkKeyEvent* key)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gunichar _tmp1_;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = self->priv->_code;
	_tmp2_ = key->priv->_code;
	if (_tmp1_ == _tmp2_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_name;
		_tmp4_ = key->priv->_name;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


const gchar*
skk_key_event_get_name (SkkKeyEvent* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void
skk_key_event_set_name (SkkKeyEvent* self,
                        const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, skk_key_event_get_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, skk_key_event_properties[SKK_KEY_EVENT_NAME_PROPERTY]);
	}
}


gunichar
skk_key_event_get_code (SkkKeyEvent* self)
{
	gunichar result;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_code;
	result = _tmp0_;
	return result;
}


static void
skk_key_event_set_code (SkkKeyEvent* self,
                        gunichar value)
{
	g_return_if_fail (self != NULL);
	if (skk_key_event_get_code (self) != value) {
		self->priv->_code = value;
		g_object_notify_by_pspec ((GObject *) self, skk_key_event_properties[SKK_KEY_EVENT_CODE_PROPERTY]);
	}
}


SkkModifierType
skk_key_event_get_modifiers (SkkKeyEvent* self)
{
	SkkModifierType result;
	SkkModifierType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


void
skk_key_event_set_modifiers (SkkKeyEvent* self,
                             SkkModifierType value)
{
	g_return_if_fail (self != NULL);
	if (skk_key_event_get_modifiers (self) != value) {
		self->priv->_modifiers = value;
		g_object_notify_by_pspec ((GObject *) self, skk_key_event_properties[SKK_KEY_EVENT_MODIFIERS_PROPERTY]);
	}
}


static void
skk_key_event_class_init (SkkKeyEventClass * klass)
{
	skk_key_event_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkKeyEventPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_key_event_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_skk_key_event_set_property;
	G_OBJECT_CLASS (klass)->finalize = skk_key_event_finalize;
	/**
	         * The base name of the KeyEvent.
	         *
	         * This is exclusive to {@link code}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_NAME_PROPERTY, skk_key_event_properties[SKK_KEY_EVENT_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * The base code of the KeyEvent.
	         *
	         * This is exclusive to {@link name}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_CODE_PROPERTY, skk_key_event_properties[SKK_KEY_EVENT_CODE_PROPERTY] = g_param_spec_uint ("code", "code", "code", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Modifier mask.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_MODIFIERS_PROPERTY, skk_key_event_properties[SKK_KEY_EVENT_MODIFIERS_PROPERTY] = g_param_spec_flags ("modifiers", "modifiers", "modifiers", SKK_TYPE_MODIFIER_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
skk_key_event_instance_init (SkkKeyEvent * self)
{
	self->priv = SKK_KEY_EVENT_GET_PRIVATE (self);
}


static void
skk_key_event_finalize (GObject * obj)
{
	SkkKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_KEY_EVENT, SkkKeyEvent);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (skk_key_event_parent_class)->finalize (obj);
}


/**
     * Object representing a key event.
     */
GType
skk_key_event_get_type (void)
{
	static volatile gsize skk_key_event_type_id__volatile = 0;
	if (g_once_init_enter (&skk_key_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkKeyEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_key_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkKeyEvent), 0, (GInstanceInitFunc) skk_key_event_instance_init, NULL };
		GType skk_key_event_type_id;
		skk_key_event_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkKeyEvent", &g_define_type_info, 0);
		g_once_init_leave (&skk_key_event_type_id__volatile, skk_key_event_type_id);
	}
	return skk_key_event_type_id__volatile;
}


static void
_vala_skk_key_event_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SkkKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_KEY_EVENT, SkkKeyEvent);
	switch (property_id) {
		case SKK_KEY_EVENT_NAME_PROPERTY:
		g_value_set_string (value, skk_key_event_get_name (self));
		break;
		case SKK_KEY_EVENT_CODE_PROPERTY:
		g_value_set_uint (value, skk_key_event_get_code (self));
		break;
		case SKK_KEY_EVENT_MODIFIERS_PROPERTY:
		g_value_set_flags (value, skk_key_event_get_modifiers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_skk_key_event_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	SkkKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_KEY_EVENT, SkkKeyEvent);
	switch (property_id) {
		case SKK_KEY_EVENT_NAME_PROPERTY:
		skk_key_event_set_name (self, g_value_get_string (value));
		break;
		case SKK_KEY_EVENT_CODE_PROPERTY:
		skk_key_event_set_code (self, g_value_get_uint (value));
		break;
		case SKK_KEY_EVENT_MODIFIERS_PROPERTY:
		skk_key_event_set_modifiers (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



