; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefixes=X64

define i32 @test_addcarry_32_x_0_false(i32 %a0)  {
; X86-LABEL: test_addcarry_32_x_0_false:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_addcarry_32_x_0_false:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    retq
  %1 = tail call { i8, i32 } @llvm.x86.addcarry.32(i8 0, i32 %a0, i32 0)
  %2 = extractvalue { i8, i32 } %1, 1
  ret i32 %2
}

define i32 @test_addcarry_32_0_x_false(i32 %a0)  {
; X86-LABEL: test_addcarry_32_0_x_false:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_addcarry_32_0_x_false:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    retq
  %1 = tail call { i8, i32 } @llvm.x86.addcarry.32(i8 0, i32 0, i32 %a0)
  %2 = extractvalue { i8, i32 } %1, 1
  ret i32 %2
}

define i32 @test_subborrow_32_x_0_false(i32 %a0)  {
; X86-LABEL: test_subborrow_32_x_0_false:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_subborrow_32_x_0_false:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    retq
  %1 = tail call { i8, i32 } @llvm.x86.subborrow.32(i8 0, i32 %a0, i32 0)
  %2 = extractvalue { i8, i32 } %1, 1
  ret i32 %2
}

define i32 @test_subborrow_32_0_x_false(i32 %a0)  {
; X86-LABEL: test_subborrow_32_0_x_false:
; X86:       # %bb.0:
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    subl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_subborrow_32_0_x_false:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    retq
  %1 = tail call { i8, i32 } @llvm.x86.subborrow.32(i8 0, i32 0, i32 %a0)
  %2 = extractvalue { i8, i32 } %1, 1
  ret i32 %2
}

declare { i8, i32 } @llvm.x86.addcarry.32(i8, i32, i32)
declare { i8, i32 } @llvm.x86.subborrow.32(i8, i32, i32)
