/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedBoolean.h"

#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAnimatedBooleanTableValues[] =
{
    { "baseVal", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanBaseVal), (intptr_t)setJSSVGAnimatedBooleanBaseVal, NoIntrinsic },
    { "animVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanAnimVal), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedBooleanTable = { 8, 7, JSSVGAnimatedBooleanTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedBooleanConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedBooleanConstructorTable = { 1, 0, JSSVGAnimatedBooleanConstructorTableValues, 0 };
const ClassInfo JSSVGAnimatedBooleanConstructor::s_info = { "SVGAnimatedBooleanConstructor", &Base::s_info, &JSSVGAnimatedBooleanConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedBooleanConstructor) };

JSSVGAnimatedBooleanConstructor::JSSVGAnimatedBooleanConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAnimatedBooleanConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGAnimatedBooleanPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGAnimatedBooleanConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedBooleanConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedBooleanConstructorTable, jsCast<JSSVGAnimatedBooleanConstructor*>(cell), propertyName, slot);
}

bool JSSVGAnimatedBooleanConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedBooleanConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedBooleanConstructorTable, jsCast<JSSVGAnimatedBooleanConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedBooleanPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedBooleanPrototypeTable = { 1, 0, JSSVGAnimatedBooleanPrototypeTableValues, 0 };
const ClassInfo JSSVGAnimatedBooleanPrototype::s_info = { "SVGAnimatedBooleanPrototype", &Base::s_info, &JSSVGAnimatedBooleanPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedBooleanPrototype) };

JSObject* JSSVGAnimatedBooleanPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedBoolean>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedBoolean::s_info = { "SVGAnimatedBoolean", &Base::s_info, &JSSVGAnimatedBooleanTable, 0 , CREATE_METHOD_TABLE(JSSVGAnimatedBoolean) };

JSSVGAnimatedBoolean::JSSVGAnimatedBoolean(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedBoolean> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGAnimatedBoolean::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAnimatedBoolean::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedBooleanPrototype::create(exec->globalData(), globalObject, JSSVGAnimatedBooleanPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGAnimatedBoolean::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedBoolean* thisObject = static_cast<JSSVGAnimatedBoolean*>(cell);
    thisObject->JSSVGAnimatedBoolean::~JSSVGAnimatedBoolean();
}

JSSVGAnimatedBoolean::~JSSVGAnimatedBoolean()
{
    releaseImplIfNotNull();
}

bool JSSVGAnimatedBoolean::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAnimatedBoolean* thisObject = jsCast<JSSVGAnimatedBoolean*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAnimatedBoolean, Base>(exec, &JSSVGAnimatedBooleanTable, thisObject, propertyName, slot);
}

bool JSSVGAnimatedBoolean::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAnimatedBoolean* thisObject = jsCast<JSSVGAnimatedBoolean*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAnimatedBoolean, Base>(exec, &JSSVGAnimatedBooleanTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAnimatedBooleanBaseVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedBoolean* castedThis = jsCast<JSSVGAnimatedBoolean*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedBoolean* impl = static_cast<SVGAnimatedBoolean*>(castedThis->impl());
    JSValue result = jsBoolean(impl->baseVal());
    return result;
}


JSValue jsSVGAnimatedBooleanAnimVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedBoolean* castedThis = jsCast<JSSVGAnimatedBoolean*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedBoolean* impl = static_cast<SVGAnimatedBoolean*>(castedThis->impl());
    JSValue result = jsBoolean(impl->animVal());
    return result;
}


JSValue jsSVGAnimatedBooleanConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedBoolean* domObject = jsCast<JSSVGAnimatedBoolean*>(asObject(slotBase));
    return JSSVGAnimatedBoolean::getConstructor(exec, domObject->globalObject());
}

void JSSVGAnimatedBoolean::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGAnimatedBoolean* thisObject = jsCast<JSSVGAnimatedBoolean*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGAnimatedBoolean, Base>(exec, propertyName, value, &JSSVGAnimatedBooleanTable, thisObject, slot);
}

void setJSSVGAnimatedBooleanBaseVal(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGAnimatedBoolean* castedThis = jsCast<JSSVGAnimatedBoolean*>(thisObject);
    SVGAnimatedBoolean* impl = static_cast<SVGAnimatedBoolean*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setBaseVal(value.toBoolean(exec), ec);
    setDOMException(exec, ec);
}


JSValue JSSVGAnimatedBoolean::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedBooleanConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSVGAnimatedBoolean* jsSVGAnimatedBoolean)
{
    if (jsSVGAnimatedBoolean->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGAnimatedBooleanOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGAnimatedBoolean* jsSVGAnimatedBoolean = jsCast<JSSVGAnimatedBoolean*>(handle.get().asCell());
    if (!isObservable(jsSVGAnimatedBoolean))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedBooleanOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGAnimatedBoolean* jsSVGAnimatedBoolean = jsCast<JSSVGAnimatedBoolean*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGAnimatedBoolean->impl(), jsSVGAnimatedBoolean);
    jsSVGAnimatedBoolean->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedBoolean* impl)
{
    return wrap<JSSVGAnimatedBoolean>(exec, globalObject, impl);
}

SVGAnimatedBoolean* toSVGAnimatedBoolean(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedBoolean::s_info) ? jsCast<JSSVGAnimatedBoolean*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
