/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFETurbulenceElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedInteger.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGFETurbulenceElement.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFETurbulenceElementTableValues[] =
{
    { "baseFrequencyX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementBaseFrequencyX), (intptr_t)0, NoIntrinsic },
    { "baseFrequencyY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementBaseFrequencyY), (intptr_t)0, NoIntrinsic },
    { "numOctaves", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementNumOctaves), (intptr_t)0, NoIntrinsic },
    { "seed", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSeed), (intptr_t)0, NoIntrinsic },
    { "stitchTiles", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementStitchTiles), (intptr_t)0, NoIntrinsic },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementType), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementResult), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFETurbulenceElementTable = { 35, 31, JSSVGFETurbulenceElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFETurbulenceElementConstructorTableValues[] =
{
    { "SVG_TURBULENCE_TYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_TURBULENCE_TYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_TURBULENCE_TYPE_FRACTALNOISE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_TURBULENCE_TYPE_FRACTALNOISE), (intptr_t)0, NoIntrinsic },
    { "SVG_TURBULENCE_TYPE_TURBULENCE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_TURBULENCE_TYPE_TURBULENCE), (intptr_t)0, NoIntrinsic },
    { "SVG_STITCHTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_STITCHTYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_STITCHTYPE_STITCH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_STITCHTYPE_STITCH), (intptr_t)0, NoIntrinsic },
    { "SVG_STITCHTYPE_NOSTITCH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_STITCHTYPE_NOSTITCH), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFETurbulenceElementConstructorTable = { 18, 15, JSSVGFETurbulenceElementConstructorTableValues, 0 };
const ClassInfo JSSVGFETurbulenceElementConstructor::s_info = { "SVGFETurbulenceElementConstructor", &Base::s_info, &JSSVGFETurbulenceElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFETurbulenceElementConstructor) };

JSSVGFETurbulenceElementConstructor::JSSVGFETurbulenceElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFETurbulenceElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFETurbulenceElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFETurbulenceElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFETurbulenceElementConstructor, JSDOMWrapper>(exec, &JSSVGFETurbulenceElementConstructorTable, jsCast<JSSVGFETurbulenceElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFETurbulenceElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFETurbulenceElementConstructor, JSDOMWrapper>(exec, &JSSVGFETurbulenceElementConstructorTable, jsCast<JSSVGFETurbulenceElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFETurbulenceElementPrototypeTableValues[] =
{
    { "SVG_TURBULENCE_TYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_TURBULENCE_TYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_TURBULENCE_TYPE_FRACTALNOISE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_TURBULENCE_TYPE_FRACTALNOISE), (intptr_t)0, NoIntrinsic },
    { "SVG_TURBULENCE_TYPE_TURBULENCE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_TURBULENCE_TYPE_TURBULENCE), (intptr_t)0, NoIntrinsic },
    { "SVG_STITCHTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_STITCHTYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_STITCHTYPE_STITCH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_STITCHTYPE_STITCH), (intptr_t)0, NoIntrinsic },
    { "SVG_STITCHTYPE_NOSTITCH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFETurbulenceElementSVG_STITCHTYPE_NOSTITCH), (intptr_t)0, NoIntrinsic },
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGFETurbulenceElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFETurbulenceElementPrototypeTable = { 18, 15, JSSVGFETurbulenceElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFETurbulenceElementPrototype::s_info = { "SVGFETurbulenceElementPrototype", &Base::s_info, &JSSVGFETurbulenceElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFETurbulenceElementPrototype) };

JSObject* JSSVGFETurbulenceElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFETurbulenceElement>(exec, globalObject);
}

bool JSSVGFETurbulenceElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFETurbulenceElementPrototype* thisObject = jsCast<JSSVGFETurbulenceElementPrototype*>(cell);
    return getStaticPropertySlot<JSSVGFETurbulenceElementPrototype, JSObject>(exec, &JSSVGFETurbulenceElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGFETurbulenceElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFETurbulenceElementPrototype* thisObject = jsCast<JSSVGFETurbulenceElementPrototype*>(object);
    return getStaticPropertyDescriptor<JSSVGFETurbulenceElementPrototype, JSObject>(exec, &JSSVGFETurbulenceElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGFETurbulenceElement::s_info = { "SVGFETurbulenceElement", &Base::s_info, &JSSVGFETurbulenceElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFETurbulenceElement) };

JSSVGFETurbulenceElement::JSSVGFETurbulenceElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFETurbulenceElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGFETurbulenceElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFETurbulenceElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFETurbulenceElementPrototype::create(exec->globalData(), globalObject, JSSVGFETurbulenceElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFETurbulenceElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFETurbulenceElement* thisObject = jsCast<JSSVGFETurbulenceElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFETurbulenceElement, Base>(exec, &JSSVGFETurbulenceElementTable, thisObject, propertyName, slot);
}

bool JSSVGFETurbulenceElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFETurbulenceElement* thisObject = jsCast<JSSVGFETurbulenceElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFETurbulenceElement, Base>(exec, &JSSVGFETurbulenceElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFETurbulenceElementBaseFrequencyX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->baseFrequencyXAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementBaseFrequencyY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->baseFrequencyYAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementNumOctaves(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedInteger> obj = impl->numOctavesAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementSeed(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->seedAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementStitchTiles(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->stitchTilesAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->typeAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFETurbulenceElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGFETurbulenceElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFETurbulenceElement* domObject = jsCast<JSSVGFETurbulenceElement*>(asObject(slotBase));
    return JSSVGFETurbulenceElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFETurbulenceElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFETurbulenceElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGFETurbulenceElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGFETurbulenceElement::s_info))
        return throwVMTypeError(exec);
    JSSVGFETurbulenceElement* castedThis = jsCast<JSSVGFETurbulenceElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGFETurbulenceElement::s_info);
    SVGFETurbulenceElement* impl = static_cast<SVGFETurbulenceElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}

// Constant getters

JSValue jsSVGFETurbulenceElementSVG_TURBULENCE_TYPE_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGFETurbulenceElementSVG_TURBULENCE_TYPE_FRACTALNOISE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGFETurbulenceElementSVG_TURBULENCE_TYPE_TURBULENCE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGFETurbulenceElementSVG_STITCHTYPE_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGFETurbulenceElementSVG_STITCHTYPE_STITCH(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGFETurbulenceElementSVG_STITCHTYPE_NOSTITCH(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
