/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.communication;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.MessageFormat;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.Activator;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.communication.Messages;
import org.eclipse.fordiac.ide.monitoring.communication.MonitorInformation;
import org.eclipse.fordiac.ide.monitoring.communication.MonitoringCommunicationOptions;
import org.eclipse.fordiac.ide.monitoring.monCom.Data;
import org.eclipse.fordiac.ide.monitoring.monCom.FB;
import org.eclipse.fordiac.ide.monitoring.monCom.Port;
import org.eclipse.fordiac.ide.monitoring.monCom.Resource;
import org.eclipse.fordiac.ide.monitoring.monCom.Response;
import org.eclipse.fordiac.ide.monitoring.preferences.PreferenceConstants;
import org.xml.sax.InputSource;

public class TCPCommunicationObject {
    private final MonitorInformation monitorInformation;
    private static final int ASN1_TAG_IECSTRING = 80;
    private Socket socket = null;
    private DataOutputStream outputStream;
    private DataInputStream inputStream;
    private boolean disabled = true;
    int id = 0;
    MonitoringCommunicationOptions data = new MonitoringCommunicationOptions();

    public boolean isConnected() {
        return this.socket.isConnected() && !this.socket.isClosed();
    }

    public TCPCommunicationObject(MonitorInformation monitorInformation) {
        this.monitorInformation = monitorInformation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String sendRequest(SendType type, Device device, String request, String destination) {
        if (this.disabled) return null;
        if (this.socket == null || this.socket.isClosed() || !this.socket.isConnected()) {
            try {
                this.connect();
            }
            catch (IOException e) {
                String msg = "Can not connect to device ";
                if (device != null) {
                    msg = String.valueOf(msg) + device.getName();
                }
                msg = String.valueOf(msg) + " at ";
                msg = String.valueOf(msg) + this.monitorInformation.getInetAdress() + ":" + this.monitorInformation.port;
                msg = String.valueOf(msg) + " (" + e.getMessage() + ")";
                Activator.getDefault().logError(msg, e);
                return null;
            }
        }
        try {
            this.outputStream.writeByte(80);
            this.outputStream.writeShort(destination.length());
            this.outputStream.writeBytes(destination);
            this.outputStream.writeByte(80);
            this.outputStream.writeShort(request.length());
            this.outputStream.writeBytes(request);
            this.outputStream.flush();
            switch (type) {
                case REQ: {
                    return this.readResponse();
                }
                case addWatch: {
                    return this.readResponse();
                }
                case triggerEvent: {
                    return null;
                }
                case removeWatch: {
                    return this.readResponse();
                }
                case startEventCnt: {
                    this.readResponse();
                    return null;
                }
                case breakPoint: {
                    this.readResponse();
                    return null;
                }
            }
            return null;
        }
        catch (IOException e) {
            Activator.getDefault().logError("Communication Problem: " + e.getMessage(), e);
            try {
                this.socket.close();
                return null;
            }
            catch (IOException e1) {
                Activator.getDefault().logError("Communication Problem: " + e.getMessage(), e1);
            }
        }
        return null;
    }

    private String readResponse() throws IOException {
        this.inputStream.readByte();
        int size = this.inputStream.readShort();
        StringBuilder response = new StringBuilder(size);
        int i = 0;
        while (i < size) {
            response.append((char)this.inputStream.readByte());
            ++i;
        }
        return response.length() == 0 ? null : response.toString();
    }

    private void connect() throws IOException {
        if (this.socket == null || !this.socket.isBound() || this.socket.isClosed() || !this.socket.isConnected() || this.socket.isInputShutdown() || this.socket.isOutputShutdown()) {
            this.socket = new Socket();
            InetSocketAddress sockaddr = new InetSocketAddress(this.monitorInformation.getInetAdress(), (int)this.monitorInformation.port);
            int timeout = PreferenceConstants.getTimeOutValue();
            this.socket.connect(sockaddr, timeout);
            this.socket.setSoTimeout(timeout);
            this.outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
    }

    public void addWatch(MonitoringBaseElement element) {
        String request;
        String response;
        element.setOffline((response = this.sendRequest(SendType.addWatch, null, request = MessageFormat.format(Messages.TCPCommunicationObject_Monitoring_ADD_Watch, this.id++, element.getQualifiedString(), "*"), element.getResourceString())) == null);
    }

    public void removeWatch(MonitoringBaseElement element) {
        String request;
        String response;
        element.setOffline((response = this.sendRequest(SendType.removeWatch, null, request = MessageFormat.format(Messages.TCPCommunicationObject_Monitoring_Delete_Watch, this.id++, element.getQualifiedString(), "*"), element.getResourceString())) == null);
    }

    public void sendReq(AutomationSystem system, Device device) {
        String request;
        String response;
        if ((response = this.sendRequest(SendType.REQ, device, request = MessageFormat.format(Messages.TCPCommunicationObject_Monitoring_Read_Watches, this.id++), "")) != null) {
            this.evaluateResponse(system, device, response);
        }
    }

    public void queryBreakpoints(AutomationSystem system, Device device) {
    }

    private void evaluateBreakpointResponse(AutomationSystem system, Device device, String response) {
    }

    private void evaluateResponse(AutomationSystem system, Device device, String response) {
        try {
            XMLResourceImpl resource = new XMLResourceImpl();
            InputSource source = new InputSource(new StringReader(response));
            resource.load(source, this.data.getLoadOptions());
            for (EObject object : resource.getContents()) {
                Response resp;
                if (!(object instanceof Response) || (resp = (Response)object).getWatches() == null) continue;
                for (Resource res : resp.getWatches().getResources()) {
                    for (FB fb : res.getFbs()) {
                        for (Port p : fb.getPorts()) {
                            MonitoringBaseElement element = MonitoringManager.getInstance().getMonitoringElementByPortString(system.getName(), String.valueOf(device.getName()) + "." + res.getName() + "." + fb.getName() + "." + p.getName());
                            if (element == null || !(element instanceof MonitoringElement)) continue;
                            MonitoringElement monitoringElement = (MonitoringElement)element;
                            for (Data d : p.getDataValues()) {
                                long timeAsLong = 0L;
                                try {
                                    Long.parseLong(d.getTime());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    timeAsLong = 0L;
                                }
                                monitoringElement.setSec(timeAsLong / 1000L);
                                monitoringElement.setUsec(timeAsLong % 1000L);
                                monitoringElement.setCurrentValue(d.getValue());
                                if (d.getForced() == null) continue;
                                monitoringElement.setForce(d.getForced().equals("true"));
                            }
                        }
                    }
                }
            }
        }
        catch (WrappedException ex) {
            Activator.getDefault().logError("", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            Activator.getDefault().logError("", ex);
        }
    }

    public void disable() {
        this.disabled = true;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                Activator.getDefault().logError("Closing Socket Problem: " + e.getMessage(), e);
            }
        }
    }

    public void enable() {
        this.disabled = false;
        try {
            this.connect();
        }
        catch (IOException e) {
            Activator.getDefault().logError("Opening Socket Problem - TCPCommunicationObject:enable(): " + e.getMessage(), e);
        }
    }

    public void startEventCnt(MonitoringElement element) {
    }

    public void triggerEvent(MonitoringElement element) {
        String request = MessageFormat.format(Messages.TCPCommunicationObject_WriteParameter, this.id++, "$e", element.getQualifiedString());
        this.sendRequest(SendType.triggerEvent, null, request, element.getResourceString());
    }

    public void writeValue(MonitoringElement element, String value) {
        String request = MessageFormat.format(Messages.TCPCommunicationObject_WriteParameter, this.id++, value, element.getQualifiedString());
        this.sendRequest(SendType.triggerEvent, null, request, element.getResourceString());
    }

    public void forceValue(MonitoringElement element, String value) {
        String request = MessageFormat.format(Messages.TCPCommunicationObject_Monitoring_Force_Value, this.id++, value, element.getQualifiedString(), "true");
        this.sendRequest(SendType.forceValue, null, request, element.getResourceString());
    }

    public void clearForce(MonitoringElement element) {
        String request = MessageFormat.format(Messages.TCPCommunicationObject_Monitoring_Force_Value, this.id++, "*", element.getQualifiedString(), "false");
        this.sendRequest(SendType.forceValue, null, request, element.getResourceString());
    }

    public void toggleBreakpoint(MonitoringElement element, MonitoringManager.BreakPoint set) {
    }

    public static enum SendType {
        REQ,
        addWatch,
        removeWatch,
        triggerEvent,
        startEventCnt,
        forceValue,
        breakPoint;

    }
}

