/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.channels.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.channels.CChannel;
import org.eclipse.fordiac.ide.util.comm.channels.IIecReceivable;
import org.eclipse.fordiac.ide.util.comm.channels.tcp.TCPCommThread;
import org.eclipse.fordiac.ide.util.comm.datatypes.ASN1;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.exceptions.CommException;

public class TCPChannel
extends CChannel {
    public DataInputStream in;
    public DataOutputStream out;
    public static final int TCP_PACKET_LENGTH = 1024;
    private Socket socket;
    public TCPCommThread commThread;
    private InetAddress inetAddress;

    private TCPChannel(int packet_length, String TCP_ID, IIecReceivable receiver) throws CommException {
        this.inetAddress = TCPChannel.getInetAddress(TCP_ID);
        try {
            if (this.inetAddress.isMulticastAddress()) {
                throw new CommException("Invalid ID");
            }
            this.socket = new Socket(this.inetAddress, TCPChannel.getPort(TCP_ID));
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        }
        catch (IOException iOException) {
            throw new CommException("Socket Error");
        }
        this.commThread = new TCPCommThread(this, receiver);
        this.commThread.start();
    }

    public static CChannel register(String TCP_ID, IIecReceivable receiver) throws CommException {
        return new TCPChannel(1024, TCP_ID, receiver);
    }

    @Override
    public void deregister() throws CommException {
        this.commThread.interrupt();
        try {
            this.socket.close();
            this.commThread.join(1000L);
        }
        catch (IOException iOException) {
            throw new CommException("Invalid ID");
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public List<IEC_ANY> receiveFrom() throws IOException, CommException {
        if (this.socket == null) {
            return null;
        }
        ArrayList<IEC_ANY> list = new ArrayList<IEC_ANY>();
        if (!this.socket.isConnected()) {
            return null;
        }
        do {
            try {
                IEC_ANY decode = ASN1.decodeFrom(this.in);
                if (decode == null) break;
                list.add(decode);
            }
            catch (IOException e) {
                if (e instanceof EOFException) {
                    throw new CommException("Socket closed by server");
                }
                throw e;
            }
        } while (this.in.available() > 0);
        return list;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void send(List<IEC_ANY> Data) {
        try {
            for (IEC_ANY elem : Data) {
                if (elem != null) {
                    this.out.write(elem.encode());
                    continue;
                }
                this.out.write(5);
            }
            this.out.flush();
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }
}

