/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.channels.udp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.channels.CChannel;
import org.eclipse.fordiac.ide.util.comm.channels.IIecReceivable;
import org.eclipse.fordiac.ide.util.comm.channels.udp.UDPCommThread;
import org.eclipse.fordiac.ide.util.comm.datatypes.ASN1;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.exceptions.CommException;

public class UDPChannel
extends CChannel {
    public DataInputStream in;
    public static final int UDP_PACKET_LENGTH = 1024;
    private DatagramSocket socket;
    private byte[] bytes;
    private UDPCommThread commThread;
    private InetAddress inetAddress;

    private UDPChannel(int packet_length, String UDP_ID, IIecReceivable receiver) throws CommException {
        this.inetAddress = UDPChannel.getInetAddress(UDP_ID);
        try {
            if (this.inetAddress.isMulticastAddress()) {
                this.socket = new MulticastSocket(UDPChannel.getPort(UDP_ID));
                ((MulticastSocket)this.socket).joinGroup(this.inetAddress);
            } else {
                this.socket = new DatagramSocket(UDPChannel.getPort(UDP_ID));
            }
        }
        catch (IOException iOException) {
            throw new CommException("Invalid ID");
        }
        this.bytes = new byte[packet_length];
        this.in = new DataInputStream(new ByteArrayInputStream(this.bytes));
        this.commThread = new UDPCommThread(this, receiver);
        this.commThread.start();
    }

    public static CChannel register(String UDP_ID, IIecReceivable receiver) throws CommException {
        return new UDPChannel(1024, UDP_ID, receiver);
    }

    @Override
    public void deregister() throws CommException {
        this.commThread.interrupt();
        if (this.socket instanceof MulticastSocket) {
            try {
                ((MulticastSocket)this.socket).leaveGroup(this.inetAddress);
            }
            catch (IOException iOException) {
                throw new CommException("Invalid ID");
            }
        }
        this.socket.close();
        this.socket.disconnect();
    }

    @Override
    public List<IEC_ANY> receiveFrom() throws IOException {
        if (this.socket == null) {
            return null;
        }
        DatagramPacket packet = new DatagramPacket(this.bytes, 1024);
        packet.setLength(this.bytes.length);
        this.socket.receive(packet);
        this.in.reset();
        ArrayList<IEC_ANY> list = new ArrayList<IEC_ANY>();
        while (this.in.available() > 0) {
            IEC_ANY decode = ASN1.decodeFrom(this.in);
            if (decode == null) break;
            list.add(decode);
        }
        return list;
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public static void send(String ID, List<IEC_ANY> Data) {
        try {
            DatagramSocket myDataGramSocket = new DatagramSocket();
            InetAddress inetAddress = UDPChannel.getInetAddress(ID);
            int Port = UDPChannel.getPort(ID);
            ByteArrayOutputStream Output = new ByteArrayOutputStream();
            for (IEC_ANY elem : Data) {
                if (elem != null) {
                    Output.write(elem.encode());
                    continue;
                }
                Output.write(5);
            }
            int length = Output.size();
            if (length > 1024) {
                length = 1024;
            }
            DatagramPacket myDGP = new DatagramPacket(Output.toByteArray(), length, inetAddress, Port);
            myDataGramSocket.send(myDGP);
            myDataGramSocket.close();
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }
}

