/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_INT;
import org.eclipse.fordiac.ide.util.comm.exceptions.DataTypeValueOutOfBoundsException;

public class IEC_LINT
extends IEC_INT {
    protected static final long BOUNDS_MASK = 0L;
    protected static final long BOUNDS_MASK_32bit = -4294967296L;
    protected long value;

    public IEC_LINT() {
        this.value = 0L;
    }

    public IEC_LINT(int initial) {
        super(initial);
    }

    public IEC_LINT(long initial) {
        this.value = initial;
    }

    public IEC_LINT(DataInputStream in) {
        super(in);
    }

    @Override
    public void decodeValueFrom(DataInputStream in) {
        try {
            this.value = in.readLong();
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{69};
        return retval;
    }

    @Override
    public byte[] encodeValue() {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        DataOutputStream DOS = new DataOutputStream(myOut);
        try {
            DOS.writeLong(this.value);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return myOut.toByteArray();
    }

    @Override
    public int getValue() {
        if ((this.value & 0xFFFFFFFF00000000L) == 0L) {
            return super.getValue();
        }
        throw new DataTypeValueOutOfBoundsException("Value out of range. Use getLongValue() instead.");
    }

    public long getLongValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    protected long verifyValue(long val) {
        if (0L == 0L) {
            return val;
        }
        throw new DataTypeValueOutOfBoundsException("Data type value out of bounds.");
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_LINT)source).getValue();
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean setValue(String source) {
        try {
            this.value = this.verifyValue(Long.parseLong(source));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

