/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.ByteType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyBitValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class ByteValue
implements AnyBitValue {
    public static final ByteValue DEFAULT = new ByteValue(0);
    private final byte value;

    private ByteValue(byte value) {
        this.value = value;
    }

    public static ByteValue toByteValue(byte value) {
        return new ByteValue(value);
    }

    public static ByteValue toByteValue(Number value) {
        return new ByteValue(value.byteValue());
    }

    public static ByteValue toByteValue(String value) {
        return ByteValue.toByteValue((Number)NumericValueConverter.INSTANCE_BYTE.toValue(value));
    }

    public static ByteValue toByteValue(AnyBitValue value) {
        return ByteValue.toByteValue(value.byteValue());
    }

    public ByteType getType() {
        return IecTypes.ElementaryTypes.BYTE;
    }

    @Override
    public boolean boolValue() {
        return this.value != 0;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)Byte.toUnsignedInt(this.value);
    }

    @Override
    public int intValue() {
        return Byte.toUnsignedInt(this.value);
    }

    @Override
    public long longValue() {
        return Byte.toUnsignedLong(this.value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    public int hashCode() {
        return Byte.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteValue other = (ByteValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return NumericValueConverter.INSTANCE_BYTE.toString((Object)this.intValue());
    }
}

