/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableShortBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableShortEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableShortHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableShortSingletonBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.factory.primitive.ShortBags;

@ServiceProvider(value=ImmutableShortBagFactory.class)
public class ImmutableShortBagFactoryImpl
implements ImmutableShortBagFactory {
    public static final ImmutableShortBagFactory INSTANCE = new ImmutableShortBagFactoryImpl();

    public ImmutableShortBag empty() {
        return ImmutableShortEmptyBag.INSTANCE;
    }

    public ImmutableShortBag of() {
        return this.empty();
    }

    public ImmutableShortBag with() {
        return this.empty();
    }

    public ImmutableShortBag of(short one) {
        return this.with(one);
    }

    public ImmutableShortBag with(short one) {
        return new ImmutableShortSingletonBag(one);
    }

    public ImmutableShortBag of(short ... items) {
        return this.with(items);
    }

    public ImmutableShortBag with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableShortHashBag.newBagWith(items);
    }

    public ImmutableShortBag ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public ImmutableShortBag withAll(ShortIterable items) {
        if (items instanceof ImmutableShortBag) {
            return (ImmutableShortBag)items;
        }
        if (items == null) {
            return this.with();
        }
        ShortHashBag bag = new ShortHashBag();
        items.forEach(arg_0 -> ((MutableShortBag)bag).add(arg_0));
        if (bag.size() == 0) {
            return this.with();
        }
        if (bag.size() == 1) {
            return this.with(bag.toArray());
        }
        return ImmutableShortHashBag.newBagWith(bag);
    }

    public ImmutableShortBag ofAll(Iterable<Short> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableShortBag withAll(Iterable<Short> iterable) {
        return ShortBags.mutable.withAll(iterable).toImmutable();
    }
}

