/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.AbstractCreateElementCommand;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;

public class CreateServiceSequenceCommand
extends AbstractCreateElementCommand<ServiceSequence> {
    private final FBType fbType;
    private ServiceSequence sequence;
    private boolean emptyService;
    private static final String LEFT_INTERFACE_NAME = "external";
    private static final String RIGHT_INTERFACE_NAME = "internal_interface";
    private static final String DEFAULT_SEQUENCE_NAME = "ServiceSequence";
    private ServiceInterface leftInterface;
    private ServiceInterface rightInterface;

    public CreateServiceSequenceCommand(Service service) {
        super(service.getServiceSequence());
        this.fbType = service.getFBType();
    }

    public CreateServiceSequenceCommand(Service service, ServiceSequence refElement) {
        super(service.getServiceSequence(), refElement);
        this.fbType = service.getFBType();
    }

    @Override
    protected ServiceSequence createNewElement() {
        this.sequence = LibraryElementFactory.eINSTANCE.createServiceSequence();
        return this.sequence;
    }

    private void createEmptyServiceModel() {
        if (this.fbType.getService() == null) {
            this.emptyService = true;
            this.fbType.setService(LibraryElementFactory.eINSTANCE.createService());
        }
        if (this.fbType.getService().getLeftInterface() == null) {
            this.leftInterface = LibraryElementFactory.eINSTANCE.createServiceInterface();
            this.leftInterface.setName(LEFT_INTERFACE_NAME);
            this.fbType.getService().setLeftInterface(this.leftInterface);
        }
        if (this.fbType.getService().getRightInterface() == null) {
            this.rightInterface = LibraryElementFactory.eINSTANCE.createServiceInterface();
            this.rightInterface.setName(RIGHT_INTERFACE_NAME);
            this.fbType.getService().setRightInterface(this.rightInterface);
        }
    }

    @Override
    public void execute() {
        this.createEmptyServiceModel();
        super.execute();
        this.sequence.setName(NameRepository.createUniqueName((INamedElement)this.sequence, (String)DEFAULT_SEQUENCE_NAME));
    }

    @Override
    public void undo() {
        if (this.leftInterface != null) {
            this.fbType.getService().setLeftInterface(null);
        }
        if (this.rightInterface != null) {
            this.fbType.getService().setRightInterface(null);
        }
        if (this.emptyService) {
            this.fbType.setService(null);
        }
        super.undo();
    }

    @Override
    public void redo() {
        this.createEmptyServiceModel();
        super.redo();
    }

    public ServiceSequence getCreatedElement() {
        return this.sequence;
    }
}

