/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.UtilityMarkerHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public abstract class AbstractMarkerHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        EObject selectedElement = this.getValidSelectedElement(AbstractMarkerHandler.getSelectedElement((ISelection)selection));
        if (selectedElement != null) {
            if (this.isMarked(selectedElement)) {
                UtilityMarkerHelper.deleteElementMarker((String)this.getMarkerId(), (IResource)AbstractMarkerHandler.getRootResource(selectedElement));
            } else {
                UtilityMarkerHelper.setMarkedElement((String)this.getMarkerId(), (EObject)selectedElement);
            }
        }
        return null;
    }

    protected abstract String getMarkerId();

    protected abstract String getMarkerName();

    protected abstract EObject getValidSelectedElement(Object var1);

    public void updateElement(UIElement element, Map parameters) {
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        if (currentActiveEditor != null) {
            GraphicalViewer viewer = (GraphicalViewer)currentActiveEditor.getAdapter(GraphicalViewer.class);
            if (viewer == null || viewer.getSelectedEditParts().isEmpty()) {
                return;
            }
            EObject selectedElement = this.getValidSelectedElement(viewer.getSelectedEditParts().getFirst());
            if (selectedElement != null) {
                if (this.isMarked(selectedElement)) {
                    element.setText(MessageFormat.format(Messages.FBMarker_RemoveMarker, this.getMarkerName()));
                } else {
                    element.setText(MessageFormat.format(Messages.FBMarker_MarkAs, this.getMarkerName()));
                }
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        IEditorPart editor = (IEditorPart)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (editor != null) {
            ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
            this.setBaseEnabled(this.getValidSelectedElement(AbstractMarkerHandler.getSelectedElement(selection)) != null);
        } else {
            this.setBaseEnabled(false);
        }
    }

    private static Object getSelectedElement(ISelection selection) {
        IStructuredSelection structSel;
        return selection instanceof IStructuredSelection && !(structSel = (IStructuredSelection)selection).isEmpty() ? structSel.getFirstElement() : null;
    }

    private static IResource getRootResource(EObject target) {
        LibraryElement libEl;
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)target);
        if (rootContainer instanceof LibraryElement && (libEl = (LibraryElement)rootContainer).getTypeEntry() != null) {
            return libEl.getTypeEntry().getFile();
        }
        return null;
    }

    private boolean isMarked(EObject target) {
        EObject markedElement = UtilityMarkerHelper.getMarkedElement((String)this.getMarkerId(), (EObject)target);
        return markedElement != null && markedElement == target;
    }
}

