/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.commands.ScopedOperation;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.ui.validation.CancelableDiagnostician;
import org.eclipse.fordiac.ide.model.ui.validation.GraphicalValidationAnnotation;
import org.eclipse.fordiac.ide.model.ui.validation.VariableDiagnostician;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;

public class ValidationJob
extends UIJob {
    private static final long DELAY = 500L;
    private final Supplier<IUndoContext> undoContext;
    private final GraphicalAnnotationModel annotationModel;
    private final ValidationOperationHistoryListener listener = new ValidationOperationHistoryListener();
    private final BlockingQueue<EObject> queue = new LinkedBlockingQueue<EObject>();
    private boolean enabled = true;

    public ValidationJob(String name, Supplier<IUndoContext> undoContext, GraphicalAnnotationModel annotationModel) {
        super(MessageFormat.format(Messages.ValidationJob_ValidationJobName, name));
        this.undoContext = undoContext;
        this.annotationModel = annotationModel;
        this.listener.install();
        this.reload();
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        ArrayList queued = new ArrayList();
        this.queue.drainTo(queued);
        List filtered = EcoreUtil.filterDescendants(queued);
        try {
            VariableDiagnostician diagnostician = new VariableDiagnostician(ValidationJob.monitorFor(monitor));
            List<Diagnostic> diagnostics = filtered.stream().map(arg_0 -> ((CancelableDiagnostician)diagnostician).validate(arg_0)).toList();
            ValidationJob.runInBackground(MessageFormat.format(Messages.ValidationJob_UpdateJobName, this.getName()), pm -> this.updateAnnotations(diagnostics, pm));
        }
        catch (OperationCanceledException e) {
            this.queue.addAll(filtered);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        IProgressService progressService;
        if (PlatformUI.isWorkbenchRunning() && (progressService = PlatformUI.getWorkbench().getProgressService()) instanceof ProgressProvider) {
            ProgressProvider progressProvider = (ProgressProvider)progressService;
            return progressProvider.monitorFor(monitor);
        }
        return IProgressMonitor.nullSafe((IProgressMonitor)monitor);
    }

    protected static void runInBackground(String name, ICoreRunnable runnable) {
        Job job = Job.create((String)name, (ICoreRunnable)runnable);
        job.setPriority(50);
        job.schedule();
    }

    protected void updateAnnotations(List<Diagnostic> diagnostics, IProgressMonitor monitor) {
        Set add = diagnostics.stream().map(Diagnostic::getChildren).flatMap(Collection::stream).map(GraphicalValidationAnnotation::forDiagnostic).flatMap(Optional::stream).collect(Collectors.toSet());
        Set remove = StreamSupport.stream(Spliterators.spliteratorUnknownSize(EcoreUtil.getAllContents(diagnostics.stream().map(FordiacMarkerHelper::getDiagnosticTarget).toList(), (boolean)true), 0), false).map(this.annotationModel::getAnnotations).flatMap(Collection::stream).filter(ValidationJob::isValidationAnnotation).filter(Predicate.not(add::contains)).collect(Collectors.toSet());
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.annotationModel.updateAnnotations(add, remove, Collections.emptySet());
    }

    protected static boolean isValidationAnnotation(GraphicalAnnotation annotation) {
        return "org.eclipse.fordiac.ide.model.ui.annotation.error".equals(annotation.getType()) || "org.eclipse.fordiac.ide.model.ui.annotation.warning".equals(annotation.getType()) || "org.eclipse.fordiac.ide.model.ui.annotation.info".equals(annotation.getType());
    }

    protected void elementsChanged(Collection<? extends EObject> elements) {
        if (this.enabled) {
            this.queue.addAll(elements);
            this.cancel();
            this.schedule(500L);
        }
    }

    protected void handleOperation(IUndoableOperation operation) {
        if (operation instanceof ScopedOperation) {
            ScopedOperation scopedOperation = (ScopedOperation)operation;
            this.elementsChanged(scopedOperation.getAffectedObjects());
        }
    }

    public void clear() {
        this.queue.clear();
        this.cancel();
    }

    public void reset() {
        this.clear();
        ValidationJob.runInBackground(MessageFormat.format(Messages.ValidationJob_RefreshJobName, this.getName()), unused -> this.annotationModel.refresh());
    }

    public void reload() {
        this.clear();
        ValidationJob.runInBackground(MessageFormat.format(Messages.ValidationJob_ReloadJobName, this.getName()), unused -> this.annotationModel.reload());
    }

    public void dispose() {
        this.listener.uninstall();
        this.setEnabled(false);
        this.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected class ValidationOperationHistoryListener
    implements IOperationHistoryListener {
        protected ValidationOperationHistoryListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            if (!event.getOperation().hasContext(ValidationJob.this.undoContext.get())) {
                return;
            }
            switch (event.getEventType()) {
                case 4: 
                case 9: 
                case 10: {
                    ValidationJob.this.handleOperation(event.getOperation());
                    break;
                }
            }
        }

        public void install() {
            OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
        }

        public void uninstall() {
            OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this);
        }
    }
}

