/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.wrapping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.wrapping.BreakingPointInserter;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class BreakingPointRemover
implements ILayoutProcessor<LGraph> {
    private EdgeRouting edgeRouting;

    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Breaking Point Removing", 1.0f);
        this.edgeRouting = (EdgeRouting)graph.getProperty(LayeredOptions.EDGE_ROUTING);
        for (Layer l : graph.getLayers()) {
            for (LNode node : Lists.newArrayList(l.getNodes())) {
                if (!BreakingPointInserter.BPInfo.isEnd(node)) continue;
                BreakingPointInserter.BPInfo bpi = (BreakingPointInserter.BPInfo)node.getProperty(InternalProperties.BREAKING_POINT_INFO);
                if (bpi.next != null) continue;
                this.remove(graph, bpi);
            }
        }
        progressMonitor.done();
    }

    private void remove(LGraph graph, BreakingPointInserter.BPInfo bpi) {
        KVectorChain newBends = new KVectorChain();
        switch (this.edgeRouting) {
            case SPLINES: {
                List s1 = (List)bpi.nodeStartEdge.getProperty(InternalProperties.SPLINE_ROUTE_START);
                List s2 = (List)bpi.startEndEdge.getProperty(InternalProperties.SPLINE_ROUTE_START);
                List s3 = (List)bpi.originalEdge.getProperty(InternalProperties.SPLINE_ROUTE_START);
                List e1 = (List)bpi.nodeStartEdge.getProperty(InternalProperties.SPLINE_EDGE_CHAIN);
                List e2 = (List)bpi.startEndEdge.getProperty(InternalProperties.SPLINE_EDGE_CHAIN);
                List e3 = (List)bpi.originalEdge.getProperty(InternalProperties.SPLINE_EDGE_CHAIN);
                ArrayList joinedSegments = Lists.newArrayList();
                joinedSegments.addAll(s1);
                s2.forEach(s -> {
                    boolean bl = s.inverseOrder = true;
                });
                joinedSegments.addAll(Lists.reverse((List)s2));
                joinedSegments.addAll(s3);
                ArrayList joinedEdges = Lists.newArrayList();
                joinedEdges.addAll(e1);
                joinedEdges.addAll(Lists.reverse((List)e2));
                joinedEdges.addAll(e3);
                bpi.originalEdge.setProperty(InternalProperties.SPLINE_ROUTE_START, joinedSegments);
                bpi.originalEdge.setProperty(InternalProperties.SPLINE_EDGE_CHAIN, joinedEdges);
                bpi.originalEdge.setProperty(InternalProperties.SPLINE_SURVIVING_EDGE, (Object)bpi.originalEdge);
                bpi.nodeStartEdge.setProperty(InternalProperties.SPLINE_ROUTE_START, null);
                bpi.nodeStartEdge.setProperty(InternalProperties.SPLINE_EDGE_CHAIN, null);
                bpi.startEndEdge.setProperty(InternalProperties.SPLINE_ROUTE_START, null);
                bpi.startEndEdge.setProperty(InternalProperties.SPLINE_EDGE_CHAIN, null);
                break;
            }
            case POLYLINE: {
                newBends.addAll((Collection)bpi.nodeStartEdge.getBendPoints());
                newBends.add((Object)bpi.start.getPosition());
                newBends.addAll((Collection)Lists.reverse((List)bpi.startEndEdge.getBendPoints()));
                newBends.add((Object)bpi.end.getPosition());
                newBends.addAll((Collection)bpi.originalEdge.getBendPoints());
                break;
            }
            default: {
                newBends.addAll((Collection)bpi.nodeStartEdge.getBendPoints());
                newBends.addAll((Collection)Lists.reverse((List)bpi.startEndEdge.getBendPoints()));
                newBends.addAll((Collection)bpi.originalEdge.getBendPoints());
            }
        }
        bpi.originalEdge.getBendPoints().clear();
        bpi.originalEdge.getBendPoints().addAll((Collection)newBends);
        bpi.originalEdge.setSource(bpi.nodeStartEdge.getSource());
        KVectorChain junctionPointsOne = (KVectorChain)bpi.nodeStartEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
        KVectorChain junctionPointsTwo = (KVectorChain)bpi.startEndEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
        KVectorChain junctionPointsThree = (KVectorChain)bpi.originalEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
        if (junctionPointsOne != null || junctionPointsTwo != null || junctionPointsThree != null) {
            KVectorChain newJunctionPoints = new KVectorChain();
            this.addNullSafe((Collection)newJunctionPoints, (Collection)junctionPointsThree);
            this.addNullSafe((Collection)newJunctionPoints, (Collection)junctionPointsTwo);
            this.addNullSafe((Collection)newJunctionPoints, (Collection)junctionPointsOne);
            bpi.originalEdge.setProperty(LayeredOptions.JUNCTION_POINTS, newJunctionPoints);
        }
        bpi.startEndEdge.setSource(null);
        bpi.startEndEdge.setTarget(null);
        bpi.nodeStartEdge.setSource(null);
        bpi.nodeStartEdge.setTarget(null);
        bpi.end.setLayer(null);
        bpi.start.setLayer(null);
        if (bpi.prev != null) {
            this.remove(graph, bpi.prev);
        }
    }

    private <T> boolean addNullSafe(Collection<T> container, Collection<T> toAdd) {
        if (container == null || toAdd == null) {
            return false;
        }
        return container.addAll(toAdd);
    }
}

