/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.action;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragModeWithKeySupport;
import org.eclipse.nebula.widgets.nattable.ui.mode.AbstractModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.mode.Mode;
import org.eclipse.nebula.widgets.nattable.ui.mode.ModeSupport;
import org.eclipse.nebula.widgets.nattable.ui.mode.MouseModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.util.MouseEventHelper;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class DragModeEventHandler
extends AbstractModeEventHandler {
    private final IDragMode dragMode;
    private final MouseModeEventHandler parentModeEventHandler;
    private final MouseEvent mouseDownEvent;
    private boolean realDrag = false;
    private AtomicBoolean mouseUpHandled = new AtomicBoolean(false);

    public DragModeEventHandler(ModeSupport modeSupport, NatTable natTable, IDragMode dragMode, MouseModeEventHandler parentModeEventHandler, MouseEvent mouseDownEvent) {
        super(modeSupport, natTable);
        this.dragMode = dragMode;
        this.parentModeEventHandler = parentModeEventHandler;
        this.mouseDownEvent = mouseDownEvent;
    }

    @Override
    public void mouseMove(MouseEvent event) {
        this.dragMode.mouseMove(this.natTable, event);
        if (!this.realDrag && !MouseEventHelper.treatAsClick(this.mouseDownEvent, event)) {
            this.realDrag = true;
        }
    }

    @Override
    public void mouseUp(MouseEvent event) {
        if (this.mouseUpHandled.compareAndSet(false, true)) {
            this.dragMode.mouseUp(this.natTable, event);
            if (!this.realDrag && MouseEventHelper.eventOnSameCell(this.natTable, this.mouseDownEvent, event)) {
                this.parentModeEventHandler.mouseUp(event);
                this.switchMode(this.parentModeEventHandler);
            } else {
                this.switchMode(Mode.NORMAL_MODE);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.mouseUp(this.mouseDownEvent);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.keyCode == 27) {
            this.mouseUp(this.mouseDownEvent);
        } else if (this.dragMode instanceof IDragModeWithKeySupport) {
            ((IDragModeWithKeySupport)this.dragMode).keyPressed(this.natTable, event);
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
        if (this.dragMode instanceof IDragModeWithKeySupport) {
            ((IDragModeWithKeySupport)this.dragMode).keyReleased(this.natTable, event);
        }
    }
}

