/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration;

import java.util.Iterator;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.description.DAnnotationEntry;
import org.osgi.framework.Version;

public class RemoveOldMigrationAnnotations
extends AbstractRepresentationsFileMigrationParticipant {
    private static final Version MIGRATION_VERSION = new Version("6.5.0.201210011230");

    @Override
    public void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        super.postLoad(dAnalysis, loadedVersion);
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            this.deleteOldMigrationAnnotations(dAnalysis);
        }
    }

    private void deleteOldMigrationAnnotations(DAnalysis dAnalysis) {
        Iterator iterator = dAnalysis.getEAnnotations().iterator();
        while (iterator.hasNext()) {
            DAnnotationEntry entry = (DAnnotationEntry)iterator.next();
            if (!entry.getSource().equals("Migration")) continue;
            iterator.remove();
        }
    }

    @Override
    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }
}

