/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppCrossingConnectionsCommand;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.UtilityMarkerHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class InsertFBIntoExecutionChainCommand
extends Command
implements ScopedCommand {
    private final SubApp subApp;
    private final FB insertedFB;
    private final CompoundCommand commands = new CompoundCommand();

    public InsertFBIntoExecutionChainCommand(SubApp subApp, FB insertedFB) {
        this.subApp = subApp;
        this.insertedFB = insertedFB;
    }

    public boolean canExecute() {
        return this.subApp != null && this.insertedFB != null;
    }

    public void execute() {
        IInterfaceElement eventOutput;
        if (this.insertedFB.getInterface() == null || this.insertedFB.getInterface().getEventInputs().isEmpty() || this.insertedFB.getInterface().getEventOutputs().isEmpty()) {
            return;
        }
        BlockFBNetworkElement predecessor = InsertFBIntoExecutionChainCommand.getValidActivePredecessor(this.subApp);
        IInterfaceElement iInterfaceElement = eventOutput = predecessor != null ? InsertFBIntoExecutionChainCommand.getPredecessorEventOutput(predecessor) : this.getExecutionChainEnd();
        if (!InsertFBIntoExecutionChainCommand.hasOutputConnections(eventOutput)) {
            return;
        }
        IInterfaceElement eventOutputDestination = ((Connection)eventOutput.getOutputConnections().getFirst()).getDestination();
        IInterfaceElement inputInsertedFB = InsertFBIntoExecutionChainCommand.getMatchingEventPin((EList<Event>)this.insertedFB.getInterface().getEventInputs(), eventOutput.getType());
        IInterfaceElement outputInsertedFB = InsertFBIntoExecutionChainCommand.getMatchingEventPin((EList<Event>)this.insertedFB.getInterface().getEventOutputs(), eventOutputDestination.getType());
        this.commands.add(InsertFBIntoExecutionChainCommand.getCreateConnectionCommand(this.insertedFB.getFbNetwork(), eventOutput, inputInsertedFB));
        this.commands.add(InsertFBIntoExecutionChainCommand.getCreateConnectionCommand(this.insertedFB.getFbNetwork(), outputInsertedFB, eventOutputDestination));
        this.commands.add((Command)new DeleteConnectionCommand((Connection)eventOutput.getOutputConnections().getFirst()));
        if (predecessor != null) {
            this.commands.add((Command)new SetPredecessorCommand((BlockFBNetworkElement)this.insertedFB));
        }
        if (this.commands.canExecute()) {
            this.commands.execute();
        }
    }

    public void undo() {
        this.commands.undo();
    }

    public void redo() {
        this.commands.redo();
    }

    public Set<EObject> getAffectedObjects() {
        return this.commands.getCommands().stream().filter(ScopedCommand.class::isInstance).map(obj -> ((ScopedCommand)obj).getAffectedObjects()).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    private static IInterfaceElement getMatchingEventPin(EList<Event> pins, DataType type) {
        return (IInterfaceElement)pins.stream().filter(event -> event.getType().equals(type)).findFirst().orElse((Event)pins.getFirst());
    }

    private static boolean hasOutputConnections(IInterfaceElement output) {
        return output != null && !output.getOutputConnections().isEmpty();
    }

    private static Command getCreateConnectionCommand(FBNetwork network, IInterfaceElement source, IInterfaceElement target) {
        if (source.getBlockFBNetworkElement().getFbNetwork() != target.getBlockFBNetworkElement().getFbNetwork()) {
            return CreateSubAppCrossingConnectionsCommand.createProcessBorderCrossingConnection(source, target);
        }
        AbstractConnectionCreateCommand createConnectionCommand = AbstractConnectionCreateCommand.createCommand((FBNetwork)network, (IInterfaceElement)source, (IInterfaceElement)target);
        createConnectionCommand.setSource(source);
        createConnectionCommand.setDestination(target);
        return createConnectionCommand;
    }

    private static BlockFBNetworkElement getValidActivePredecessor(SubApp subApp) {
        BlockFBNetworkElement block;
        EObject eObject = UtilityMarkerHelper.getMarkedElement((String)"org.eclipse.fordiac.ide.model.ui.predecessor", (EObject)subApp);
        if (eObject instanceof BlockFBNetworkElement && InsertFBIntoExecutionChainCommand.isContainedInSubappNetwork(block = (BlockFBNetworkElement)eObject, subApp)) {
            return block;
        }
        return null;
    }

    private static IInterfaceElement getPredecessorEventOutput(BlockFBNetworkElement predecessor) {
        if (!predecessor.getInterface().getEventOutputs().isEmpty()) {
            return predecessor.getInterface().getEventOutputs().stream().filter(oe -> !oe.getOutputConnections().isEmpty()).findFirst().orElse(null);
        }
        return null;
    }

    private static boolean isContainedInSubappNetwork(BlockFBNetworkElement elem, SubApp sa) {
        return sa.getSubAppNetwork() == elem.getFbNetwork();
    }

    private IInterfaceElement getExecutionChainEnd() {
        Optional<IInterfaceElement> saEventOutput = this.subApp.getInterface().getAllOutputs().filter(ie -> !ie.getInputConnections().isEmpty()).findFirst();
        if (saEventOutput.isPresent() && !saEventOutput.get().getInputConnections().isEmpty()) {
            return ((Connection)saEventOutput.get().getInputConnections().getFirst()).getSource();
        }
        return null;
    }

    public class SetPredecessorCommand
    extends Command {
        private final BlockFBNetworkElement predecessor;
        private BlockFBNetworkElement oldPredecessor;
        private final IResource resource;

        public SetPredecessorCommand(BlockFBNetworkElement predecessor) {
            this.predecessor = predecessor;
            this.resource = SetPredecessorCommand.getResource(predecessor);
        }

        public boolean canExecute() {
            return this.resource != null && this.predecessor != null;
        }

        public void execute() {
            EObject eObject = UtilityMarkerHelper.getMarkedElement((String)"org.eclipse.fordiac.ide.model.ui.predecessor", (EObject)this.predecessor);
            if (eObject instanceof BlockFBNetworkElement) {
                BlockFBNetworkElement elem;
                this.oldPredecessor = elem = (BlockFBNetworkElement)eObject;
                this.setMarkedElement(this.predecessor);
            }
        }

        public void undo() {
            if (this.oldPredecessor != null) {
                this.setMarkedElement(this.oldPredecessor);
            } else {
                UtilityMarkerHelper.deleteElementMarker((String)"org.eclipse.fordiac.ide.model.ui.predecessor", (IResource)this.resource);
            }
        }

        public void redo() {
            this.setMarkedElement(this.predecessor);
        }

        private void setMarkedElement(BlockFBNetworkElement element) {
            UtilityMarkerHelper.setMarkedElement((String)"org.eclipse.fordiac.ide.model.ui.predecessor", (EObject)element);
        }

        private static IResource getResource(BlockFBNetworkElement predecessor) {
            LibraryElement libEl;
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)predecessor);
            if (rootContainer instanceof LibraryElement && (libEl = (LibraryElement)rootContainer).getTypeEntry() != null) {
                return libEl.getTypeEntry().getFile();
            }
            return null;
        }
    }
}

