/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppInterfaceElementCommand;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.policies.ContainerContentLayoutPolicy;
import org.eclipse.fordiac.ide.application.policies.FBNetworkXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeContainerBoundsCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public final class ResizingSubappInterfaceCreationCommand
extends CreationCommand {
    private final CreateSubAppInterfaceElementCommand ieCreationCmd;
    private final SubAppForFBNetworkEditPart subAppEP;
    private final ResizeGroupOrSubappCommand resizingCmd;
    private AbstractChangeContainerBoundsCommand changeSubappHeightCmd;

    public static CreationCommand wrapCreateCommand(CreateSubAppInterfaceElementCommand cmd, SubApp parent) {
        if (parent.isUnfolded()) {
            SubAppForFBNetworkEditPart subappEP = ResizingSubappInterfaceCreationCommand.findSubappEP(parent);
            if (subappEP != null) {
                return new ResizingSubappInterfaceCreationCommand(cmd, subappEP);
            }
        } else if (parent.isInGroup()) {
            GraphicalEditPart groupEP = ResizingSubappInterfaceCreationCommand.findEditPart(parent.getGroup());
            if (groupEP != null) {
                return new WrapedResizeGroupOrSubappCommand(groupEP, cmd);
            }
        } else {
            GraphicalEditPart ep;
            SubApp subApp;
            FBNetworkElement fBNetworkElement = parent.getOuterFBNetworkElement();
            if (fBNetworkElement instanceof SubApp && (subApp = (SubApp)fBNetworkElement).isUnfolded() && (ep = ResizingSubappInterfaceCreationCommand.findEditPart(parent.getOuterFBNetworkElement())) != null) {
                return new WrapedResizeGroupOrSubappCommand(ep, cmd);
            }
        }
        return cmd;
    }

    private ResizingSubappInterfaceCreationCommand(CreateSubAppInterfaceElementCommand cmd, SubAppForFBNetworkEditPart subAppEP) {
        this.ieCreationCmd = cmd;
        this.subAppEP = subAppEP;
        this.resizingCmd = new ResizeGroupOrSubappCommand(subAppEP);
    }

    public void execute() {
        this.ieCreationCmd.execute();
        this.getViewer().flush();
        this.checkSubappHeight();
        this.resizingCmd.execute();
    }

    public void undo() {
        this.resizingCmd.undo();
        if (this.changeSubappHeightCmd != null) {
            this.changeSubappHeightCmd.undo();
        }
        this.ieCreationCmd.undo();
    }

    public void redo() {
        this.ieCreationCmd.redo();
        if (this.changeSubappHeightCmd != null) {
            this.changeSubappHeightCmd.redo();
        }
        this.resizingCmd.redo();
    }

    public Object getCreatedElement() {
        return this.ieCreationCmd.getCreatedElement();
    }

    private EditPartViewer getViewer() {
        return this.subAppEP.getViewer();
    }

    private static GraphicalEditPart findEditPart(Object obj) {
        EditPart editPart;
        GraphicalViewer viewer;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && (viewer = HandlerHelper.getViewer((IEditorPart)editor)) != null && (editPart = viewer.getEditPartForModel(obj)) instanceof GraphicalEditPart) {
            GraphicalEditPart gep = (GraphicalEditPart)editPart;
            return gep;
        }
        return null;
    }

    private static SubAppForFBNetworkEditPart findSubappEP(SubApp parent) {
        GraphicalEditPart ep = ResizingSubappInterfaceCreationCommand.findEditPart(parent);
        if (ep instanceof SubAppForFBNetworkEditPart) {
            SubAppForFBNetworkEditPart subAppEP = (SubAppForFBNetworkEditPart)ep;
            return subAppEP;
        }
        return null;
    }

    private void checkSubappHeight() {
        int expandedIOHeight = this.subAppEP.getFigure().getExpandedIOHeight();
        Rectangle containerBounds = ContainerContentLayoutPolicy.getContainerAreaBounds(this.subAppEP.getContentEP());
        if (containerBounds.height < expandedIOHeight) {
            containerBounds.height = expandedIOHeight;
            this.changeSubappHeightCmd = FBNetworkXYLayoutEditPolicy.createChangeBoundsCommand((FBNetworkElement)this.subAppEP.getModel(), containerBounds);
            this.changeSubappHeightCmd.execute();
        }
    }

    private static final class WrapedResizeGroupOrSubappCommand
    extends CreationCommand {
        private final ResizeGroupOrSubappCommand resizeCmd;
        private final CreateSubAppInterfaceElementCommand cmd;

        private WrapedResizeGroupOrSubappCommand(GraphicalEditPart groupEP, CreateSubAppInterfaceElementCommand cmd) {
            this.resizeCmd = new ResizeGroupOrSubappCommand(groupEP, (Command)cmd);
            this.cmd = cmd;
        }

        public boolean canExecute() {
            return this.resizeCmd.canExecute();
        }

        public boolean canUndo() {
            return this.resizeCmd.canUndo();
        }

        public boolean canRedo() {
            return this.resizeCmd.canRedo();
        }

        public void execute() {
            this.resizeCmd.execute();
        }

        public void undo() {
            this.resizeCmd.undo();
        }

        public void redo() {
            this.resizeCmd.redo();
        }

        public Object getCreatedElement() {
            return this.cmd.getCreatedElement();
        }
    }
}

