/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.MoveAndReconnectCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class MoveToParentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        List fbelements;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor != null && !(fbelements = HandlerHelper.getSelectedFBNElements((ISelection)(selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)))).isEmpty()) {
            Rectangle bounds = MoveToParentHandler.getParentSubappBounds(editor, fbelements);
            int destX = bounds.x;
            int destY = bounds.y + bounds.height + 20;
            MoveAndReconnectCommand cmd = new MoveAndReconnectCommand(fbelements, new Point(destX, destY));
            HandlerHelper.getCommandStack((IEditorPart)editor).execute((Command)cmd);
            MoveToParentHandler.selectElements(fbelements);
        }
        return Status.OK_STATUS;
    }

    private static void selectElements(List<FBNetworkElement> fbelements) {
        INamedElement viewableNetwork = MoveToParentHandler.findNextViewableNetwork(fbelements.get(0));
        GraphicalViewer viewer = (GraphicalViewer)HandlerHelper.openEditor((EObject)viewableNetwork).getAdapter(GraphicalViewer.class);
        HandlerHelper.selectElement((Object)fbelements.get(0), (GraphicalViewer)viewer);
    }

    private static Rectangle getParentSubappBounds(IEditorPart editor, List<FBNetworkElement> fbelements) {
        FBNetwork subappNetwork = MoveToParentHandler.getParentOfParent(fbelements.get(0));
        GraphicalViewer viewer = MoveToParentHandler.getViewer(subappNetwork, editor);
        viewer.flush();
        GraphicalEditPart ep = (GraphicalEditPart)viewer.getEditPartForModel((Object)fbelements.get(0).getFbNetwork().eContainer());
        return ep.getFigure().getBounds();
    }

    private static GraphicalViewer getViewer(FBNetwork subappNetwork, IEditorPart parent) {
        if (!HandlerHelper.getFBNetwork((IEditorPart)parent).equals(subappNetwork)) {
            return HandlerHelper.getViewer((IEditorPart)HandlerHelper.openEditor((EObject)subappNetwork.eContainer()));
        }
        return HandlerHelper.getViewer((IEditorPart)parent);
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        List fbElements = HandlerHelper.getSelectedFBNElements((ISelection)selection);
        if (!fbElements.isEmpty() && ((FBNetworkElement)fbElements.get(0)).getFbNetwork().eContainer() instanceof SubApp) {
            FBNetwork parent = ((FBNetworkElement)fbElements.get(0)).getFbNetwork();
            boolean sameParentNetwork = fbElements.stream().allMatch(el -> parent.equals(el.getFbNetwork()));
            this.setBaseEnabled(sameParentNetwork);
            return;
        }
        this.setBaseEnabled(false);
    }

    private static FBNetwork getParentOfParent(FBNetworkElement fbNetworkElement) {
        return (FBNetwork)fbNetworkElement.getFbNetwork().eContainer().eContainer();
    }

    private static INamedElement findNextViewableNetwork(FBNetworkElement fbelement) {
        if (fbelement.getFbNetwork().isApplicationNetwork()) {
            return (Application)fbelement.getFbNetwork().eContainer();
        }
        if (fbelement.getFbNetwork().isSubApplicationNetwork()) {
            SubApp subapp;
            EObject eObject = fbelement.getFbNetwork().eContainer();
            if (eObject instanceof SubApp && (subapp = (SubApp)eObject).isUnfolded()) {
                return MoveToParentHandler.findNextViewableNetwork((FBNetworkElement)fbelement.getFbNetwork().eContainer());
            }
            return (FBNetworkElement)fbelement.getFbNetwork().eContainer();
        }
        return null;
    }
}

