/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.editparts.AbstractContainerContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.IContainerEditPart;
import org.eclipse.fordiac.ide.application.editparts.UntypedSubAppInterfaceElementEditPart;
import org.eclipse.fordiac.ide.application.policies.FBNetworkXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeContainerBoundsCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class TrimHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GraphicalEditPart contentEP;
        IContainerEditPart containerEditPart = TrimHandler.getContainerEditPart(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (containerEditPart != null && editor != null && (contentEP = containerEditPart.getContentEP()) != null) {
            Rectangle groupContentBounds = containerEditPart.getMinContentBounds();
            int adjustedCommentWidth = TrimHandler.adjustCommentWidth(containerEditPart.getCommentWidth(), containerEditPart.getChildren());
            groupContentBounds.setWidth(Math.max(groupContentBounds.width, adjustedCommentWidth));
            AbstractChangeContainerBoundsCommand cmd = FBNetworkXYLayoutEditPolicy.createChangeBoundsCommand((FBNetworkElement)containerEditPart.getModel(), groupContentBounds);
            HandlerHelper.getCommandStack((IEditorPart)editor).execute((Command)cmd);
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(TrimHandler.getContainerEditPart(selection) != null);
    }

    private static IContainerEditPart getContainerEditPart(ISelection selection) {
        IStructuredSelection structSel;
        if (selection instanceof IStructuredSelection && (structSel = (IStructuredSelection)selection).size() == 1) {
            Object firstElement = structSel.getFirstElement();
            if (firstElement instanceof IContainerEditPart) {
                IContainerEditPart containerEP = (IContainerEditPart)firstElement;
                if (!(containerEP.getModel() instanceof SubApp)) {
                    return containerEP;
                }
                if (((SubApp)containerEP.getModel()).isUnfolded()) {
                    return containerEP;
                }
            }
            if (firstElement instanceof AbstractContainerContentEditPart) {
                return (IContainerEditPart)((EditPart)firstElement).getParent();
            }
        }
        return null;
    }

    private static int adjustCommentWidth(int commentWidth, List<? extends EditPart> children) {
        int widestInput = children.stream().filter(Objects::nonNull).filter(UntypedSubAppInterfaceElementEditPart.class::isInstance).map(UntypedSubAppInterfaceElementEditPart.class::cast).filter(InterfaceEditPart::isInput).map(GraphicalEditPart.class::cast).mapToInt(e -> e.getFigure().getBounds().width()).max().orElse(0);
        int widestOutput = children.stream().filter(Objects::nonNull).filter(UntypedSubAppInterfaceElementEditPart.class::isInstance).map(UntypedSubAppInterfaceElementEditPart.class::cast).filter(Predicate.not(InterfaceEditPart::isInput)).map(GraphicalEditPart.class::cast).mapToInt(e -> e.getFigure().getBounds().width()).max().orElse(0);
        return commentWidth - widestInput - widestOutput;
    }
}

