/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.marker.resolution;

import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.application.marker.resolution.AbstractCommandMarkerResolution;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.change.ConfigureFBCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;

public class BestFitDataTypeMarkerResolution
extends AbstractCommandMarkerResolution<ITypedElement> {
    private final DataType selectedType;

    public BestFitDataTypeMarkerResolution(IMarker marker, DataType type) {
        super(marker, ITypedElement.class);
        this.selectedType = type;
    }

    @Override
    protected boolean prepare(IMarker[] markers, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    @Override
    protected Command createCommand(ITypedElement element, IProgressMonitor monitor) throws CoreException {
        ConfigureFBCommand configureFBCommand;
        ITypedElement iTypedElement;
        ITypedElement iTypedElement2 = element;
        Objects.requireNonNull(iTypedElement2);
        ITypedElement iTypedElement3 = iTypedElement = iTypedElement2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IInterfaceElement.class, StructManipulator.class, ConfigurableFB.class}, (Object)iTypedElement3, n)) {
                case 0: {
                    IInterfaceElement interfaceElement = (IInterfaceElement)iTypedElement;
                    configureFBCommand = ChangeDataTypeCommand.forDataType((IInterfaceElement)interfaceElement, (DataType)this.selectedType);
                    break block5;
                }
                case 1: {
                    StructManipulator fb = (StructManipulator)iTypedElement;
                    if (!(this.selectedType instanceof StructuredType)) {
                        iTypedElement3 = iTypedElement;
                        n = 2;
                        continue block5;
                    }
                    configureFBCommand = new ChangeStructCommand(fb, this.selectedType);
                    break block5;
                }
                case 2: {
                    ConfigurableFB fb = (ConfigurableFB)iTypedElement;
                    configureFBCommand = new ConfigureFBCommand(fb, this.selectedType);
                    break block5;
                }
                default: {
                    configureFBCommand = null;
                }
            }
            break;
        }
        return configureFBCommand;
    }

    @Override
    protected boolean isApplicable(IMarker other) {
        int code = FordiacErrorMarker.getCode((IMarker)other);
        return (code == 27 || code == 4) && Arrays.equals(FordiacErrorMarker.getData((IMarker)other), FordiacErrorMarker.getData((IMarker)this.getMarker()));
    }

    public String getDescription() {
        return MessageFormat.format(FordiacMessages.Repair_Dialog_BestFitDataType, this.selectedType.getTypeEntry().getFullTypeName());
    }

    public String getLabel() {
        return MessageFormat.format(FordiacMessages.Repair_Dialog_BestFitDataType, this.selectedType.getTypeEntry().getFullTypeName());
    }

    public Image getImage() {
        return null;
    }

    public static Stream<BestFitDataTypeMarkerResolution> createResolutions(IMarker marker) {
        String typeName = FordiacErrorMarker.getData((IMarker)marker)[0];
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(marker.getResource().getProject());
        return typeLibrary.findUnqualified(typeName).stream().map(TypeEntry::getType).filter(DataType.class::isInstance).map(DataType.class::cast).map(type -> new BestFitDataTypeMarkerResolution(marker, (DataType)type));
    }
}

