/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.marker.resolution;

import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.application.marker.resolution.AbstractCommandMarkerResolution;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.change.ConfigureFBCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.typemanagement.util.TypeFromTemplateCreator;
import org.eclipse.fordiac.ide.typemanagement.wizards.NewTypeWizard;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;

public class CreateDataTypeMarkerResolution
extends AbstractCommandMarkerResolution<ITypedElement> {
    private static final String TEMPLATE_PATH = Platform.getInstallLocation().getURL().getFile() + File.separatorChar + "template" + File.separatorChar + "Struct.dtp";
    private DataTypeEntry newEntry;

    public CreateDataTypeMarkerResolution(IMarker marker) {
        super(marker, ITypedElement.class);
    }

    @Override
    protected boolean prepare(IMarker[] markers, IProgressMonitor monitor) throws CoreException {
        File template = new File(TEMPLATE_PATH);
        String typeName = FordiacErrorMarker.getData((IMarker)markers[0])[0];
        IFile targetFile = CreateDataTypeMarkerResolution.getTargetFile(typeName, markers[0].getResource().getProject());
        TypeFromTemplateCreator creator = new TypeFromTemplateCreator(targetFile, template, PackageNameHelper.extractPackageName((String)typeName));
        creator.createTypeFromTemplate((IProgressMonitor)new NullProgressMonitor());
        NewTypeWizard.openTypeEditor((IFile)targetFile);
        this.newEntry = (DataTypeEntry)creator.getTypeEntry();
        return this.newEntry != null;
    }

    private static IFile getTargetFile(String typeName, IProject project) {
        return project.getFile(Path.fromOSString((String)"Type Library").append(typeName.replace("::", String.valueOf('/'))).addFileExtension("DTP"));
    }

    @Override
    protected Command createCommand(ITypedElement element, IProgressMonitor monitor) throws CoreException {
        ConfigureFBCommand configureFBCommand;
        ITypedElement iTypedElement;
        ITypedElement iTypedElement2 = element;
        Objects.requireNonNull(iTypedElement2);
        ITypedElement iTypedElement3 = iTypedElement = iTypedElement2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IInterfaceElement.class, StructManipulator.class, ConfigurableFB.class}, (Object)iTypedElement3, n)) {
                case 0: {
                    IInterfaceElement interfaceElement = (IInterfaceElement)iTypedElement;
                    configureFBCommand = ChangeDataTypeCommand.forDataType((IInterfaceElement)interfaceElement, (DataType)this.newEntry.getType());
                    break block5;
                }
                case 1: {
                    StructManipulator fb = (StructManipulator)iTypedElement;
                    if (!(this.newEntry.getType() instanceof StructuredType)) {
                        iTypedElement3 = iTypedElement;
                        n = 2;
                        continue block5;
                    }
                    configureFBCommand = new ChangeStructCommand(fb, (DataType)this.newEntry.getType());
                    break block5;
                }
                case 2: {
                    ConfigurableFB fb = (ConfigurableFB)iTypedElement;
                    configureFBCommand = new ConfigureFBCommand(fb, (DataType)this.newEntry.getType());
                    break block5;
                }
                default: {
                    configureFBCommand = null;
                }
            }
            break;
        }
        return configureFBCommand;
    }

    @Override
    protected boolean isApplicable(IMarker other) {
        int code = FordiacErrorMarker.getCode((IMarker)other);
        return (code == 27 || code == 4) && Arrays.equals(FordiacErrorMarker.getData((IMarker)other), FordiacErrorMarker.getData((IMarker)this.getMarker()));
    }

    public String getLabel() {
        return FordiacMessages.Repair_Dialog_New_DataType;
    }

    public String getDescription() {
        return FordiacMessages.Repair_Dialog_New_DataType;
    }

    public Image getImage() {
        return null;
    }
}

