/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties.memberaccess;

import java.util.Arrays;
import java.util.List;
import org.eclipse.fordiac.ide.application.properties.memberaccess.MemberAccessTreeNode;
import org.eclipse.fordiac.ide.application.properties.memberaccess.StructMemberAccessTreeNode;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class MemberAccessTree {
    private final List<MemberAccessTreeNode> children;
    private final BlockFBNetworkElement blockFBNEl;

    public MemberAccessTree(BlockFBNetworkElement blockFBNEl, List<VarDeclaration> rootEntries) {
        this.children = rootEntries.stream().map(varDecl -> MemberAccessTreeNode.createTreeNode(null, varDecl)).toList();
        this.blockFBNEl = blockFBNEl;
    }

    public MemberAccessTreeNode getChild(String path) {
        String[] nameList = path.split("\\.");
        return MemberAccessTree.getChild(this.children, nameList);
    }

    /*
     * WARNING - void declaration
     */
    private static MemberAccessTreeNode getChild(List<MemberAccessTreeNode> children, String[] nameList) {
        void structTreeNode;
        MemberAccessTreeNode treeNode = children.stream().filter(n -> n.getName().equals(nameList[0])).findFirst().orElse(null);
        if (nameList.length == 1) {
            return treeNode;
        }
        if (!(treeNode instanceof StructMemberAccessTreeNode)) {
            return null;
        }
        StructMemberAccessTreeNode structMemberAccessTreeNode = (StructMemberAccessTreeNode)treeNode;
        return MemberAccessTree.getChild(structTreeNode.getChildren(), Arrays.copyOfRange(nameList, 1, nameList.length));
    }

    public BlockFBNetworkElement getBlockFBNetworkElement() {
        return this.blockFBNEl;
    }

    public List<MemberAccessTreeNode> getChildren() {
        return this.children;
    }
}

