/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties.memberaccess;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.application.properties.memberaccess.StructMemberAccessTreeNode;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class MemberAccessTreeNode {
    private final MemberAccessTreeNode parent;
    private final VarDeclaration varDecl;
    private boolean visible;

    static MemberAccessTreeNode createTreeNode(MemberAccessTreeNode parent, VarDeclaration varDecl) {
        if (varDecl.getType() instanceof StructuredType) {
            return new StructMemberAccessTreeNode(parent, varDecl);
        }
        return new MemberAccessTreeNode(parent, varDecl);
    }

    protected MemberAccessTreeNode(MemberAccessTreeNode parent, VarDeclaration varDecl) {
        this.parent = parent;
        this.varDecl = varDecl;
    }

    public String getComment() {
        return this.varDecl.getComment();
    }

    public List<String> getNamePath() {
        List<Object> path = this.parent != null ? this.parent.getNamePath() : new ArrayList();
        path.add(this.varDecl.getName());
        return path;
    }

    public String getFullTypeName() {
        return this.varDecl.getFullTypeName();
    }

    public boolean hasChildren() {
        return false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getName() {
        return this.varDecl.getName();
    }

    public MemberAccessTreeNode getParent() {
        return this.parent;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

