/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.wizards;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class QuickFixWizardDialog {
    private QuickFixWizardDialog() {
    }

    public static int openDialog(Shell parentShell, IMarker[] selectedMarkers, IMarkerResolution[] resolutions, Map<IMarkerResolution, Collection<IMarker>> resolutionMap) {
        QuickFixWizardPage wizardPage = new QuickFixWizardPage(selectedMarkers, resolutions, resolutionMap);
        QuickFixWizard wizard = new QuickFixWizard(wizardPage);
        wizard.setWindowTitle(Messages.QuickFixDialog_Title);
        WizardDialog dialog = new WizardDialog(parentShell, (IWizard)wizard);
        return dialog.open();
    }

    private static class QuickFixWizard
    extends Wizard {
        private final QuickFixWizardPage wizardPage;

        public QuickFixWizard(QuickFixWizardPage wizardPage) {
            this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(IDE.class, (String)"/icons/full/wizban/quick_fix.png"));
            this.wizardPage = wizardPage;
            this.addPage((IWizardPage)wizardPage);
        }

        public boolean performFinish() {
            IRunnableWithProgress runnable = monitor -> {
                IMarkerResolution2 iMarkerResolution2 = this.wizardPage.getSelectedResolution();
                if (iMarkerResolution2 instanceof WorkbenchMarkerResolution) {
                    WorkbenchMarkerResolution workbenchResolution = (WorkbenchMarkerResolution)iMarkerResolution2;
                    workbenchResolution.run(this.wizardPage.getSelectedMarker(), monitor);
                } else {
                    this.wizardPage.getSelectedResolution().run(this.wizardPage.getSelectedMarker()[0]);
                }
            };
            try {
                this.getContainer().run(false, true, runnable);
            }
            catch (InvocationTargetException e) {
                FordiacLogHelper.logError((String)"Quickfix issue", (Throwable)e);
            }
            catch (InterruptedException e) {
                FordiacLogHelper.logError((String)"Quickfix issue", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    private static class QuickFixWizardPage
    extends WizardPage {
        private static final Image ERROR_IMG = ImageDescriptor.createFromFile(IDE.class, (String)"/icons/full/obj16/error_tsk.png").createImage();
        private final IMarker[] initialMarkers;
        private final IMarkerResolution[] resolutions;
        private final Map<IMarkerResolution, Collection<IMarker>> resolutionMap;
        private TableViewer resolutionsList;
        private CheckboxTableViewer markersTable;

        protected QuickFixWizardPage(IMarker[] initialMarkers, IMarkerResolution[] resolutions, Map<IMarkerResolution, Collection<IMarker>> resolutionsMap) {
            super(Messages.QuickFixDialog_Title);
            this.initialMarkers = initialMarkers;
            this.resolutions = resolutions;
            this.resolutionMap = resolutionsMap;
            this.setTitle(Messages.QuickFixDialog_Title);
            this.setMessage(MessageFormat.format(Messages.QuickFixDialog_Message, initialMarkers[0].getAttribute("message", "")));
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite pageComposite = new Composite(parent, 0);
            pageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            pageComposite.setLayout((Layout)new GridLayout());
            this.setControl((Control)pageComposite);
            Composite selectResolutionComposite = new Composite(pageComposite, 0);
            selectResolutionComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            selectResolutionComposite.setLayout((Layout)new GridLayout());
            Label label = QuickFixWizardPage.addLabel(selectResolutionComposite);
            label.setText(Messages.QuickFixDialog_Resolutions_List_Title);
            this.createResolutionList(selectResolutionComposite);
            Composite selectMarkerComposite = new Composite(pageComposite, 0);
            selectMarkerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            selectMarkerComposite.setLayout((Layout)new GridLayout(2, false));
            label = QuickFixWizardPage.addLabel(selectMarkerComposite);
            label.setText(Messages.QuickFixDialog_Problems_List_Title);
            QuickFixWizardPage.addLabel(selectMarkerComposite);
            this.createMarkerList(selectMarkerComposite);
            this.resolutionsList.setSelection((ISelection)new StructuredSelection(this.resolutionsList.getElementAt(0)));
            this.markersTable.setCheckedElements((Object[])this.initialMarkers);
            this.setPageComplete(this.markersTable.getCheckedElements().length > 0);
        }

        private static Label addLabel(Composite selectMarkerComposite) {
            return new Label(selectMarkerComposite, 0);
        }

        private void createResolutionList(Composite parent) {
            this.resolutionsList = new TableViewer(parent, 2564);
            this.resolutionsList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.resolutionsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((IMarkerResolution)element).getLabel();
                }
            });
            this.resolutionsList.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object object1, Object object2) {
                    return ((IMarkerResolution)object1).getLabel().compareTo(((IMarkerResolution)object2).getLabel());
                }
            });
            this.resolutionsList.addSelectionChangedListener(event -> {
                Object object = event.getStructuredSelection().getFirstElement();
                if (object instanceof IMarkerResolution) {
                    IMarkerResolution resolution = (IMarkerResolution)object;
                    this.markersTable.setInput(this.resolutionMap.get(resolution));
                }
                this.setPageComplete(this.markersTable.getCheckedElements().length > 0);
                this.markersTable.refresh();
            });
            this.resolutionsList.setInput((Object)this.resolutions);
            Table table = this.resolutionsList.getTable();
            GridData data = new GridData(4, 4, true, true);
            data.minimumHeight = this.convertHeightInCharsToPixels(10);
            table.setLayoutData((Object)data);
        }

        private void createMarkerList(Composite parent) {
            this.markersTable = CheckboxTableViewer.newCheckList((Composite)parent, (int)2564);
            this.createTableColumns();
            this.createTableButtons(parent);
            this.markersTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.markersTable.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object object1, Object object2) {
                    return ((IMarker)object1).getResource().toString().compareTo(((IMarker)object2).getResource().toString());
                }
            });
            this.markersTable.addCheckStateListener(event -> {
                if (event.getChecked()) {
                    this.setPageComplete(true);
                } else {
                    this.setPageComplete(this.markersTable.getCheckedElements().length > 0);
                }
            });
            this.markersTable.setInput(this.resolutionMap.get(this.resolutionsList.getElementAt(0)));
        }

        private void createTableColumns() {
            Table table = this.markersTable.getTable();
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = this.convertHeightInCharsToPixels(10);
            table.setLayoutData((Object)data);
            TableLayout layout = new TableLayout();
            table.setLayout((Layout)layout);
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
            TableColumn tableColumn = new TableColumn(table, 0, 0);
            tableColumn.setText(Messages.QuickFixDialog_Problems_List_Location);
            TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this.markersTable, tableColumn);
            tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((IMarker)element).getAttribute("location", "");
                }
            });
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
            tableColumn = new TableColumn(table, 0, 0);
            tableColumn.setText(Messages.QuickFixDialog_Problems_List_Resource);
            tableViewerColumn = new TableViewerColumn((TableViewer)this.markersTable, tableColumn);
            tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public Image getImage(Object element) {
                    return ERROR_IMG;
                }

                public String getText(Object element) {
                    return ((IMarker)element).getResource().getName();
                }
            });
        }

        private void createTableButtons(Composite control) {
            Composite buttonComposite = new Composite(control, 0);
            buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            buttonComposite.setLayout((Layout)layout);
            Button selectAll = new Button(buttonComposite, 8);
            selectAll.setLayoutData((Object)new GridData(4, 4, true, true));
            selectAll.setText(Messages.QuickFixDialog_SelectAll);
            selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    markersTable.setAllChecked(true);
                    this.setPageComplete(!resolutionsList.getStructuredSelection().isEmpty());
                }
            });
            Button deselectAll = new Button(buttonComposite, 8);
            deselectAll.setLayoutData((Object)new GridData(4, 4, true, true));
            deselectAll.setText(Messages.QuickFixDialog_DeselectAll);
            deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    markersTable.setAllChecked(false);
                    this.setPageComplete(false);
                }
            });
        }

        public IMarkerResolution2 getSelectedResolution() {
            Object object = this.resolutionsList.getStructuredSelection().getFirstElement();
            if (object instanceof IMarkerResolution2) {
                IMarkerResolution2 selectedResolution = (IMarkerResolution2)object;
                return selectedResolution;
            }
            return null;
        }

        public IMarker[] getSelectedMarker() {
            return (IMarker[])Arrays.stream(this.markersTable.getCheckedElements()).map(IMarker.class::cast).toArray(IMarker[]::new);
        }
    }
}

