/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging.simulator.interpreter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.fordiac.debug.replaydebugging.trace.SendOutputEvent;
import org.eclipse.fordiac.debug.replaydebugging.trace.TracesReader;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.ReplayNavigator;
import org.eclipse.fordiac.ide.debug.replaydebugging.core.Utils;
import org.eclipse.fordiac.ide.debug.replaydebugging.simulator.IDeviceSimulator;
import org.eclipse.fordiac.ide.debug.replaydebugging.simulator.interpreter.ResourceSimulator;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.tracecompass.ctf.core.CTFException;

public class DeviceSimulator
implements IDeviceSimulator {
    private final String path;
    private final Device device;
    private Map<String, Set<IInterfaceElement>> allValueHolderElements = new HashMap<String, Set<IInterfaceElement>>();
    private final Map<IInterfaceElement, Integer> eventMonitoringValues = new HashMap<IInterfaceElement, Integer>();
    private final Map<Resource, ReplayNavigator.DatapointsState> currentStates = new HashMap<Resource, ReplayNavigator.DatapointsState>();
    private final Map<String, ResourceSimulator> resourceReplayers = new HashMap<String, ResourceSimulator>();

    public DeviceSimulator(Device device, String path) {
        this.path = path;
        this.device = device;
    }

    @Override
    public boolean start() {
        TracesReader tracerReader = new TracesReader(this.path);
        try {
            Map<String, List<SendOutputEvent>> externalEvents = tracerReader.read();
            for (Resource resource : this.device.getResource()) {
                List<SendOutputEvent> sifbEvents = externalEvents.getOrDefault(resource.getName(), List.of()).stream().map(externalEvent -> Map.entry(externalEvent, Utils.getInstanceFB(resource, externalEvent.instanceName()))).filter(entry -> Utils.isSIFB(((FB)entry.getValue()).getType())).map(Map.Entry::getKey).toList();
                this.resourceReplayers.put(resource.getName(), new ResourceSimulator(resource, sifbEvents));
            }
            for (Map.Entry<String, List<SendOutputEvent>> entry2 : externalEvents.entrySet()) {
                FordiacLogHelper.logInfo((String)("Resource: " + entry2.getKey()));
                for (SendOutputEvent event : entry2.getValue()) {
                    FordiacLogHelper.logInfo((String)("  " + String.valueOf(event)));
                }
            }
        }
        catch (CTFException e) {
            FordiacLogHelper.logError((String)("Error reading traces: " + e.getMessage()));
            return false;
        }
        this.allValueHolderElements = Utils.collectAllValueHolderElements(this.device);
        for (Map.Entry<String, Set<IInterfaceElement>> entry3 : this.allValueHolderElements.entrySet()) {
            for (IInterfaceElement element : entry3.getValue()) {
                System.out.println(" Element: " + element.getQualifiedName() + " id: " + System.identityHashCode(element));
                if (!(element instanceof Event)) continue;
                this.eventMonitoringValues.put(element, 0);
            }
        }
        for (Resource resource : this.device.getResource()) {
            this.updateState(resource);
        }
        return true;
    }

    @Override
    public boolean stop() {
        return true;
    }

    @Override
    public Optional<String> replayNextEvent(Resource resource) {
        String resourceName = resource.getName();
        ResourceSimulator resourceReplayer = this.resourceReplayers.get(resourceName);
        if (resourceReplayer == null) {
            return Optional.empty();
        }
        Optional<Event> event = resourceReplayer.reproduceNextEvent();
        if (event.isPresent()) {
            Integer currentCounter = this.eventMonitoringValues.get(event.get());
            if (currentCounter != null) {
                this.eventMonitoringValues.put((IInterfaceElement)event.get(), this.eventMonitoringValues.get(event.get()) + 1);
            }
            for (Event outputEvent : resourceReplayer.getLastOutputEvents()) {
                Integer val = this.eventMonitoringValues.get(outputEvent);
                if (val == null) {
                    val = 0;
                    this.eventMonitoringValues.put((IInterfaceElement)outputEvent, val);
                }
                this.eventMonitoringValues.put((IInterfaceElement)outputEvent, this.eventMonitoringValues.get(outputEvent) + 1);
            }
            this.updateState(resource);
            return Optional.of(event.get().getQualifiedName());
        }
        this.updateState(resource);
        return Optional.empty();
    }

    @Override
    public ReplayNavigator.DatapointsState getCurrentState(Resource resource) {
        return this.currentStates.get(resource);
    }

    private void updateState(Resource resource) {
        Set<IInterfaceElement> interfaceElements = this.allValueHolderElements.get(resource.getName());
        ReplayNavigator.DatapointsState result = new ReplayNavigator.DatapointsState();
        for (IInterfaceElement interfaceElement : interfaceElements) {
            VarDeclaration varDecl;
            Value value;
            if (interfaceElement instanceof Event) {
                result.put(Utils.getWatchName(interfaceElement), Integer.toString(this.eventMonitoringValues.get(interfaceElement)));
                continue;
            }
            if (!(interfaceElement instanceof VarDeclaration) || (value = (varDecl = (VarDeclaration)interfaceElement).getValue()) == null) continue;
            result.put(Utils.getWatchName((IInterfaceElement)varDecl), varDecl.getValue().getValue());
        }
        this.currentStates.put(resource, result);
    }
}

