/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.st.codemining;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugStackFrame;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class TextSelectionIVariableAdapterFactory
implements IAdapterFactory {
    private static final EObjectAtOffsetHelper offsetHelper = new EObjectAtOffsetHelper();

    /*
     * WARNING - void declaration
     */
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        void selection;
        if (!adapterType.isAssignableFrom(IVariable.class)) {
            return null;
        }
        if (!(adaptableObject instanceof TextSelection)) {
            return null;
        }
        TextSelection textSelection = (TextSelection)adaptableObject;
        IDocument document = TextSelectionIVariableAdapterFactory.getDocument((TextSelection)selection);
        if (document == null) {
            return null;
        }
        EvaluatorDebugStackFrame frame = TextSelectionIVariableAdapterFactory.getFrame();
        if (frame == null) {
            return null;
        }
        Evaluator evaluator = frame.getEvaluator();
        if (evaluator == null) {
            return null;
        }
        Object sourceElement = evaluator.getSourceElement();
        if (!(sourceElement instanceof EObject)) {
            return null;
        }
        URI sourceUri = EcoreUtil.getURI((EObject)((EObject)sourceElement));
        URI documentUri = (URI)Adapters.adapt((Object)document, URI.class);
        if (sourceUri == null || !Objects.equals(sourceUri.trimFragment(), documentUri)) {
            return null;
        }
        INamedElement sourceVariable = TextSelectionIVariableAdapterFactory.getSourceVariableAt(document, selection.getOffset());
        if (sourceVariable == null) {
            return null;
        }
        return adapterType.cast(TextSelectionIVariableAdapterFactory.getVariable(frame, sourceVariable));
    }

    protected static INamedElement getSourceVariableAt(IDocument document, int offset) {
        if (document instanceof XtextDocument) {
            return (INamedElement)((XtextDocument)document).readOnly(resource -> {
                EObject candidate = offsetHelper.resolveElementAt(resource, offset);
                if (candidate instanceof VarDeclaration || candidate instanceof STVarDeclaration) {
                    return (INamedElement)candidate;
                }
                candidate = offsetHelper.resolveCrossReferencedElementAt(resource, offset);
                if (candidate instanceof VarDeclaration || candidate instanceof STVarDeclaration) {
                    return (INamedElement)candidate;
                }
                return null;
            });
        }
        return null;
    }

    protected static IDocument getDocument(TextSelection sel) {
        try {
            Method documentMethod = TextSelection.class.getDeclaredMethod("getDocument", new Class[0]);
            documentMethod.setAccessible(true);
            return (IDocument)documentMethod.invoke((Object)sel, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    protected static EvaluatorDebugVariable getVariable(EvaluatorDebugStackFrame frame, INamedElement sourceVariable) {
        EvaluatorDebugVariable variable = frame.getVariable(sourceVariable.getName());
        if (variable != null) {
            return variable;
        }
        EvaluatorDebugVariable context = frame.getVariable("THIS");
        if (context != null) {
            return context.getValue().getVariable(sourceVariable.getName());
        }
        return null;
    }

    protected static EvaluatorDebugStackFrame getFrame() {
        if (PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            return null;
        }
        try {
            IAdaptable adaptable = DebugUITools.getDebugContext();
            if (adaptable != null) {
                return (EvaluatorDebugStackFrame)adaptable.getAdapter(EvaluatorDebugStackFrame.class);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IVariable.class};
    }
}

