/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.fordiac.ide.debug.CommonEvaluatorDebugger;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugElement;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugStackFrame;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugTarget;
import org.eclipse.fordiac.ide.model.eval.Evaluator;

public class EvaluatorDebugThread
extends EvaluatorDebugElement
implements IThread {
    private static final int REQUEST_WAIT_TIME = 1000;
    private final Thread thread;
    private final AtomicReference<DebugEvent> request = new AtomicReference<Object>(null);
    private final AtomicBoolean suspended = new AtomicBoolean();
    private final AtomicReference<Evaluator> currentEvaluator = new AtomicReference();

    public EvaluatorDebugThread(Thread thread, EvaluatorDebugTarget debugTarget) {
        super(debugTarget);
        this.thread = thread;
        this.fireCreationEvent();
    }

    protected void request(int kind, int detail) {
        this.request((Object)this, kind, detail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void request(Object source, int kind, int detail) {
        AtomicReference<DebugEvent> atomicReference = this.request;
        synchronized (atomicReference) {
            this.request.set(new DebugEvent(source, kind, detail));
            this.request.notifyAll();
        }
    }

    public DebugEvent peekRequest() {
        return this.request.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugEvent awaitResumeRequest() throws InterruptedException {
        DebugEvent resultingRequest = null;
        AtomicReference<DebugEvent> atomicReference = this.request;
        synchronized (atomicReference) {
            while ((resultingRequest = (DebugEvent)this.request.getAndSet(null)) == null || resultingRequest.getKind() != 1) {
                this.request.wait(1000L);
            }
        }
        return resultingRequest;
    }

    public void terminated() {
        this.fireTerminateEvent();
    }

    public Evaluator getCurrentEvaluator() {
        return this.currentEvaluator.get();
    }

    public void setCurrentEvaluator(Evaluator evaluator) {
        this.currentEvaluator.set(evaluator);
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.suspended.get();
    }

    public void resumed(int detail) {
        if (this.suspended.getAndSet(false)) {
            this.fireResumeEvent(detail);
            this.getDebugTarget().fireResumeEvent(detail);
        }
    }

    public void suspended(int detail) {
        if (!this.suspended.getAndSet(true)) {
            EvaluatorDebugTarget debugTarget = this.getDebugTarget();
            debugTarget.incrementVariableUpdateCount();
            this.fireSuspendEvent(detail);
            if (debugTarget.isSuspended()) {
                debugTarget.fireSuspendEvent(detail);
            }
        }
    }

    public synchronized void resume() {
        this.request(1, 32);
    }

    public void suspend() {
        this.request(2, 32);
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public boolean isStepping() {
        DebugEvent req = this.request.get();
        return req != null && req.isStepStart();
    }

    public void stepInto() {
        this.request(1, 1);
    }

    public void stepOver() {
        this.request(1, 2);
    }

    public void stepReturn() {
        this.request(1, 4);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return !this.thread.isAlive();
    }

    public void terminate() {
        this.thread.interrupt();
    }

    public EvaluatorDebugStackFrame getTopStackFrame() throws DebugException {
        Evaluator evaluator = this.getCurrentEvaluator();
        if (evaluator == null) {
            return null;
        }
        return this.getDebugTarget().getDebugger().getStackFrame(evaluator, this);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        CommonEvaluatorDebugger debugger = this.getDebugTarget().getDebugger();
        ArrayList<EvaluatorDebugStackFrame> stackFrames = new ArrayList<EvaluatorDebugStackFrame>();
        Evaluator evaluator = this.getCurrentEvaluator();
        while (evaluator != null) {
            stackFrames.add(debugger.getStackFrame(evaluator, this));
            evaluator = evaluator.getParent();
        }
        return stackFrames.toArray(new IStackFrame[stackFrames.size()]);
    }

    public boolean hasStackFrames() throws DebugException {
        return this.getCurrentEvaluator() != null;
    }

    public int getPriority() throws DebugException {
        return this.thread.getPriority();
    }

    public String getName() throws DebugException {
        return this.thread.getName();
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public EvaluatorDebugTarget getDebugTarget() {
        return (EvaluatorDebugTarget)super.getDebugTarget();
    }
}

