/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.handler;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.util.DeploymentHelper;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractDeploymentCommand
extends AbstractHandler {
    private Device device = null;
    private final Set<AutomationSystem> monitoredSystems = new HashSet<AutomationSystem>();

    protected void setDevice(Device device) {
        this.device = device;
    }

    protected Device getDevice() {
        return this.device;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.monitoredSystems.clear();
        List<Object> list = AbstractDeploymentCommand.getObjectSelectionArray(event);
        for (Object currentElement : list) {
            if (!this.prepareParametersToExecute(currentElement)) continue;
            IDeviceManagementInteractor interactor = DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor(this.device);
            if (interactor != null) {
                OnlineDeploymentErrorCheckListener errorChecker = new OnlineDeploymentErrorCheckListener(this);
                interactor.addDeploymentListener((IDeploymentListener)errorChecker);
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (IDeviceManagementInteractor.IDeviceManagementInteractorCloser closer = () -> ((IDeviceManagementInteractor)interactor).disconnect();){
                        interactor.connect();
                        this.executeCommand(interactor);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DeploymentException e) {
                    errorChecker.showDeploymentError(e.getMessage(), DeploymentHelper.getMgrIDSafe((Device)this.device), this);
                }
                interactor.removeDeploymentListener((IDeploymentListener)errorChecker);
                continue;
            }
            this.manageExecutorError();
        }
        return null;
    }

    private static List<Object> getObjectSelectionArray(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.toList();
        }
        return Collections.emptyList();
    }

    protected static String getPrefixFor(FBNetworkElement fb) {
        EObject eObject = fb.eContainer().eContainer();
        if (eObject instanceof INamedElement) {
            INamedElement namedEl = (INamedElement)eObject;
            return namedEl.getQualifiedName() + ".";
        }
        return "";
    }

    protected abstract boolean prepareParametersToExecute(Object var1);

    protected abstract void executeCommand(IDeviceManagementInteractor var1) throws DeploymentException;

    protected void manageExecutorError() {
        DeploymentCoordinator.printUnsupportedDeviceProfileMessageBox((Device)this.device, null);
    }

    protected abstract String getErrorMessageHeader();

    protected abstract String getCurrentElementName();

    private static class OnlineDeploymentErrorCheckListener
    implements IDeploymentListener {
        private final AbstractDeploymentCommand currentObject;
        private String lastMessage = "";
        private String lastCommand = "";

        public OnlineDeploymentErrorCheckListener(AbstractDeploymentCommand currentObject) {
            this.currentObject = currentObject;
        }

        public void connectionOpened(Device dev) {
        }

        public void postCommandSent(String info, String destination, String command) {
            this.lastCommand = command;
        }

        public void postResponseReceived(String response, String source) {
            if (response.contains("Reason")) {
                this.showDeploymentError(response.substring(response.lastIndexOf("Reason") + 8, response.length() - 4), source, this.currentObject);
            }
        }

        public void connectionClosed(Device dev) {
        }

        public void showDeploymentError(String response, String source, AbstractDeploymentCommand currentElement) {
            String currentMessage = !this.lastCommand.equals("") ? MessageFormat.format(Messages.AbstractDeploymentCommand_ExtendedDeploymentErrorMessage, currentElement.getCurrentElementName(), this.lastCommand, response, source) : MessageFormat.format(Messages.AbstractDeploymentCommand_SimpleDeploymentErrorMessage, currentElement.getCurrentElementName(), response, source);
            if (!this.lastMessage.equals(currentMessage)) {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)currentElement.getErrorMessageHeader(), (String)currentMessage);
                this.lastMessage = currentMessage;
            }
        }
    }
}

