/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug;

import java.text.MessageFormat;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugTarget;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentLaunchValue;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentProcess;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public class DeploymentLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String MONITOR_MODE = "org.eclipse.fordiac.ide.deployment.debug.monitor";
    public static final String SYSTEM_FILE_ATTRIBUTE = "org.eclipse.fordiac.ide.deployment.debug.systemFile";
    public static final int ALREADY_RUNNING_CODE = 200;
    public static final IStatus ALREADY_RUNNING_STATUS = new Status(4, DeploymentLaunchConfigurationDelegate.class, 200, "", null);

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block6: {
            IResource resource = DeploymentLaunchConfigurationAttributes.getSystemResource(configuration);
            AutomationSystem system = DeploymentLaunchConfigurationAttributes.getSystem(configuration);
            if (system == null) {
                throw new CoreException(Status.error((String)Messages.DeploymentLaunchConfigurationDelegate_CannotFindSystem));
            }
            Set<INamedElement> selection = DeploymentLaunchConfigurationAttributes.getSelection(configuration, system);
            Duration pollingInterval = DeploymentLaunchConfigurationAttributes.getPollingInterval(configuration);
            DeploymentLaunchConfigurationAttributes.AllowTerminate allowTerminate = DeploymentLaunchConfigurationAttributes.getAllowTerminate(configuration);
            List<DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint> launchWatches = DeploymentLaunchConfigurationAttributes.getWatches(configuration);
            List<DeploymentLaunchValue> launchValues = DeploymentLaunchConfigurationAttributes.getValues(configuration);
            launch.setAttribute(SYSTEM_FILE_ATTRIBUTE, resource.getFullPath().toString());
            try {
                if ("run".equals(mode)) {
                    DeploymentProcess process = new DeploymentProcess(system, selection, launchValues, launch);
                    process.start();
                    break block6;
                }
                if ("debug".equals(mode)) {
                    DeploymentDebugTarget debugTarget = new DeploymentDebugTarget(system, selection, launchValues, launch, allowTerminate != DeploymentLaunchConfigurationAttributes.AllowTerminate.NEVER, pollingInterval, launchWatches);
                    debugTarget.start();
                    break block6;
                }
                if (MONITOR_MODE.equals(mode)) {
                    DeploymentDebugTarget debugTarget = new DeploymentDebugTarget(system, Set.of(), launchValues, launch, allowTerminate == DeploymentLaunchConfigurationAttributes.AllowTerminate.ALWAYS, pollingInterval, launchWatches);
                    debugTarget.start();
                    break block6;
                }
                throw new CoreException(Status.error((String)MessageFormat.format(Messages.DeploymentLaunchConfigurationDelegate_IllegalLaunchMode, mode)));
            }
            catch (DeploymentException e) {
                throw new CoreException(Status.error((String)Messages.DeploymentLaunchConfigurationDelegate_DeploymentError, (Throwable)e));
            }
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        List<ILaunch> activeLaunches;
        IResource resource = DeploymentLaunchConfigurationAttributes.getSystemResource(configuration);
        if (resource != null && !(activeLaunches = DeploymentLaunchConfigurationDelegate.getActiveLaunches(resource)).isEmpty() && !DeploymentLaunchConfigurationDelegate.handleActiveLaunches(resource, activeLaunches)) {
            return false;
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    protected static boolean handleActiveLaunches(IResource resource, List<ILaunch> activeLaunches) throws CoreException {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(ALREADY_RUNNING_STATUS);
        if (handler == null) {
            return false;
        }
        boolean terminate = (Boolean)handler.handleStatus(ALREADY_RUNNING_STATUS, (Object)resource.getName());
        if (!terminate) {
            return false;
        }
        DeploymentLaunchConfigurationDelegate.terminateLaunches(activeLaunches);
        return true;
    }

    protected static void terminateLaunches(List<ILaunch> launches) throws CoreException {
        for (ILaunch launch : launches) {
            IDisconnect disconnect;
            if (launch instanceof IDisconnect && (disconnect = (IDisconnect)launch).canDisconnect()) {
                disconnect.disconnect();
            }
            if (launch.canTerminate()) {
                launch.terminate();
            }
            if (launch.isTerminated()) continue;
            throw new CoreException(Status.error((String)Messages.DeploymentLaunchConfigurationDelegate_LaunchNotTerminated));
        }
    }

    public static List<ILaunch> getActiveLaunches(IResource resource) {
        return Stream.of(DebugPlugin.getDefault().getLaunchManager().getLaunches()).filter(launch -> resource.getFullPath().toString().equals(launch.getAttribute(SYSTEM_FILE_ATTRIBUTE))).toList();
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject project;
        IResource resource = DeploymentLaunchConfigurationAttributes.getSystemResource(configuration);
        if (resource != null && (project = resource.getProject()) != null) {
            return this.computeReferencedBuildOrder(new IProject[]{project});
        }
        return super.getBuildOrder(configuration, mode);
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.getBuildOrder(configuration, mode);
    }
}

