/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.data;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.deployment.Messages;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentSource;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.ParameterDeploymentData;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.util.DeploymentHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.InterfaceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public class ResourceDeploymentData {
    private final Resource res;
    private final List<FBDeploymentData> fbs = new ArrayList<FBDeploymentData>();
    private final List<ConnectionDeploymentData> connections = new ArrayList<ConnectionDeploymentData>();
    private final List<ParameterDeploymentData> params = new ArrayList<ParameterDeploymentData>();
    private final SequencedSet<FBTypeEntry> fbTypes = new LinkedHashSet<FBTypeEntry>();
    private final SequencedSet<DataTypeEntry> dataTypes = new LinkedHashSet<DataTypeEntry>();

    public Resource getRes() {
        return this.res;
    }

    public List<FBDeploymentData> getFbs() {
        return this.fbs;
    }

    public List<ConnectionDeploymentData> getConnections() {
        return this.connections;
    }

    public List<ParameterDeploymentData> getParams() {
        return this.params;
    }

    public SequencedSet<FBTypeEntry> getFbTypes() {
        return this.fbTypes;
    }

    public SequencedSet<DataTypeEntry> getDataTypes() {
        return this.dataTypes;
    }

    public void addFbs(FBDeploymentData fb) {
        this.fbs.add(fb);
    }

    public void addConnections(ConnectionDeploymentData connection) {
        this.connections.add(connection);
    }

    public void addParameter(ParameterDeploymentData param) {
        this.params.add(param);
    }

    public ResourceDeploymentData(Resource res) throws DeploymentException {
        this.res = res;
        this.addFBNetworkElements(new ArrayDeque<SubApp>(), res.getFBNetwork(), new StringBuilder());
    }

    private void addFBNetworkElements(Deque<SubApp> subAppHierarchy, FBNetwork fbNetwork, StringBuilder prefix) throws DeploymentException {
        for (FBNetworkElement fbnElement : fbNetwork.getNetworkElements()) {
            if (fbnElement instanceof FB) {
                FB fb = (FB)fbnElement;
                this.addFB(subAppHierarchy, prefix, fb);
                continue;
            }
            if (!(fbnElement instanceof SubApp)) continue;
            SubApp subApp = (SubApp)fbnElement;
            ResourceDeploymentData.enterSubApp(subAppHierarchy, prefix, subApp);
            FBNetwork subAppInternalNetwork = ResourceDeploymentData.getFBNetworkForSubApp(subApp);
            if (subAppInternalNetwork == null) {
                throw new DeploymentException(MessageFormat.format(Messages.ResourceDeploymentData_MissingSubAppNetwork, prefix));
            }
            this.addFBNetworkElements(subAppHierarchy, subAppInternalNetwork, prefix);
            ResourceDeploymentData.leaveSubApp(subAppHierarchy, prefix);
        }
    }

    private void addFB(Deque<SubApp> subAppHierarchy, StringBuilder prefix, FB fb) throws DeploymentException {
        TypeEntry typeEntry;
        ConfigurableFB configurableFB;
        this.fbs.add(new FBDeploymentData(ResourceDeploymentData.ensurePrefix(prefix, (FBNetworkElement)fb), (FBNetworkElement)fb));
        InterfaceTypeEntry interfaceTypeEntry = fb.getTypeEntry();
        if (interfaceTypeEntry instanceof FBTypeEntry) {
            FBTypeEntry entry = (FBTypeEntry)interfaceTypeEntry;
            this.fbTypes.add(entry);
        }
        if (fb instanceof ConfigurableFB && (configurableFB = (ConfigurableFB)fb).getDataType() != null && (typeEntry = configurableFB.getDataType().getTypeEntry()) instanceof DataTypeEntry) {
            DataTypeEntry entry = (DataTypeEntry)typeEntry;
            this.dataTypes.add(entry);
        }
        for (VarDeclaration inputVar : fb.getInterface().getInputVars()) {
            this.addInputParam(subAppHierarchy, prefix, inputVar);
        }
        for (VarDeclaration inoutVar : fb.getInterface().getInOutVars()) {
            this.addInputParam(subAppHierarchy, prefix, inoutVar);
        }
        fb.getInterface().getInputs().forEach(input -> this.addInputConnections(subAppHierarchy, prefix, (IInterfaceElement)input));
    }

    private void addInputParam(Deque<SubApp> subAppHierarchy, StringBuilder prefix, VarDeclaration input) throws DeploymentException {
        String value = ResourceDeploymentData.findInitialValue(subAppHierarchy, input);
        if (value != null) {
            this.params.add(new ParameterDeploymentData(ResourceDeploymentData.ensurePrefix(prefix, (FBNetworkElement)input.getBlockFBNetworkElement()), input, value));
        }
    }

    private static String findInitialValue(Deque<SubApp> subAppHierarchy, VarDeclaration input) throws DeploymentException {
        IInterfaceElement iInterfaceElement;
        VarDeclaration source;
        IInterfaceElement iInterfaceElement2;
        boolean negate = false;
        VarDeclaration result = input;
        Iterator<SubApp> subAppIterator = subAppHierarchy.descendingIterator();
        while (!result.getInputConnections().isEmpty() && (iInterfaceElement2 = ((Connection)result.getInputConnections().getFirst()).getSource()) instanceof VarDeclaration && (source = (VarDeclaration)iInterfaceElement2).isIsInput() && subAppIterator.hasNext() && (iInterfaceElement = ResourceDeploymentData.getSubAppExternalElement((IInterfaceElement)source, subAppIterator.next())) instanceof VarDeclaration) {
            VarDeclaration externalSource = (VarDeclaration)iInterfaceElement;
            negate ^= ((Connection)result.getInputConnections().getFirst()).isNegated();
            result = externalSource;
        }
        return DeploymentHelper.getVariableValue(result, input, negate);
    }

    private void addInputConnections(Deque<SubApp> subAppHierarchy, StringBuilder prefix, IInterfaceElement input) {
        String inputPrefix = ResourceDeploymentData.ensurePrefix(prefix, (FBNetworkElement)input.getBlockFBNetworkElement());
        for (ConnectionDeploymentSource sourceData : this.findSourceEndPoints(subAppHierarchy, prefix, new StringBuilder(), input, new ArrayList<ConnectionDeploymentSource>())) {
            this.connections.add(sourceData.toConnectionData(inputPrefix, input));
        }
    }

    private List<ConnectionDeploymentSource> findSourceEndPoints(Deque<SubApp> subAppHierarchy, StringBuilder prefix, StringBuilder suffix, IInterfaceElement destination, List<ConnectionDeploymentSource> result) {
        for (Connection con : destination.getInputConnections()) {
            DeploymentHelper.addSourceSuffix(suffix, con);
            this.findConnectionEndPoints(subAppHierarchy, prefix, suffix, con.getSource(), result);
            DeploymentHelper.removeSourceSuffix(suffix, con);
        }
        return result;
    }

    private void findConnectionEndPoints(Deque<SubApp> subAppHierarchy, StringBuilder prefix, StringBuilder suffix, IInterfaceElement source, List<ConnectionDeploymentSource> result) {
        if (source.isIsInput()) {
            SubApp subApp = ResourceDeploymentData.leaveSubApp(subAppHierarchy, prefix);
            IInterfaceElement externalElement = ResourceDeploymentData.getSubAppExternalElement(source, subApp);
            if (externalElement != null) {
                this.findSourceEndPoints(subAppHierarchy, prefix, suffix, externalElement, result);
            }
            ResourceDeploymentData.enterSubApp(subAppHierarchy, prefix, subApp);
        } else {
            BlockFBNetworkElement blockFBNetworkElement = source.getBlockFBNetworkElement();
            if (blockFBNetworkElement instanceof SubApp) {
                SubApp subApp = (SubApp)blockFBNetworkElement;
                ResourceDeploymentData.enterSubApp(subAppHierarchy, prefix, subApp);
                IInterfaceElement internalElement = ResourceDeploymentData.getSubAppInternalElement(source, subApp);
                if (internalElement != null) {
                    this.findSourceEndPoints(subAppHierarchy, prefix, suffix, internalElement, result);
                }
                ResourceDeploymentData.leaveSubApp(subAppHierarchy, prefix);
            } else {
                result.add(new ConnectionDeploymentSource(ResourceDeploymentData.ensurePrefix(prefix, (FBNetworkElement)source.getBlockFBNetworkElement()), suffix.toString(), source));
            }
        }
    }

    private static void enterSubApp(Deque<SubApp> subAppHierarchy, StringBuilder prefix, SubApp subApp) {
        subAppHierarchy.addLast(subApp);
        if (prefix.isEmpty()) {
            prefix.append(ResourceDeploymentData.getMappedParentName((FBNetworkElement)subApp));
        }
        prefix.append(subApp.getName());
        prefix.append('.');
    }

    private static SubApp leaveSubApp(Deque<SubApp> subAppHierarchy, StringBuilder prefix) {
        SubApp subApp = subAppHierarchy.removeLast();
        if (subAppHierarchy.isEmpty()) {
            prefix.setLength(0);
        } else {
            int newLength = prefix.length() - subApp.getName().length() - 1;
            if (newLength >= 0) {
                prefix.setLength(newLength);
            }
        }
        return subApp;
    }

    private static String ensurePrefix(StringBuilder prefix, FBNetworkElement element) {
        return prefix.isEmpty() ? ResourceDeploymentData.getMappedParentName(element) : prefix.toString();
    }

    private static IInterfaceElement getSubAppInternalElement(IInterfaceElement element, SubApp subApp) {
        BlockFBNetworkElement blockFBNetworkElement;
        InterfaceList interfaceList;
        if (subApp instanceof TypedSubApp) {
            interfaceList = subApp.getType().getInterfaceList();
        } else if (subApp.getSubAppNetwork() == null && (blockFBNetworkElement = subApp.getOpposite()) instanceof SubApp) {
            SubApp subAppOpposite = (SubApp)blockFBNetworkElement;
            interfaceList = subAppOpposite.getInterface();
        } else {
            return element;
        }
        return element.isIsInput() ? interfaceList.getInput(element.getName()) : interfaceList.getOutput(element.getName());
    }

    private static IInterfaceElement getSubAppExternalElement(IInterfaceElement element, SubApp subApp) {
        if (subApp instanceof UntypedSubApp) {
            return element;
        }
        return element.isIsInput() ? subApp.getInput(element.getName()) : subApp.getOutput(element.getName());
    }

    private static FBNetwork getFBNetworkForSubApp(SubApp subApp) {
        BlockFBNetworkElement blockFBNetworkElement;
        if (subApp instanceof TypedSubApp) {
            return subApp.getType().getFBNetwork();
        }
        if (subApp.getSubAppNetwork() == null && (blockFBNetworkElement = subApp.getOpposite()) instanceof SubApp) {
            SubApp oppositeSubApp = (SubApp)blockFBNetworkElement;
            return oppositeSubApp.getSubAppNetwork();
        }
        return subApp.getSubAppNetwork();
    }

    public static String getMappedParentName(FBNetworkElement fbnElement) {
        EObject eObject;
        if (fbnElement.isMapped() && (eObject = fbnElement.getMapping().getFrom().eContainer().eContainer()) instanceof INamedElement) {
            INamedElement namedEl = (INamedElement)eObject;
            return namedEl.getQualifiedName() + ".";
        }
        return "";
    }
}

