/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.base;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.forte_ng.ForteFBTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.export.language.ILanguageSupportFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class BaseFBImplTemplate<T extends BaseFBType>
extends ForteFBTemplate<T> {
    private final Map<Algorithm, ILanguageSupport> algorithmLanguageSupport;
    private final Map<Method, ILanguageSupport> methodLanguageSupport;

    public BaseFBImplTemplate(T type, String name, Path prefix, String baseClass, Map<?, ?> options) {
        super(type, name, prefix, baseClass, options);
        Functions.Function1 _function = it -> ILanguageSupportFactory.createLanguageSupport((String)"forte_ng", (EObject)it, (Map)options);
        this.algorithmLanguageSupport = IterableExtensions.toInvertedMap((Iterable)type.getAlgorithm(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> ILanguageSupportFactory.createLanguageSupport((String)"forte_ng", (EObject)it, (Map)options);
        this.methodLanguageSupport = IterableExtensions.toInvertedMap((Iterable)type.getMethods(), (Functions.Function1)_function_1);
    }

    public CharSequence generate() {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateHeader = this.generateHeader();
        _builder.append((Object)_generateHeader);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateImplIncludes = this.generateImplIncludes();
        _builder.append((Object)_generateImplIncludes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("namespace ");
        String _generateTypeNamespace = ForteNgExportUtil.generateTypeNamespace(this.getType());
        _builder.append(_generateTypeNamespace);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("namespace {");
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateTypeHash = this.generateTypeHash();
        _builder.append((Object)_generateTypeHash, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateFBInterfaceDefinition = this.generateFBInterfaceDefinition();
        _builder.append((Object)_generateFBInterfaceDefinition, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _generateFBInterfaceSpecDefinition = this.generateFBInterfaceSpecDefinition();
        _builder.append((Object)_generateFBInterfaceSpecDefinition, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _generateInternalVarDefinition = this.generateInternalVarDefinition();
        _builder.append((Object)_generateInternalVarDefinition, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        CharSequence _generateFBDefinition = this.generateFBDefinition();
        _builder.append((Object)_generateFBDefinition, "  ");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = ((BaseFBType)this.getType()).getInternalConstVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("  ");
            CharSequence _generateVariableDefinitions = this.generateVariableDefinitions((List<VarDeclaration>)((BaseFBType)this.getType()).getInternalConstVars(), true);
            _builder.append((Object)_generateVariableDefinitions, "  ");
            _builder.append("\t\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("  ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName, "  ");
        _builder.append("::");
        CharSequence _fBClassName_1 = this.getFBClassName();
        _builder.append((Object)_fBClassName_1, "  ");
        _builder.append("(const StringId paInstanceNameId, CFBContainer &paContainer) :");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        String _baseClass = this.baseClass();
        _builder.append(_baseClass, "      ");
        _builder.append("(paContainer, cFBInterfaceSpec, paInstanceNameId, ");
        boolean _isEmpty_1 = ((BaseFBType)this.getType()).getInternalVars().isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            _builder.append("cInternalsNames");
        } else {
            _builder.append("{}");
        }
        _builder.append(")");
        CharSequence _generateInternalFBInitializer = this.generateInternalFBInitializer((List<FB>)((BaseFBType)this.getType()).getInternalFbs());
        _builder.append((Object)_generateInternalFBInitializer, "      ");
        EList _internalVars = ((BaseFBType)this.getType()).getInternalVars();
        EList _inputVars = ((BaseFBType)this.getType()).getInterfaceList().getInputVars();
        Iterable _plus = Iterables.concat((Iterable)_internalVars, (Iterable)_inputVars);
        EList _inOutVars = ((BaseFBType)this.getType()).getInterfaceList().getInOutVars();
        Iterable _plus_1 = Iterables.concat((Iterable)_plus, (Iterable)_inOutVars);
        EList _outputVars = ((BaseFBType)this.getType()).getInterfaceList().getOutputVars();
        CharSequence _generateVariableInitializer = this.generateVariableInitializer(Iterables.concat((Iterable)_plus_1, (Iterable)_outputVars));
        _builder.append((Object)_generateVariableInitializer, "      ");
        EList _sockets = ((BaseFBType)this.getType()).getInterfaceList().getSockets();
        EList _plugs = ((BaseFBType)this.getType()).getInterfaceList().getPlugs();
        CharSequence _generateAdapterInitializer = this.generateAdapterInitializer(IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_sockets, (Iterable)_plugs)));
        _builder.append((Object)_generateAdapterInitializer, "      ");
        CharSequence _generateConnectionInitializer = this.generateConnectionInitializer();
        _builder.append((Object)_generateConnectionInitializer, "      ");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        EList _internalVars_1 = ((BaseFBType)this.getType()).getInternalVars();
        EList _inputVars_1 = ((BaseFBType)this.getType()).getInterfaceList().getInputVars();
        Iterable _plus_2 = Iterables.concat((Iterable)_internalVars_1, (Iterable)_inputVars_1);
        EList _inOutVars_1 = ((BaseFBType)this.getType()).getInterfaceList().getInOutVars();
        Iterable _plus_3 = Iterables.concat((Iterable)_plus_2, (Iterable)_inOutVars_1);
        EList _outputVars_1 = ((BaseFBType)this.getType()).getInterfaceList().getOutputVars();
        CharSequence _generateSetInitialValuesDefinition = this.generateSetInitialValuesDefinition(Iterables.concat((Iterable)_plus_3, (Iterable)_outputVars_1));
        _builder.append((Object)_generateSetInitialValuesDefinition, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateExecuteEvent = this.generateExecuteEvent();
        _builder.append((Object)_generateExecuteEvent, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateInterfaceDefinitions = this.generateInterfaceDefinitions();
        _builder.append((Object)_generateInterfaceDefinitions, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateAccessorDefinition = this.generateAccessorDefinition((List<VarDeclaration>)((BaseFBType)this.getType()).getInternalVars(), "getVarInternal", false);
        _builder.append((Object)_generateAccessorDefinition, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateAlgorithms = this.generateAlgorithms();
        _builder.append((Object)_generateAlgorithms, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateMethods = this.generateMethods();
        _builder.append((Object)_generateMethods, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateInternalVarDefinition() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = ((BaseFBType)this.getType()).getInternalVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.newLine();
            _builder.append("const auto cInternalsNames = std::array{");
            String _fORTENameList = this.getFORTENameList((List<INamedElement>)((BaseFBType)this.getType()).getInternalVars());
            _builder.append(_fORTENameList);
            _builder.append("};");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateChangeFBExecutionState() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("EMGMResponse ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::changeFBExecutionState(EMGMCommandType paCommand) {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("return changeFBExecutionStateHelper(paCommand, csmAmountOfInternalFBs, mInternalFBs);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateSendEvent(Event event) {
        StringConcatenation _xblockexpression = null;
        BlockFBNetworkElement _blockFBNetworkElement = event.getBlockFBNetworkElement();
        if (_blockFBNetworkElement instanceof AdapterFB) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("sendAdapterEvent(*");
            BlockFBNetworkElement _blockFBNetworkElement_1 = event.getBlockFBNetworkElement();
            CharSequence _generateName = ForteNgExportUtil.generateName((AdapterFB)_blockFBNetworkElement_1);
            _builder.append((Object)_generateName);
            _builder.append(", FORTE_");
            String _typeName = this.getAdapterDeclaration(event).getTypeName();
            _builder.append(_typeName);
            _builder.append("::scmEvent");
            String _name = event.getName();
            _builder.append(_name);
            _builder.append("ID, paECET);");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("sendOutputEvent(scmEvent");
        String _name_1 = event.getName();
        _builder_1.append(_name_1);
        _builder_1.append("ID, paECET);");
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    private AdapterDeclaration getAdapterDeclaration(Event event) {
        BlockFBNetworkElement _blockFBNetworkElement = event.getBlockFBNetworkElement();
        return ((AdapterFB)_blockFBNetworkElement).getAdapterDecl();
    }

    protected CharSequence generateAlgorithms() {
        StringConcatenation _builder = new StringConcatenation();
        EList _algorithm = ((BaseFBType)this.getType()).getAlgorithm();
        for (Algorithm algorithm : _algorithm) {
            CharSequence _generateAlgorithm = this.generateAlgorithm(algorithm);
            _builder.append((Object)_generateAlgorithm);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateAlgorithm(Algorithm alg) {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("void ");
            CharSequence _fBClassName = this.getFBClassName();
            _builder.append((Object)_fBClassName);
            _builder.append("::");
            CharSequence _generateAlgorithmName = this.generateAlgorithmName(alg);
            _builder.append((Object)_generateAlgorithmName);
            _builder.append("(void) {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            ILanguageSupport _get = this.algorithmLanguageSupport.get(alg);
            CharSequence _generate = null;
            if (_get != null) {
                _generate = _get.generate(CollectionLiterals.emptyMap());
            }
            _builder.append((Object)_generate, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            return _builder;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected CharSequence generateMethods() {
        try {
            StringConcatenation _builder = new StringConcatenation();
            EList _methods = ((BaseFBType)this.getType()).getMethods();
            for (Method method : _methods) {
                ILanguageSupport _get = this.methodLanguageSupport.get(method);
                CharSequence _generate = null;
                if (_get != null) {
                    _generate = _get.generate(CollectionLiterals.emptyMap());
                }
                _builder.append(_generate);
                _builder.newLineIfNotEmpty();
            }
            return _builder;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected CharSequence generateAlgorithmName(Algorithm alg) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("alg_");
        String _name = alg.getName();
        _builder.append(_name);
        return _builder;
    }

    protected abstract CharSequence generateExecuteEvent();

    @Override
    public List<String> getErrors() {
        List<String> _errors = super.getErrors();
        Collection<ILanguageSupport> _values = this.algorithmLanguageSupport.values();
        Collection<ILanguageSupport> _values_1 = this.methodLanguageSupport.values();
        Functions.Function1 _function = it -> it.getErrors();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull((Iterable)Iterables.concat(_values, _values_1)), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_errors, (Iterable)_set));
    }

    @Override
    public List<String> getWarnings() {
        List<String> _warnings = super.getWarnings();
        Collection<ILanguageSupport> _values = this.algorithmLanguageSupport.values();
        Collection<ILanguageSupport> _values_1 = this.methodLanguageSupport.values();
        Functions.Function1 _function = it -> it.getWarnings();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull((Iterable)Iterables.concat(_values, _values_1)), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_warnings, (Iterable)_set));
    }

    @Override
    public List<String> getInfos() {
        List<String> _infos = super.getInfos();
        Collection<ILanguageSupport> _values = this.algorithmLanguageSupport.values();
        Collection<ILanguageSupport> _values_1 = this.methodLanguageSupport.values();
        Functions.Function1 _function = it -> it.getInfos();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull((Iterable)Iterables.concat(_values, _values_1)), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_infos, (Iterable)_set));
    }

    @Override
    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        Set<INamedElement> _dependencies = super.getDependencies(options);
        Collection<ILanguageSupport> _values = this.algorithmLanguageSupport.values();
        Collection<ILanguageSupport> _values_1 = this.methodLanguageSupport.values();
        Functions.Function1 _function = it -> it.getDependencies(options);
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull((Iterable)Iterables.concat(_values, _values_1)), (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)Iterables.concat(_dependencies, (Iterable)_flatMap));
    }
}

