/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.cmake;

import java.nio.file.Path;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.forte_ng.ForteNgExportTemplate;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;

public class CMakeConfigTemplate
extends ForteNgExportTemplate {
    protected static final String HEADER = "# This file was generated using the 4DIAC FORTE Export Filter V1.0.x NG!\n\n";

    public CMakeConfigTemplate(IProject project) {
        super(CMakeConfigTemplate.generateConfigTemplateName(project), Path.of("", new String[0]));
    }

    public CharSequence generate() throws ExportException {
        StringBuilder builder = new StringBuilder();
        builder.append(HEADER);
        builder.append("@PACKAGE_INIT@").append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("include(${CMAKE_CURRENT_LIST_DIR}/@PROJECT_NAME@-export.cmake)");
        builder.append(System.lineSeparator());
        builder.append("check_required_components(@PROJECT_NAME@)");
        return builder;
    }

    protected static String generateConfigTemplateName(IProject project) {
        return "forte-" + CMakeConfigTemplate.getProjectName(project).toLowerCase() + "-config.cmake.in";
    }

    protected static String getProjectName(IProject project) {
        Manifest manifest = ManifestHelper.getContainerManifest((IContainer)project);
        if (manifest == null || manifest.getProduct() == null || manifest.getProduct().getSymbolicName() == null) {
            return project.getName();
        }
        return manifest.getProduct().getSymbolicName();
    }
}

