/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.cmake;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.forte_ng.cmake.CMakeListsTemplate;

public final class CMakeListsUtil {
    public static List<Path> getSubdirs(Path path2, String name) throws ExportException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> walk = Files.walk(path2.resolve(name), new FileVisitOption[0]);){
                return walk.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(path2::relativize).toList();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ExportException(e.getMessage());
        }
    }

    private CMakeListsUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean isSourceFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && CMakeListsTemplate.SOURCE_EXTENSIONS.contains(CMakeListsUtil.getFileExtension(path));
    }

    public static String getFileExtension(Path path) {
        String fileName = path.getFileName().toString();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot > 0) {
            return fileName.substring(lastDot);
        }
        return "";
    }
}

