/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.builder;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.IExportFilter;
import org.eclipse.fordiac.ide.export.Messages;
import org.eclipse.fordiac.ide.export.utils.ExportFilterUtil;
import org.eclipse.fordiac.ide.model.buildpath.Buildpath;
import org.eclipse.fordiac.ide.model.buildpath.BuildpathAttributes;
import org.eclipse.fordiac.ide.model.buildpath.SourceFolder;
import org.eclipse.fordiac.ide.model.buildpath.util.BuildpathUtil;
import org.eclipse.fordiac.ide.model.typelibrary.CMakeListsMarker;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class ExportBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.fordiac.ide.export.builder";
    private static final String FORTE_NG_FILTER_ID = "org.eclipse.fordiac.ide.export.exportFilter.forteNg";
    private static final Set<String> fileTypes = Set.of("ADP", "DTP", "FBT", "GCF", "FCT");

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (!this.isExportEnabled()) {
            return new IProject[0];
        }
        BuildContext context = this.createBuildContext();
        if (context.filter == null || !ExportFilterUtil.validateExportPath(context.outputDirectory, this.getProject())) {
            return new IProject[0];
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        progress.setTaskName(Messages.ExportBuilder_Build);
        switch (kind) {
            case 6: {
                this.fullBuild(progress.split(1), context);
                break;
            }
            case 9: 
            case 10: {
                IResourceDelta root = this.getDelta(this.getProject());
                if (root == null) break;
                this.incrementalBuild(root, progress.split(1), context);
                break;
            }
        }
        this.exportCmakeLists((IProgressMonitor)progress.split(1), context);
        context.filter.getErrors().forEach(e -> buildContext.status.add((IStatus)new Status(4, ((Object)((Object)this)).getClass(), e)));
        if (context.status.matches(4)) {
            throw new CoreException((IStatus)context.status);
        }
        return new IProject[0];
    }

    private void fullBuild(SubMonitor monitor, BuildContext context) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        List<SourceFolder> buildPathFolders = this.getExportableFoldersFromBuildpath();
        for (SourceFolder folder : buildPathFolders) {
            BuildpathUtil.acceptMatches((SourceFolder)folder, (IProject)this.getProject(), resource -> {
                IFile file;
                if (this.isExportCanceled((IProgressMonitor)progress)) {
                    throw new OperationCanceledException();
                }
                if (resource instanceof IFile && ExportBuilder.isExportableFileType(file = (IFile)resource)) {
                    this.exportElement(progress, file, context);
                } else if (resource instanceof IFolder || resource instanceof IProject) {
                    return true;
                }
                return false;
            });
        }
    }

    private void exportElement(SubMonitor monitor, IFile file, BuildContext context) {
        try {
            if (!ExportBuilder.hasRelevantErrorMarker(file)) {
                monitor.subTask(MessageFormat.format(Messages.FordiacExporter_ExportingType, file.getName()));
                context.filter.export(file, this.getProject().getLocation().append((IPath)new Path(context.outputDirectory)).toString(), true);
                monitor.split(1);
            }
        }
        catch (Exception e) {
            context.status.add((IStatus)new Status(4, ((Object)((Object)this)).getClass(), MessageFormat.format(Messages.ExportBuilder_CouldntExportFile, file.getName()), (Throwable)e));
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        if (!this.isExportEnabled()) {
            return;
        }
        String outputDirectory = this.getProjectPreferenceNode().get("OUTPUT_FOLDER", "out");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        progress.setTaskName(Messages.ExportBuilder_Clean);
        if (ExportFilterUtil.validateExportPath(outputDirectory, this.getProject()) && (folder = this.getProject().getFolder(outputDirectory)).exists()) {
            folder.delete(true, (IProgressMonitor)progress.split(1));
        }
    }

    private BuildContext createBuildContext() {
        String outputDirectory = this.getProjectPreferenceNode().get("OUTPUT_FOLDER", "out");
        String exportFilterID = this.getProjectPreferenceNode().get("EXPORT_FILTER_ID", "");
        Optional<IConfigurationElement> filterConfig = ExportFilterUtil.getExportFilter(exportFilterID);
        IExportFilter filter = filterConfig.isPresent() ? ExportFilterUtil.createExportFilter(filterConfig) : null;
        MultiStatus status = new MultiStatus(((Object)((Object)this)).getClass(), 0, "Export Builder Status");
        return new BuildContext(outputDirectory, filter, status);
    }

    private void incrementalBuild(IResourceDelta rootDelta, SubMonitor monitor, BuildContext context) throws CoreException {
        IResourceDelta[] iResourceDeltaArray = rootDelta.getAffectedChildren(261);
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IResourceDelta delta = iResourceDeltaArray[n2];
            if (this.isExportCanceled((IProgressMonitor)monitor)) {
                throw new OperationCanceledException();
            }
            IResource iResource = delta.getResource();
            if (iResource instanceof IFile && this.isExportable(file = (IFile)iResource)) {
                this.exportElement(monitor, file, context);
            } else if (delta.getResource() instanceof IFolder) {
                this.incrementalBuild(delta, monitor, context);
            }
            ++n2;
        }
    }

    private List<SourceFolder> getExportableFoldersFromBuildpath() {
        return this.getBuildpath().getSourceFolders().stream().filter(ExportBuilder::getExportAttributeValue).toList();
    }

    private boolean isExportable(IFile file) {
        if (ExportBuilder.isExportableFileType(file)) {
            Optional sourceFolder = BuildpathUtil.findSourceFolder((Buildpath)this.getBuildpath(), (IResource)file);
            return sourceFolder.isPresent() && ExportBuilder.getExportAttributeValue((SourceFolder)sourceFolder.get());
        }
        return false;
    }

    private static boolean isExportableFileType(IFile file) {
        return fileTypes.stream().anyMatch(type -> type.equalsIgnoreCase(file.getFileExtension()));
    }

    private IEclipsePreferences getProjectPreferenceNode() {
        ProjectScope projectScope = new ProjectScope(this.getProject());
        return projectScope.getNode("org.eclipse.fordiac.ide.export");
    }

    private boolean isExportEnabled() {
        return this.getProjectPreferenceNode().getBoolean("ENABLE_TYPE_EXPORT", false);
    }

    private Buildpath getBuildpath() {
        return TypeLibraryManager.INSTANCE.getTypeLibrary(this.getProject()).getBuildpath();
    }

    private static boolean getExportAttributeValue(SourceFolder folder) {
        String attributeValue = BuildpathAttributes.getAttributeValue((List)folder.getAttributes(), (String)"export");
        return !attributeValue.isEmpty() && Boolean.parseBoolean(attributeValue);
    }

    private void exportCmakeLists(IProgressMonitor monitor, BuildContext context) {
        if (this.isExportCanceled(monitor)) {
            throw new OperationCanceledException();
        }
        if (this.getProjectPreferenceNode().get("EXPORT_FILTER_ID", "").equals(FORTE_NG_FILTER_ID)) {
            IPath location = this.getProject().getLocation().append((IPath)new Path(context.outputDirectory));
            CMakeListsMarker marker = new CMakeListsMarker(this.getProject(), location.toPath());
            monitor.subTask(MessageFormat.format(Messages.FordiacExporter_ExportingType, marker.getName()));
            try {
                context.filter.export(null, location.toString(), true, (EObject)marker);
                monitor.worked(1);
            }
            catch (Exception e) {
                context.status.add((IStatus)new Status(4, ((Object)((Object)this)).getClass(), MessageFormat.format(Messages.ExportBuilder_CMakeListExportFailed, location.toOSString()), (Throwable)e));
            }
        }
    }

    private static boolean hasRelevantErrorMarker(IFile file) throws CoreException {
        return Arrays.stream(file.findMarkers("org.eclipse.fordiac.ide.model.problem", true, 2)).anyMatch(m -> m.getAttribute("severity", -1) == 2);
    }

    private boolean isExportCanceled(IProgressMonitor monitor) {
        return this.isInterrupted() || monitor.isCanceled();
    }

    private record BuildContext(String outputDirectory, IExportFilter filter, MultiStatus status) {
    }
}

